/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

class BigQueryAvroUtils {
    static final ImmutableMultimap<String, Schema.Type> BIG_QUERY_TO_AVRO_TYPES = ImmutableMultimap.builder().put((Object)"STRING", (Object)Schema.Type.STRING).put((Object)"GEOGRAPHY", (Object)Schema.Type.STRING).put((Object)"BYTES", (Object)Schema.Type.BYTES).put((Object)"INTEGER", (Object)Schema.Type.LONG).put((Object)"FLOAT", (Object)Schema.Type.DOUBLE).put((Object)"NUMERIC", (Object)Schema.Type.BYTES).put((Object)"BIGNUMERIC", (Object)Schema.Type.BYTES).put((Object)"BOOLEAN", (Object)Schema.Type.BOOLEAN).put((Object)"TIMESTAMP", (Object)Schema.Type.LONG).put((Object)"RECORD", (Object)Schema.Type.RECORD).put((Object)"DATE", (Object)Schema.Type.STRING).put((Object)"DATE", (Object)Schema.Type.INT).put((Object)"DATETIME", (Object)Schema.Type.STRING).put((Object)"TIME", (Object)Schema.Type.STRING).put((Object)"TIME", (Object)Schema.Type.LONG).build();
    private static final DateTimeFormatter DATE_AND_SECONDS_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();
    private static final java.time.format.DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_MICROS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 6, 6, false).toFormatter();
    private static final java.time.format.DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_MILLIS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, false).toFormatter();
    private static final java.time.format.DateTimeFormatter ISO_LOCAL_TIME_FORMATTER_SECONDS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    BigQueryAvroUtils() {
    }

    @VisibleForTesting
    static String formatTimestamp(Long timestampMicro) {
        long timestampSec = timestampMicro / 1000000L;
        long micros = timestampMicro % 1000000L;
        if (micros < 0L) {
            micros += 1000000L;
            --timestampSec;
        }
        String dayAndTime = DATE_AND_SECONDS_FORMATTER.print(timestampSec * 1000L);
        if (micros == 0L) {
            return String.format("%s UTC", dayAndTime);
        }
        return String.format("%s.%06d UTC", dayAndTime, micros);
    }

    private static String formatDate(int date) {
        return LocalDate.ofEpochDay(date).format(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE);
    }

    private static String formatTime(long timeMicros) {
        java.time.format.DateTimeFormatter formatter = timeMicros % 1000000L == 0L ? ISO_LOCAL_TIME_FORMATTER_SECONDS : (timeMicros % 1000L == 0L ? ISO_LOCAL_TIME_FORMATTER_MILLIS : ISO_LOCAL_TIME_FORMATTER_MICROS);
        return LocalTime.ofNanoOfDay(timeMicros * 1000L).format(formatter);
    }

    static TableSchema trimBigQueryTableSchema(TableSchema inputSchema, Schema avroSchema) {
        List subSchemas = inputSchema.getFields().stream().flatMap(fieldSchema -> BigQueryAvroUtils.mapTableFieldSchema(fieldSchema, avroSchema)).collect(Collectors.toList());
        return new TableSchema().setFields(subSchemas);
    }

    private static Stream<TableFieldSchema> mapTableFieldSchema(TableFieldSchema fieldSchema, Schema avroSchema) {
        Schema.Field avroFieldSchema = avroSchema.getField(fieldSchema.getName());
        if (avroFieldSchema == null) {
            return Stream.empty();
        }
        if (avroFieldSchema.schema().getType() != Schema.Type.RECORD) {
            return Stream.of(fieldSchema);
        }
        List subSchemas = fieldSchema.getFields().stream().flatMap(subSchema -> BigQueryAvroUtils.mapTableFieldSchema(subSchema, avroFieldSchema.schema())).collect(Collectors.toList());
        TableFieldSchema output = new TableFieldSchema().setCategories(fieldSchema.getCategories()).setDescription(fieldSchema.getDescription()).setFields(subSchemas).setMode(fieldSchema.getMode()).setName(fieldSchema.getName()).setType(fieldSchema.getType());
        return Stream.of(output);
    }

    static TableRow convertGenericRecordToTableRow(GenericRecord record, TableSchema schema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow(record, schema.getFields());
    }

    private static TableRow convertGenericRecordToTableRow(GenericRecord record, List<TableFieldSchema> fields) {
        TableRow row = new TableRow();
        for (TableFieldSchema subSchema : fields) {
            Schema.Field field = record.getSchema().getField(subSchema.getName());
            Object convertedValue = BigQueryAvroUtils.getTypedCellValue(field.schema(), subSchema, record.get(field.name()));
            if (convertedValue == null) continue;
            row.set(field.name(), convertedValue);
        }
        return row;
    }

    private static @Nullable Object getTypedCellValue(Schema schema, TableFieldSchema fieldSchema, Object v) {
        String mode;
        switch (mode = (String)MoreObjects.firstNonNull((Object)fieldSchema.getMode(), (Object)"NULLABLE")) {
            case "REQUIRED": {
                return BigQueryAvroUtils.convertRequiredField(schema.getType(), schema.getLogicalType(), fieldSchema, v);
            }
            case "REPEATED": {
                return BigQueryAvroUtils.convertRepeatedField(schema, fieldSchema, v);
            }
            case "NULLABLE": {
                return BigQueryAvroUtils.convertNullableField(schema, fieldSchema, v);
            }
        }
        throw new UnsupportedOperationException("Parsing a field with BigQuery field schema mode " + fieldSchema.getMode());
    }

    private static List<Object> convertRepeatedField(Schema schema, TableFieldSchema fieldSchema, Object v) {
        Schema.Type arrayType = schema.getType();
        Verify.verify((arrayType == Schema.Type.ARRAY ? 1 : 0) != 0, (String)"BigQuery REPEATED field %s should be Avro ARRAY, not %s", (Object)fieldSchema.getName(), (Object)arrayType);
        if (v == null) {
            return new ArrayList<Object>();
        }
        List elements = (List)v;
        ArrayList<Object> values = new ArrayList<Object>();
        Schema.Type elementType = schema.getElementType().getType();
        LogicalType elementLogicalType = schema.getElementType().getLogicalType();
        for (Object element : elements) {
            values.add(BigQueryAvroUtils.convertRequiredField(elementType, elementLogicalType, fieldSchema, element));
        }
        return values;
    }

    private static Object convertRequiredField(Schema.Type avroType, LogicalType avroLogicalType, TableFieldSchema fieldSchema, Object v) {
        Preconditions.checkNotNull((Object)v, (String)"REQUIRED field %s should not be null", (Object)fieldSchema.getName());
        String bqType = fieldSchema.getType();
        ImmutableCollection expectedAvroTypes = BIG_QUERY_TO_AVRO_TYPES.get((Object)bqType);
        Verify.verifyNotNull((Object)expectedAvroTypes, (String)"Unsupported BigQuery type: %s", (Object[])new Object[]{bqType});
        Verify.verify((boolean)expectedAvroTypes.contains((Object)avroType), (String)"Expected Avro schema types %s for BigQuery %s field %s, but received %s", (Object)expectedAvroTypes, (Object)bqType, (Object)fieldSchema.getName(), (Object)avroType);
        switch (bqType) {
            case "STRING": 
            case "DATETIME": 
            case "GEOGRAPHY": {
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "DATE": {
                if (avroType == Schema.Type.INT) {
                    Verify.verify((boolean)(v instanceof Integer), (String)"Expected Integer, got %s", v.getClass());
                    Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected Date logical type", (Object[])new Object[0]);
                    Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.Date), (String)"Expected Date logical type", (Object[])new Object[0]);
                    return BigQueryAvroUtils.formatDate((Integer)v);
                }
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "TIME": {
                if (avroType == Schema.Type.LONG) {
                    Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", v.getClass());
                    Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected TimeMicros logical type", (Object[])new Object[0]);
                    Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.TimeMicros), (String)"Expected TimeMicros logical type", (Object[])new Object[0]);
                    return BigQueryAvroUtils.formatTime((Long)v);
                }
                Verify.verify((boolean)(v instanceof CharSequence), (String)"Expected CharSequence (String), got %s", v.getClass());
                return v.toString();
            }
            case "INTEGER": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", v.getClass());
                return ((Long)v).toString();
            }
            case "FLOAT": {
                Verify.verify((boolean)(v instanceof Double), (String)"Expected Double, got %s", v.getClass());
                return v;
            }
            case "NUMERIC": 
            case "BIGNUMERIC": {
                Verify.verify((boolean)(v instanceof ByteBuffer), (String)"Expected ByteBuffer, got %s", v.getClass());
                Verify.verifyNotNull((Object)avroLogicalType, (String)"Expected Decimal logical type", (Object[])new Object[0]);
                Verify.verify((boolean)(avroLogicalType instanceof LogicalTypes.Decimal), (String)"Expected Decimal logical type", (Object[])new Object[0]);
                BigDecimal numericValue = new Conversions.DecimalConversion().fromBytes((ByteBuffer)v, Schema.create((Schema.Type)avroType), avroLogicalType);
                return numericValue.toString();
            }
            case "BOOL": 
            case "BOOLEAN": {
                Verify.verify((boolean)(v instanceof Boolean), (String)"Expected Boolean, got %s", v.getClass());
                return v;
            }
            case "TIMESTAMP": {
                Verify.verify((boolean)(v instanceof Long), (String)"Expected Long, got %s", v.getClass());
                return BigQueryAvroUtils.formatTimestamp((Long)v);
            }
            case "RECORD": {
                Verify.verify((boolean)(v instanceof GenericRecord), (String)"Expected GenericRecord, got %s", v.getClass());
                return BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)v, fieldSchema.getFields());
            }
            case "BYTES": {
                Verify.verify((boolean)(v instanceof ByteBuffer), (String)"Expected ByteBuffer, got %s", v.getClass());
                ByteBuffer byteBuffer = (ByteBuffer)v;
                byte[] bytes = new byte[byteBuffer.limit()];
                byteBuffer.get(bytes);
                return BaseEncoding.base64().encode(bytes);
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected BigQuery field schema type %s for field named %s", fieldSchema.getType(), fieldSchema.getName()));
    }

    private static @Nullable Object convertNullableField(Schema avroSchema, TableFieldSchema fieldSchema, Object v) {
        Verify.verify((avroSchema.getType() == Schema.Type.UNION ? 1 : 0) != 0, (String)"Expected Avro schema type UNION, not %s, for BigQuery NULLABLE field %s", (Object)avroSchema.getType(), (Object)fieldSchema.getName());
        List unionTypes = avroSchema.getTypes();
        Verify.verify((unionTypes.size() == 2 ? 1 : 0) != 0, (String)"BigQuery NULLABLE field %s should be an Avro UNION of NULL and another type, not %s", (Object)fieldSchema.getName(), (Object)unionTypes);
        if (v == null) {
            return null;
        }
        Schema.Type firstType = ((Schema)unionTypes.get(0)).getType();
        if (!firstType.equals((Object)Schema.Type.NULL)) {
            return BigQueryAvroUtils.convertRequiredField(firstType, ((Schema)unionTypes.get(0)).getLogicalType(), fieldSchema, v);
        }
        return BigQueryAvroUtils.convertRequiredField(((Schema)unionTypes.get(1)).getType(), ((Schema)unionTypes.get(1)).getLogicalType(), fieldSchema, v);
    }

    static Schema toGenericAvroSchema(String schemaName, List<TableFieldSchema> fieldSchemas) {
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (TableFieldSchema bigQueryField : fieldSchemas) {
            avroFields.add(BigQueryAvroUtils.convertField(bigQueryField));
        }
        return Schema.createRecord((String)schemaName, (String)("Translated Avro Schema for " + schemaName), (String)"org.apache.beam.sdk.io.gcp.bigquery", (boolean)false, avroFields);
    }

    private static Schema.Field convertField(TableFieldSchema bigQueryField) {
        Schema fieldSchema;
        ImmutableCollection avroTypes = BIG_QUERY_TO_AVRO_TYPES.get((Object)bigQueryField.getType());
        if (avroTypes.isEmpty()) {
            throw new IllegalArgumentException("Unable to map BigQuery field type " + bigQueryField.getType() + " to avro type.");
        }
        Schema.Type avroType = (Schema.Type)avroTypes.iterator().next();
        Schema elementSchema = avroType == Schema.Type.RECORD ? BigQueryAvroUtils.toGenericAvroSchema(bigQueryField.getName(), bigQueryField.getFields()) : Schema.create((Schema.Type)avroType);
        if (bigQueryField.getMode() == null || "NULLABLE".equals(bigQueryField.getMode())) {
            fieldSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), elementSchema});
        } else if ("REQUIRED".equals(bigQueryField.getMode())) {
            fieldSchema = elementSchema;
        } else if ("REPEATED".equals(bigQueryField.getMode())) {
            fieldSchema = Schema.createArray((Schema)elementSchema);
        } else {
            throw new IllegalArgumentException(String.format("Unknown BigQuery Field Mode: %s", bigQueryField.getMode()));
        }
        return new Schema.Field(bigQueryField.getName(), fieldSchema, bigQueryField.getDescription(), null);
    }
}

