/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.time.Duration;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;

public class StorageApiDynamicDestinationsTableRow<T, DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final SerializableFunction<T, TableRow> formatFunction;
    private final Cache<DestinationT, Descriptors.Descriptor> destinationDescriptorCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).build();

    StorageApiDynamicDestinationsTableRow(DynamicDestinations<T, DestinationT> inner, SerializableFunction<T, TableRow> formatFunction) {
        super(inner);
        this.formatFunction = formatFunction;
    }

    @Override
    public StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(final DestinationT destination) throws Exception {
        final TableSchema tableSchema = this.getSchema((Object)destination);
        if (tableSchema == null) {
            throw new RuntimeException("Schema must be set when writing TableRows using Storage API. Use BigQueryIO.Write.withSchema to set the schema.");
        }
        return new StorageApiDynamicDestinations.MessageConverter<T>(){
            Descriptors.Descriptor descriptor;
            {
                this.descriptor = (Descriptors.Descriptor)StorageApiDynamicDestinationsTableRow.this.destinationDescriptorCache.get(destination, () -> TableRowToStorageApiProto.getDescriptorFromTableSchema(tableSchema));
            }

            @Override
            public Descriptors.Descriptor getSchemaDescriptor() {
                return this.descriptor;
            }

            @Override
            public Message toMessage(T element) {
                return TableRowToStorageApiProto.messageFromTableRow(this.descriptor, (TableRow)StorageApiDynamicDestinationsTableRow.this.formatFunction.apply(element));
            }
        };
    }
}

