/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;

public class TableDestination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableSpec;
    @Nullable
    private final String tableDescription;
    @Nullable
    private final String jsonTimePartitioning;

    public TableDestination(String tableSpec, @Nullable String tableDescription) {
        this(tableSpec, tableDescription, (String)null);
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription) {
        this(tableReference, tableDescription, null);
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription, TimePartitioning timePartitioning) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null);
    }

    public TableDestination(String tableSpec, @Nullable String tableDescription, TimePartitioning timePartitioning) {
        this(tableSpec, tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null);
    }

    public TableDestination(String tableSpec, @Nullable String tableDescription, @Nullable String jsonTimePartitioning) {
        this.tableSpec = tableSpec;
        this.tableDescription = tableDescription;
        this.jsonTimePartitioning = jsonTimePartitioning;
    }

    public String getTableSpec() {
        return this.tableSpec;
    }

    public TableReference getTableReference() {
        return BigQueryHelpers.parseTableSpec(this.tableSpec);
    }

    public String getJsonTimePartitioning() {
        return this.jsonTimePartitioning;
    }

    public TimePartitioning getTimePartitioning() {
        if (this.jsonTimePartitioning == null) {
            return null;
        }
        return BigQueryHelpers.fromJsonString(this.jsonTimePartitioning, TimePartitioning.class);
    }

    @Nullable
    public String getTableDescription() {
        return this.tableDescription;
    }

    public String toString() {
        String toString = "tableSpec: " + this.tableSpec;
        if (this.tableDescription != null) {
            toString = toString + " tableDescription: " + this.tableDescription;
        }
        return toString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableDestination)) {
            return false;
        }
        TableDestination other = (TableDestination)o;
        return Objects.equals(this.tableSpec, other.tableSpec) && Objects.equals(this.tableDescription, other.tableDescription) && Objects.equals(this.jsonTimePartitioning, other.jsonTimePartitioning);
    }

    public int hashCode() {
        return Objects.hash(this.tableSpec, this.tableDescription, this.jsonTimePartitioning);
    }
}

