/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;

@VisibleForTesting
class PassThroughThenCleanup<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private CleanupOperation cleanupOperation;
    private PCollectionView<String> jobIdSideInput;

    PassThroughThenCleanup(CleanupOperation cleanupOperation, PCollectionView<String> jobIdSideInput) {
        this.cleanupOperation = cleanupOperation;
        this.jobIdSideInput = jobIdSideInput;
    }

    public PCollection<T> expand(PCollection<T> input) {
        TupleTag mainOutput = new TupleTag();
        TupleTag cleanupSignal = new TupleTag();
        PCollectionTuple outputs = (PCollectionTuple)input.apply((PTransform)ParDo.of(new IdentityFn()).withOutputTags(mainOutput, TupleTagList.of((TupleTag)cleanupSignal)));
        PCollectionView cleanupSignalView = (PCollectionView)outputs.get(cleanupSignal).setCoder((Coder)VoidCoder.of()).apply((PTransform)View.asIterable());
        ((PCollection)input.getPipeline().apply("Create(CleanupOperation)", (PTransform)Create.of((Object)this.cleanupOperation, (Object[])new CleanupOperation[0]))).apply("Cleanup", (PTransform)ParDo.of((DoFn)new DoFn<CleanupOperation, Void>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                ((CleanupOperation)c.element()).cleanup(new ContextContainer(c, (PCollectionView<String>)PassThroughThenCleanup.this.jobIdSideInput));
            }
        }).withSideInputs(new PCollectionView[]{this.jobIdSideInput, cleanupSignalView}));
        return outputs.get(mainOutput).setCoder(input.getCoder());
    }

    static class ContextContainer {
        private PCollectionView<String> view;
        private DoFn.ProcessContext context;

        public ContextContainer(DoFn.ProcessContext context, PCollectionView<String> view) {
            this.view = view;
            this.context = context;
        }

        public PipelineOptions getPipelineOptions() {
            return this.context.getPipelineOptions();
        }

        public String getJobId() {
            return (String)this.context.sideInput(this.view);
        }
    }

    static abstract class CleanupOperation
    implements Serializable {
        CleanupOperation() {
        }

        abstract void cleanup(ContextContainer var1) throws Exception;
    }

    private static class IdentityFn<T>
    extends DoFn<T, T> {
        private IdentityFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output(c.element());
        }
    }
}

