/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.TypeToken;

class Publishers {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    private Publishers() {
    }

    static Publisher<PublishMetadata> newPublisher(PublisherOptions options) throws ApiException {
        SerializableSupplier<Object> supplier = options.publisherSupplier();
        if (supplier != null) {
            Object supplied = supplier.get();
            TypeToken<Publisher<PublishMetadata>> token = new TypeToken<Publisher<PublishMetadata>>(){};
            UncheckedApiPreconditions.checkArgument((boolean)token.isSupertypeOf(supplied.getClass()));
            return (Publisher)supplied;
        }
        return new PartitionCountWatchingPublisher(PartitionCountWatchingPublisherSettings.newBuilder().setTopic(options.topicPath()).setPublisherFactory(partition -> SinglePartitionPublisherBuilder.newBuilder().setTopic(options.topicPath()).setPartition(partition).setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK)).build()).build());
    }
}

