/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.TopicPath;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_PublisherOptions
extends PublisherOptions {
    private final TopicPath topicPath;
    private final @Nullable SerializableSupplier<Object> publisherSupplier;
    private static final long serialVersionUID = 275311613L;

    private AutoValue_PublisherOptions(TopicPath topicPath, @Nullable SerializableSupplier<Object> publisherSupplier) {
        this.topicPath = topicPath;
        this.publisherSupplier = publisherSupplier;
    }

    @Override
    public TopicPath topicPath() {
        return this.topicPath;
    }

    @Override
    public @Nullable SerializableSupplier<Object> publisherSupplier() {
        return this.publisherSupplier;
    }

    public String toString() {
        return "PublisherOptions{topicPath=" + this.topicPath + ", publisherSupplier=" + this.publisherSupplier + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublisherOptions) {
            PublisherOptions that = (PublisherOptions)o;
            return this.topicPath.equals(that.topicPath()) && (this.publisherSupplier == null ? that.publisherSupplier() == null : this.publisherSupplier.equals(that.publisherSupplier()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicPath.hashCode();
        h$ *= 1000003;
        return h$ ^= this.publisherSupplier == null ? 0 : this.publisherSupplier.hashCode();
    }

    static final class Builder
    extends PublisherOptions.Builder {
        private TopicPath topicPath;
        private @Nullable SerializableSupplier<Object> publisherSupplier;

        Builder() {
        }

        @Override
        public PublisherOptions.Builder setTopicPath(TopicPath topicPath) {
            if (topicPath == null) {
                throw new NullPointerException("Null topicPath");
            }
            this.topicPath = topicPath;
            return this;
        }

        @Override
        public PublisherOptions.Builder setPublisherSupplier(SerializableSupplier<Object> publisherSupplier) {
            this.publisherSupplier = publisherSupplier;
            return this;
        }

        @Override
        public PublisherOptions build() {
            String missing = "";
            if (this.topicPath == null) {
                missing = missing + " topicPath";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublisherOptions(this.topicPath, this.publisherSupplier);
        }
    }
}

