/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.RunnerImplementedSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;

public class RunnerImplementedSourceTranslation {

    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(RunnerImplementedSource.class, new RunnerImplementedSourceTranslator());
        }
    }

    static class RunnerImplementedSourceTranslator
    implements PTransformTranslation.TransformPayloadTranslator<RunnerImplementedSource> {
        RunnerImplementedSourceTranslator() {
        }

        public String getUrn(RunnerImplementedSource transform) {
            return "beam:transform:pubsub_read:v1";
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, RunnerImplementedSource> transform, SdkComponents components) {
            ValueProvider<PubsubClient.SubscriptionPath> subscriptionProvider;
            RunnerApi.PubSubReadPayload.Builder payloadBuilder = RunnerApi.PubSubReadPayload.newBuilder();
            ValueProvider<PubsubClient.TopicPath> topicProvider = ((RunnerImplementedSource)transform.getTransform()).getTopicProvider();
            if (topicProvider != null) {
                if (topicProvider.isAccessible()) {
                    payloadBuilder.setTopic(((PubsubClient.TopicPath)topicProvider.get()).getFullPath());
                } else {
                    payloadBuilder.setTopicRuntimeOverridden(((ValueProvider.NestedValueProvider)topicProvider).propertyName());
                }
            }
            if ((subscriptionProvider = ((RunnerImplementedSource)transform.getTransform()).getSubscriptionProvider()) != null) {
                if (subscriptionProvider.isAccessible()) {
                    payloadBuilder.setSubscription(((PubsubClient.SubscriptionPath)subscriptionProvider.get()).getFullPath());
                } else {
                    payloadBuilder.setSubscriptionRuntimeOverridden(((ValueProvider.NestedValueProvider)subscriptionProvider).propertyName());
                }
            }
            if (((RunnerImplementedSource)transform.getTransform()).getTimestampAttribute() != null) {
                payloadBuilder.setTimestampAttribute(((RunnerImplementedSource)transform.getTransform()).getTimestampAttribute());
            }
            if (((RunnerImplementedSource)transform.getTransform()).getIdAttribute() != null) {
                payloadBuilder.setIdAttribute(((RunnerImplementedSource)transform.getTransform()).getIdAttribute());
            }
            payloadBuilder.setWithAttributes(((RunnerImplementedSource)transform.getTransform()).isWithAttributes());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((RunnerImplementedSource)transform.getTransform())).setPayload(payloadBuilder.build().toByteString()).build();
        }
    }
}

