/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

@Internal
public class RunnerImplementedSource
extends PTransform<PBegin, PCollection<byte[]>> {
    private final PubsubUnboundedSource source;

    public RunnerImplementedSource(PubsubUnboundedSource source) {
        this.source = source;
    }

    public PubsubUnboundedSource getOverriddenSource() {
        return this.source;
    }

    public ValueProvider<PubsubClient.TopicPath> getTopicProvider() {
        return this.source.getTopicProvider();
    }

    public ValueProvider<PubsubClient.SubscriptionPath> getSubscriptionProvider() {
        return this.source.getSubscriptionProvider();
    }

    public String getTimestampAttribute() {
        return this.source.getTimestampAttribute();
    }

    public String getIdAttribute() {
        return this.source.getIdAttribute();
    }

    public boolean isWithAttributes() {
        return this.source.getNeedsAttributes() || this.source.getNeedsMessageId();
    }

    public PCollection<byte[]> expand(PBegin input) {
        ByteArrayCoder coder = ByteArrayCoder.of();
        return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)coder).setCoder((Coder)coder);
    }

    protected String getKindString() {
        return "RunnerImplementedSource";
    }
}

