/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.RunnerImplementedSink;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;

public class RunnerImplementedSinkTranslation {

    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(RunnerImplementedSink.class, new RunnerImplementedSinkTranslator());
        }
    }

    static class RunnerImplementedSinkTranslator
    implements PTransformTranslation.TransformPayloadTranslator<RunnerImplementedSink> {
        RunnerImplementedSinkTranslator() {
        }

        public String getUrn(RunnerImplementedSink transform) {
            return "beam:transform:pubsub_write:v1";
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, RunnerImplementedSink> transform, SdkComponents components) {
            RunnerApi.PubSubWritePayload.Builder payloadBuilder = RunnerApi.PubSubWritePayload.newBuilder();
            ValueProvider<PubsubClient.TopicPath> topicProvider = ((RunnerImplementedSink)transform.getTransform()).getTopicProvider();
            if (topicProvider.isAccessible()) {
                payloadBuilder.setTopic(((PubsubClient.TopicPath)topicProvider.get()).getFullPath());
            } else {
                payloadBuilder.setTopicRuntimeOverridden(((ValueProvider.NestedValueProvider)topicProvider).propertyName());
            }
            if (((RunnerImplementedSink)transform.getTransform()).getTimestampAttribute() != null) {
                payloadBuilder.setTimestampAttribute(((RunnerImplementedSink)transform.getTransform()).getTimestampAttribute());
            }
            if (((RunnerImplementedSink)transform.getTransform()).getIdAttribute() != null) {
                payloadBuilder.setIdAttribute(((RunnerImplementedSink)transform.getTransform()).getIdAttribute());
            }
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((RunnerImplementedSink)transform.getTransform())).setPayload(payloadBuilder.build().toByteString()).build();
        }
    }
}

