/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageSourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryStorageTableSource<T>
extends BigQueryStorageSourceBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryStorageTableSource.class);
    private final ValueProvider<TableReference> tableReferenceProvider;
    private transient AtomicReference<Table> cachedTable;

    public static <T> BigQueryStorageTableSource<T> create(ValueProvider<TableReference> tableRefProvider, @Nullable ValueProvider<List<String>> selectedFields, @Nullable ValueProvider<String> rowRestriction, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        return new BigQueryStorageTableSource<T>(tableRefProvider, selectedFields, rowRestriction, parseFn, outputCoder, bqServices);
    }

    private BigQueryStorageTableSource(ValueProvider<TableReference> tableRefProvider, @Nullable ValueProvider<List<String>> selectedFields, @Nullable ValueProvider<String> rowRestriction, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        super(selectedFields, rowRestriction, parseFn, outputCoder, bqServices);
        this.tableReferenceProvider = (ValueProvider)Preconditions.checkNotNull(tableRefProvider, (Object)"tableRefProvider");
        this.cachedTable = new AtomicReference();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.cachedTable = new AtomicReference();
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTable(this.tableReferenceProvider)).withLabel("Table"));
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return this.getTargetTable((BigQueryOptions)options.as(BigQueryOptions.class)).getNumBytes();
    }

    @Override
    protected Table getTargetTable(BigQueryOptions options) throws Exception {
        if (this.cachedTable.get() == null) {
            TableReference tableReference = (TableReference)this.tableReferenceProvider.get();
            if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                Preconditions.checkState((!Strings.isNullOrEmpty((String)options.getProject()) ? 1 : 0) != 0, (String)"No project ID set in %s or %s, cannot construct a complete %s", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName(), (Object)TableReference.class.getSimpleName());
                LOG.info("Project ID not set in {}. Using default project from {}.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
                tableReference.setProjectId(options.getProject());
            }
            Table table = this.bqServices.getDatasetService(options).getTable(tableReference);
            this.cachedTable.compareAndSet(null, table);
        }
        return this.cachedTable.get();
    }
}

