/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;

final class StructUtils {
    StructUtils() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @UnknownKeyFor @NonNull @Initialized Row structToBeamRow(@UnknownKeyFor @NonNull @Initialized Struct struct, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        @Nullable Map structValues = schema.getFields().stream().collect(HashMap::new, (map, field) -> map.put(field.getName(), StructUtils.getStructValue(struct, field)), Map::putAll);
        return Row.withSchema((Schema)schema).withFieldValues(structValues).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Struct beamRowToStruct(@UnknownKeyFor @NonNull @Initialized Row row) {
        Struct.Builder structBuilder = Struct.newBuilder();
        List fields = row.getSchema().getFields();
        fields.forEach(field -> {
            String column = field.getName();
            switch (field.getType().getTypeName()) {
                case ROW: {
                    Row subRow = row.getRow(column);
                    if (subRow == null) {
                        structBuilder.set(column).to(StructUtils.beamTypeToSpannerType(field.getType()), null);
                        break;
                    }
                    structBuilder.set(column).to(StructUtils.beamTypeToSpannerType(field.getType()), StructUtils.beamRowToStruct(subRow));
                    break;
                }
                case ARRAY: {
                    StructUtils.addIterableToStructBuilder(structBuilder, row.getArray(column), field);
                    break;
                }
                case ITERABLE: {
                    StructUtils.addIterableToStructBuilder(structBuilder, row.getIterable(column), field);
                    break;
                }
                case FLOAT: {
                    Float floatValue = row.getFloat(column);
                    if (floatValue == null) {
                        structBuilder.set(column).to((Double)null);
                        break;
                    }
                    structBuilder.set(column).to((double)floatValue.floatValue());
                    break;
                }
                case DOUBLE: {
                    structBuilder.set(column).to(row.getDouble(column));
                    break;
                }
                case INT16: {
                    Short int16 = row.getInt16(column);
                    if (int16 == null) {
                        structBuilder.set(column).to((Long)null);
                        break;
                    }
                    structBuilder.set(column).to((long)int16.shortValue());
                    break;
                }
                case INT32: {
                    Integer int32 = row.getInt32(column);
                    if (int32 == null) {
                        structBuilder.set(column).to((Long)null);
                        break;
                    }
                    structBuilder.set(column).to((long)int32.intValue());
                    break;
                }
                case INT64: {
                    structBuilder.set(column).to(row.getInt64(column));
                    break;
                }
                case DECIMAL: {
                    BigDecimal decimal = row.getDecimal(column);
                    if (decimal == null) {
                        Preconditions.checkNotNull((Object)decimal, (Object)("Null decimal at column " + column));
                        break;
                    }
                    structBuilder.set(column).to(decimal);
                    break;
                }
                case DATETIME: {
                    ReadableDateTime dateTime = row.getDateTime(column);
                    if (dateTime == null) {
                        structBuilder.set(column).to((Timestamp)null);
                        break;
                    }
                    structBuilder.set(column).to(Timestamp.parseTimestamp((String)dateTime.toString()));
                    break;
                }
                case STRING: {
                    structBuilder.set(column).to(row.getString(column));
                    break;
                }
                case BYTE: {
                    Byte byteValue = row.getByte(column);
                    if (byteValue == null) {
                        structBuilder.set(column).to((Long)null);
                        break;
                    }
                    structBuilder.set(column).to((long)byteValue.byteValue());
                    break;
                }
                case BYTES: {
                    byte[] bytes = row.getBytes(column);
                    if (bytes == null) {
                        structBuilder.set(column).to((ByteArray)null);
                        break;
                    }
                    structBuilder.set(column).to(ByteArray.copyFrom((byte[])bytes));
                    break;
                }
                case BOOLEAN: {
                    structBuilder.set(column).to(row.getBoolean(column));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported beam type '%s' while translating row to struct.", field.getType().getTypeName()));
                }
            }
        });
        return structBuilder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Type beamTypeToSpannerType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamType) {
        switch (beamType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                Schema.FieldType elementType = beamType.getCollectionElementType();
                if (elementType == null) {
                    throw new NullPointerException("Null element type");
                }
                return Type.array((Type)StructUtils.simpleBeamTypeToSpannerType(elementType));
            }
        }
        return StructUtils.simpleBeamTypeToSpannerType(beamType);
    }

    private static @UnknownKeyFor @NonNull @Initialized Type simpleBeamTypeToSpannerType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamType) {
        switch (beamType.getTypeName()) {
            case ROW: {
                Schema schema = beamType.getRowSchema();
                if (schema == null) {
                    throw new NullPointerException("Null schema");
                }
                return Type.struct(StructUtils.translateRowFieldsToStructFields(schema.getFields()));
            }
            case BYTES: {
                return Type.bytes();
            }
            case BYTE: 
            case INT64: 
            case INT32: 
            case INT16: {
                return Type.int64();
            }
            case DOUBLE: 
            case FLOAT: {
                return Type.float64();
            }
            case DECIMAL: {
                return Type.numeric();
            }
            case STRING: {
                return Type.string();
            }
            case BOOLEAN: {
                return Type.bool();
            }
            case DATETIME: {
                return Type.timestamp();
            }
        }
        throw new IllegalArgumentException(String.format("Unable to translate beam type %s to Spanner type", beamType.getTypeName()));
    }

    private static @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Type.StructField> translateRowFieldsToStructFields(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field> rowFields) {
        return rowFields.stream().map(field -> Type.StructField.of((String)field.getName(), (Type)StructUtils.beamTypeToSpannerType(field.getType()))).collect(Collectors.toList());
    }

    private static void addIterableToStructBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Struct.Builder structBuilder, @Nullable @UnknownKeyFor @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> iterable, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        String column = field.getName();
        Schema.FieldType beamIterableType = field.getType().getCollectionElementType();
        if (beamIterableType == null) {
            throw new NullPointerException("Null collection element type at field " + field.getName());
        }
        Schema.TypeName beamIterableTypeName = beamIterableType.getTypeName();
        switch (beamIterableTypeName) {
            case ROW: {
                if (iterable == null) {
                    structBuilder.set(column).toStructArray(StructUtils.beamTypeToSpannerType(beamIterableType), null);
                    break;
                }
                structBuilder.set(column).toStructArray(StructUtils.beamTypeToSpannerType(beamIterableType), (Iterable)StreamSupport.stream(iterable.spliterator(), false).map(row -> StructUtils.beamRowToStruct((Row)row)).collect(Collectors.toList()));
                break;
            }
            case BYTE: 
            case INT64: 
            case INT32: 
            case INT16: {
                structBuilder.set(column).toInt64Array(iterable);
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                structBuilder.set(column).toFloat64Array(iterable);
                break;
            }
            case DECIMAL: {
                structBuilder.set(column).toNumericArray(iterable);
                break;
            }
            case BOOLEAN: {
                structBuilder.set(column).toBoolArray(iterable);
                break;
            }
            case BYTES: {
                if (iterable == null) {
                    structBuilder.set(column).toBytesArray(null);
                    break;
                }
                structBuilder.set(column).toBytesArray((Iterable)StreamSupport.stream(iterable.spliterator(), false).map(bytes -> ByteArray.copyFrom((byte[])((byte[])bytes))).collect(Collectors.toList()));
                break;
            }
            case STRING: {
                structBuilder.set(column).toStringArray(iterable);
                break;
            }
            case DATETIME: {
                if (iterable == null) {
                    structBuilder.set(column).toTimestampArray(null);
                    break;
                }
                structBuilder.set(column).toTimestampArray((Iterable)StreamSupport.stream(iterable.spliterator(), false).map(timestamp -> Timestamp.parseTimestamp((String)timestamp.toString())).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported iterable type '%s' while translating row to struct.", beamIterableType.getTypeName()));
            }
        }
    }

    private static @Nullable @UnknownKeyFor @Initialized Object getStructValue(@UnknownKeyFor @NonNull @Initialized Struct struct, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        String column = field.getName();
        Type.Code typeCode = struct.getColumnType(column).getCode();
        if (struct.isNull(column)) {
            return null;
        }
        switch (typeCode) {
            case BOOL: {
                return struct.getBoolean(column);
            }
            case BYTES: {
                return struct.getBytes(column).toByteArray();
            }
            case TIMESTAMP: {
                return Instant.ofEpochSecond((long)struct.getTimestamp(column).getSeconds()).toDateTime();
            }
            case DATE: {
                return DateTime.parse((String)struct.getDate(column).toString());
            }
            case INT64: {
                return struct.getLong(column);
            }
            case FLOAT64: {
                return struct.getDouble(column);
            }
            case NUMERIC: {
                return struct.getBigDecimal(column);
            }
            case STRING: {
                return struct.getString(column);
            }
            case ARRAY: {
                return StructUtils.getStructArrayValue(struct, struct.getColumnType(column).getArrayElementType(), field);
            }
            case STRUCT: {
                Schema schema = field.getType().getRowSchema();
                if (schema == null) {
                    throw new NullPointerException("Null schema at field " + field.getName());
                }
                return StructUtils.structToBeamRow(struct.getStruct(column), schema);
            }
        }
        throw new RuntimeException(String.format("Unsupported spanner type %s for column %s.", typeCode, column));
    }

    private static @Nullable @UnknownKeyFor @Initialized Object getStructArrayValue(@UnknownKeyFor @NonNull @Initialized Struct struct, @UnknownKeyFor @NonNull @Initialized Type arrayType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        Type.Code arrayCode = arrayType.getCode();
        String column = field.getName();
        if (struct.isNull(column)) {
            return null;
        }
        switch (arrayCode) {
            case BOOL: {
                return struct.getBooleanList(column);
            }
            case BYTES: {
                return struct.getBytesList(column);
            }
            case TIMESTAMP: {
                return struct.getTimestampList(column).stream().map(timestamp -> Instant.ofEpochSecond((long)timestamp.getSeconds()).toDateTime()).collect(Collectors.toList());
            }
            case DATE: {
                return struct.getDateList(column).stream().map(date -> DateTime.parse((String)date.toString())).collect(Collectors.toList());
            }
            case INT64: {
                return struct.getLongList(column);
            }
            case FLOAT64: {
                return struct.getDoubleList(column);
            }
            case STRING: {
                return struct.getStringList(column);
            }
            case NUMERIC: {
                return struct.getBigDecimal(column);
            }
            case ARRAY: {
                throw new IllegalStateException(String.format("Column %s has array of arrays which is prohibited in Spanner.", column));
            }
            case STRUCT: {
                return struct.getStructList(column).stream().map(structElem -> {
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @Nullable Schema.FieldType fieldType = field.getType().getCollectionElementType();
                    if (fieldType == null) {
                        throw new NullPointerException("Null collection element type at field " + field.getName());
                    }
                    @Nullable Schema elementSchema = fieldType.getRowSchema();
                    if (elementSchema == null) {
                        throw new NullPointerException("Null schema element type at field " + field.getName());
                    }
                    return StructUtils.structToBeamRow(structElem, elementSchema);
                }).collect(Collectors.toList());
            }
        }
        throw new RuntimeException(String.format("Unsupported spanner array type %s for column %s.", arrayCode, column));
    }
}

