/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientSettings;
import com.google.cloud.pubsublite.proto.Subscription;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_TopicBacklogReaderSettings;
import org.apache.beam.sdk.io.gcp.pubsublite.LimitingTopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReaderImpl;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Ticker;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class TopicBacklogReaderSettings
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -4001752066450248673L;

    TopicBacklogReaderSettings() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized TopicPath topicPath();

    abstract @UnknownKeyFor @NonNull @Initialized Partition partition();

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_TopicBacklogReaderSettings.Builder();
    }

    @UnknownKeyFor @NonNull @Initialized TopicBacklogReader instantiate() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        TopicStatsClientSettings settings = TopicStatsClientSettings.newBuilder().setRegion(this.topicPath().location().region()).build();
        TopicBacklogReaderImpl impl = new TopicBacklogReaderImpl(TopicStatsClient.create((TopicStatsClientSettings)settings), this.topicPath(), this.partition());
        return new LimitingTopicBacklogReader(impl, Ticker.systemTicker());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTopicPath(@UnknownKeyFor @NonNull @Initialized TopicPath var1);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @UnknownKeyFor @NonNull @Initialized Builder setTopicPathFromSubscriptionPath(@UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPath) throws @UnknownKeyFor @NonNull @Initialized ApiException {
            try (AdminClient adminClient = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(subscriptionPath.location().region()).build());){
                Builder builder = this.setTopicPath(TopicPath.parse((String)((Subscription)adminClient.getSubscription(subscriptionPath).get()).getTopic()));
                return builder;
            }
            catch (ExecutionException e) {
                Throwable cause = (Throwable)Preconditions.checkNotNull((Object)e.getCause());
                throw ExtractStatus.toCanonical((Throwable)cause).underlying;
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical((Throwable)t).underlying;
            }
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPartition(@UnknownKeyFor @NonNull @Initialized Partition var1);

        abstract @UnknownKeyFor @NonNull @Initialized TopicBacklogReaderSettings build();
    }
}

