/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartition;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class SubscriptionPartitionLoader
extends PTransform<PBegin, PCollection<SubscriptionPartition>> {
    private final @UnknownKeyFor @NonNull @Initialized TopicPath topic;
    private final @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TopicPath, @UnknownKeyFor @NonNull @Initialized Integer> getPartitionCount;
    private final @UnknownKeyFor @NonNull @Initialized Duration pollDuration;
    private final @UnknownKeyFor @NonNull @Initialized boolean terminate;

    SubscriptionPartitionLoader(@UnknownKeyFor @NonNull @Initialized TopicPath topic, @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription) {
        this(topic, subscription, (SerializableFunction<TopicPath, Integer>)((SerializableFunction & Serializable)PartitionLookupUtils::numPartitions), Duration.standardMinutes((long)1L), false);
    }

    @VisibleForTesting
    SubscriptionPartitionLoader(@UnknownKeyFor @NonNull @Initialized TopicPath topic, @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TopicPath, @UnknownKeyFor @NonNull @Initialized Integer> getPartitionCount, @UnknownKeyFor @NonNull @Initialized Duration pollDuration, @UnknownKeyFor @NonNull @Initialized boolean terminate) {
        this.topic = topic;
        this.subscription = subscription;
        this.getPartitionCount = getPartitionCount;
        this.pollDuration = pollDuration;
        this.terminate = terminate;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SubscriptionPartition> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        PCollection start = (PCollection)input.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)this.topic)));
        PCollection partitions = (PCollection)start.apply((PTransform)Watch.growthOf((Watch.Growth.PollFn)new Watch.Growth.PollFn<TopicPath, Partition>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Watch.Growth.PollResult<@UnknownKeyFor @NonNull @Initialized Partition> apply(@UnknownKeyFor @NonNull @Initialized TopicPath element, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Contextful.Fn.Context c) {
                Preconditions.checkArgument((boolean)element.equals(SubscriptionPartitionLoader.this.topic));
                int partitionCount = (Integer)SubscriptionPartitionLoader.this.getPartitionCount.apply((Object)element);
                List partitions = IntStream.range(0, partitionCount).mapToObj(Partition::of).collect(Collectors.toList());
                return Watch.Growth.PollResult.incomplete((Instant)Instant.now(), partitions);
            }
        }).withPollInterval(this.pollDuration).withTerminationPerInput((Watch.Growth.TerminationCondition)(this.terminate ? Watch.Growth.afterTotalOf((ReadableDuration)this.pollDuration.multipliedBy(10L)) : Watch.Growth.never())));
        return (PCollection)partitions.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(SubscriptionPartition.class)).via((SerializableFunction & Serializable)kv -> SubscriptionPartition.of(this.subscription, (Partition)kv.getValue())));
    }
}

