/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubMessages {

    public static class ParsePubsubMessageProtoAsPayload
    implements SerializableFunction<byte[], PubsubMessage> {
        public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
            try {
                com.google.pubsub.v1.PubsubMessage message = com.google.pubsub.v1.PubsubMessage.parseFrom((byte[])input);
                return new PubsubMessage(message.getData().toByteArray(), message.getAttributesMap(), message.getMessageId());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Could not decode Pubsub message", e);
            }
        }
    }

    public static class ParsePayloadAsPubsubMessageProto
    implements SerializableFunction<PubsubMessage, byte[]> {
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized PubsubMessage input) {
            String messageId;
            Map<String, String> attributes = input.getAttributeMap();
            PubsubMessage.Builder message = com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])input.getPayload()));
            if (attributes != null) {
                message.putAllAttributes(attributes);
            }
            if ((messageId = input.getMessageId()) != null) {
                message.setMessageId(messageId);
            }
            return message.build().toByteArray();
        }
    }
}

