/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_PubsubIO_Write<T>
extends PubsubIO.Write<T> {
    private final @Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider;
    private final PubsubClient.PubsubClientFactory pubsubClientFactory;
    private final @Nullable Integer maxBatchSize;
    private final @Nullable Integer maxBatchBytesSize;
    private final @Nullable String timestampAttribute;
    private final @Nullable String idAttribute;
    private final SerializableFunction<T, PubsubMessage> formatFn;

    private AutoValue_PubsubIO_Write(@Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider, PubsubClient.PubsubClientFactory pubsubClientFactory, @Nullable Integer maxBatchSize, @Nullable Integer maxBatchBytesSize, @Nullable String timestampAttribute, @Nullable String idAttribute, SerializableFunction<T, PubsubMessage> formatFn) {
        this.topicProvider = topicProvider;
        this.pubsubClientFactory = pubsubClientFactory;
        this.maxBatchSize = maxBatchSize;
        this.maxBatchBytesSize = maxBatchBytesSize;
        this.timestampAttribute = timestampAttribute;
        this.idAttribute = idAttribute;
        this.formatFn = formatFn;
    }

    @Override
    @Nullable ValueProvider<PubsubIO.PubsubTopic> getTopicProvider() {
        return this.topicProvider;
    }

    @Override
    PubsubClient.PubsubClientFactory getPubsubClientFactory() {
        return this.pubsubClientFactory;
    }

    @Override
    @Nullable Integer getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    @Nullable Integer getMaxBatchBytesSize() {
        return this.maxBatchBytesSize;
    }

    @Override
    @Nullable String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    @Override
    @Nullable String getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    SerializableFunction<T, PubsubMessage> getFormatFn() {
        return this.formatFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubIO.Write) {
            PubsubIO.Write that = (PubsubIO.Write)((Object)o);
            return (this.topicProvider == null ? that.getTopicProvider() == null : this.topicProvider.equals(that.getTopicProvider())) && this.pubsubClientFactory.equals(that.getPubsubClientFactory()) && (this.maxBatchSize == null ? that.getMaxBatchSize() == null : this.maxBatchSize.equals(that.getMaxBatchSize())) && (this.maxBatchBytesSize == null ? that.getMaxBatchBytesSize() == null : this.maxBatchBytesSize.equals(that.getMaxBatchBytesSize())) && (this.timestampAttribute == null ? that.getTimestampAttribute() == null : this.timestampAttribute.equals(that.getTimestampAttribute())) && (this.idAttribute == null ? that.getIdAttribute() == null : this.idAttribute.equals(that.getIdAttribute())) && this.formatFn.equals(that.getFormatFn());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicProvider == null ? 0 : this.topicProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.pubsubClientFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBatchSize == null ? 0 : this.maxBatchSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBatchBytesSize == null ? 0 : this.maxBatchBytesSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampAttribute == null ? 0 : this.timestampAttribute.hashCode();
        h$ *= 1000003;
        h$ ^= this.idAttribute == null ? 0 : this.idAttribute.hashCode();
        h$ *= 1000003;
        return h$ ^= this.formatFn.hashCode();
    }

    @Override
    PubsubIO.Write.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends PubsubIO.Write.Builder<T> {
        private @Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider;
        private PubsubClient.PubsubClientFactory pubsubClientFactory;
        private @Nullable Integer maxBatchSize;
        private @Nullable Integer maxBatchBytesSize;
        private @Nullable String timestampAttribute;
        private @Nullable String idAttribute;
        private SerializableFunction<T, PubsubMessage> formatFn;

        Builder() {
        }

        private Builder(PubsubIO.Write<T> source) {
            this.topicProvider = source.getTopicProvider();
            this.pubsubClientFactory = source.getPubsubClientFactory();
            this.maxBatchSize = source.getMaxBatchSize();
            this.maxBatchBytesSize = source.getMaxBatchBytesSize();
            this.timestampAttribute = source.getTimestampAttribute();
            this.idAttribute = source.getIdAttribute();
            this.formatFn = source.getFormatFn();
        }

        @Override
        PubsubIO.Write.Builder<T> setTopicProvider(ValueProvider<PubsubIO.PubsubTopic> topicProvider) {
            this.topicProvider = topicProvider;
            return this;
        }

        @Override
        PubsubIO.Write.Builder<T> setPubsubClientFactory(PubsubClient.PubsubClientFactory pubsubClientFactory) {
            if (pubsubClientFactory == null) {
                throw new NullPointerException("Null pubsubClientFactory");
            }
            this.pubsubClientFactory = pubsubClientFactory;
            return this;
        }

        @Override
        PubsubIO.Write.Builder<T> setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        @Override
        PubsubIO.Write.Builder<T> setMaxBatchBytesSize(Integer maxBatchBytesSize) {
            this.maxBatchBytesSize = maxBatchBytesSize;
            return this;
        }

        @Override
        PubsubIO.Write.Builder<T> setTimestampAttribute(String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
            return this;
        }

        @Override
        PubsubIO.Write.Builder<T> setIdAttribute(String idAttribute) {
            this.idAttribute = idAttribute;
            return this;
        }

        @Override
        PubsubIO.Write.Builder<T> setFormatFn(SerializableFunction<T, PubsubMessage> formatFn) {
            if (formatFn == null) {
                throw new NullPointerException("Null formatFn");
            }
            this.formatFn = formatFn;
            return this;
        }

        @Override
        PubsubIO.Write<T> build() {
            String missing = "";
            if (this.pubsubClientFactory == null) {
                missing = missing + " pubsubClientFactory";
            }
            if (this.formatFn == null) {
                missing = missing + " formatFn";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubIO_Write(this.topicProvider, this.pubsubClientFactory, this.maxBatchSize, this.maxBatchBytesSize, this.timestampAttribute, this.idAttribute, this.formatFn);
        }
    }
}

