/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.healthcare.v1beta1.model.DeidentifyConfig;
import com.google.api.services.healthcare.v1beta1.model.HttpBody;
import com.google.api.services.healthcare.v1beta1.model.Operation;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TextualIntegerCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdCoder;
import org.apache.beam.sdk.io.gcp.healthcare.AutoValue_FhirIO_Write;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameter;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.JsonArrayCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirIO {
    private static final @UnknownKeyFor @NonNull @Initialized String BASE_METRIC_PREFIX = "fhirio/";

    public static @UnknownKeyFor @NonNull @Initialized Read readResources() {
        return new Read();
    }

    public static @UnknownKeyFor @NonNull @Initialized Search<@UnknownKeyFor @NonNull @Initialized String> searchResources(@UnknownKeyFor @NonNull @Initialized String fhirStore) {
        return new Search<String>(fhirStore);
    }

    public static @UnknownKeyFor @NonNull @Initialized Search<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Object> searchResourcesWithGenericParameters(@UnknownKeyFor @NonNull @Initialized String fhirStore) {
        return new Search(fhirStore);
    }

    public static @UnknownKeyFor @NonNull @Initialized Import importResources(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String tempDir, @UnknownKeyFor @NonNull @Initialized String deadLetterDir, @Nullable @UnknownKeyFor @Initialized Import.ContentStructure contentStructure) {
        return new Import(fhirStore, tempDir, deadLetterDir, contentStructure);
    }

    public static @UnknownKeyFor @NonNull @Initialized Import importResources(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempDir, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterDir, @Nullable @UnknownKeyFor @Initialized Import.ContentStructure contentStructure) {
        return new Import(fhirStore, tempDir, deadLetterDir, contentStructure);
    }

    public static @UnknownKeyFor @NonNull @Initialized Export exportResourcesToGcs(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String exportGcsUriPrefix) {
        return new Export((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)exportGcsUriPrefix));
    }

    public static @UnknownKeyFor @NonNull @Initialized Export exportResourcesToGcs(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> exportGcsUriPrefix) {
        return new Export(fhirStore, exportGcsUriPrefix);
    }

    public static @UnknownKeyFor @NonNull @Initialized Deidentify deidentify(@UnknownKeyFor @NonNull @Initialized String sourceFhirStore, @UnknownKeyFor @NonNull @Initialized String destinationFhirStore, @UnknownKeyFor @NonNull @Initialized DeidentifyConfig deidConfig) {
        return new Deidentify((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)sourceFhirStore), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)destinationFhirStore), (ValueProvider<DeidentifyConfig>)ValueProvider.StaticValueProvider.of((Object)deidConfig));
    }

    public static @UnknownKeyFor @NonNull @Initialized Deidentify deidentify(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> sourceFhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> destinationFhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized DeidentifyConfig> deidConfig) {
        return new Deidentify(sourceFhirStore, destinationFhirStore, deidConfig);
    }

    public static class Search<@UnknownKeyFor T>
    extends PTransform<PCollection<FhirSearchParameter<T>>, Result> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Search.class);
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonArray>> OUT = new TupleTag<KV<String, JsonArray>>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

        Search(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore) {
            this.fhirStore = fhirStore;
        }

        Search(@UnknownKeyFor @NonNull @Initialized String fhirStore) {
            this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
        }

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FhirSearchParameter<T>> input) {
            return (Result)input.apply("Fetch Fhir messages", (PTransform)new SearchResourcesJsonString(this.fhirStore));
        }

        class SearchResourcesJsonString
        extends PTransform<PCollection<FhirSearchParameter<T>>, Result> {
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;

            public SearchResourcesJsonString(ValueProvider<String> fhirStore) {
                this.fhirStore = fhirStore;
            }

            public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FhirSearchParameter<T>> resourceIds) {
                return new Result((PCollectionTuple)resourceIds.apply((PTransform)ParDo.of((DoFn)new SearchResourcesFn(this.fhirStore)).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            class SearchResourcesFn
            extends DoFn<FhirSearchParameter<T>, KV<String, JsonArray>> {
                private final @UnknownKeyFor @NonNull @Initialized Counter searchResourceErrors = Metrics.counter(SearchResourcesFn.class, (String)"fhirio/search_resource_error_count");
                private final @UnknownKeyFor @NonNull @Initialized Counter searchResourceSuccess = Metrics.counter(SearchResourcesFn.class, (String)"fhirio/search_resource_success_count");
                private final @UnknownKeyFor @NonNull @Initialized Distribution searchResourceLatencyMs = Metrics.distribution(SearchResourcesFn.class, (String)"fhirio/search_resource_latency_ms");
                private final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(SearchResourcesFn.class);
                private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
                private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;

                SearchResourcesFn(ValueProvider<String> fhirStore) {
                    this.fhirStore = fhirStore;
                }

                @DoFn.Setup
                public void instantiateHealthcareClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    this.client = new HttpHealthcareApiClient();
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    FhirSearchParameter fhirSearchParameters = (FhirSearchParameter)context.element();
                    try {
                        context.output((Object)KV.of((Object)fhirSearchParameters.getKey(), (Object)this.searchResources(this.client, this.fhirStore.toString(), fhirSearchParameters.getResourceType(), fhirSearchParameters.getQueries())));
                    }
                    catch (IllegalArgumentException | NoSuchElementException e) {
                        this.searchResourceErrors.inc();
                        this.log.warn(String.format("Error search FHIR messages writing to Dead Letter Queue. Cause: %s Stack Trace: %s", e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                        context.output(DEAD_LETTER, HealthcareIOError.of(this.fhirStore.toString(), e));
                    }
                }

                private @UnknownKeyFor @NonNull @Initialized JsonArray searchResources(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String resourceType, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> parameters) throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                    long start = Instant.now().toEpochMilli();
                    HashMap<String, Object> parameterObjects = new HashMap<String, Object>();
                    if (parameters != null) {
                        parameters.forEach(parameterObjects::put);
                    }
                    HttpHealthcareApiClient.FhirResourcePages.FhirResourcePagesIterator iter = new HttpHealthcareApiClient.FhirResourcePages.FhirResourcePagesIterator(client, fhirStore, resourceType, parameterObjects);
                    JsonArray result = new JsonArray();
                    result.addAll(iter.next());
                    while (iter.hasNext()) {
                        result.addAll(iter.next());
                    }
                    this.searchResourceLatencyMs.update(Instant.now().toEpochMilli() - start);
                    this.searchResourceSuccess.inc();
                    return result;
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonArray>> keyedResources;
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized JsonArray> resources;
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedSearches;
            @UnknownKeyFor @NonNull @Initialized PCollectionTuple pct;

            static @UnknownKeyFor @NonNull @Initialized Result of(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
                if (pct.getAll().keySet().containsAll((Collection)TupleTagList.of(OUT).and(DEAD_LETTER))) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the FhirIO.Search.OUT and FhirIO.Search.DEAD_LETTER tuple tags");
            }

            private Result(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
                this.pct = pct;
                this.keyedResources = pct.get(OUT).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)JsonArrayCoder.of()));
                this.resources = ((PCollection)this.keyedResources.apply("Extract Values", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(JsonArray.class)).via((SerializableFunction & Serializable)in -> (JsonArray)in.getValue()))).setCoder((Coder)JsonArrayCoder.of());
                this.failedSearches = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> getFailedSearches() {
                return this.failedSearches;
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized JsonArray> getResources() {
                return this.resources;
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonArray>> getKeyedResources() {
                return this.keyedResources;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                return ImmutableMap.of(OUT, this.keyedResources);
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }
        }
    }

    public static class Deidentify
    extends PTransform<PBegin, PCollection<String>> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> sourceFhirStore;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> destinationFhirStore;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized DeidentifyConfig> deidConfig;

        public Deidentify(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> sourceFhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> destinationFhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized DeidentifyConfig> deidConfig) {
            this.sourceFhirStore = sourceFhirStore;
            this.destinationFhirStore = destinationFhirStore;
            this.deidConfig = deidConfig;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PCollection)((PCollection)input.getPipeline().apply((PTransform)Create.ofProvider(this.sourceFhirStore, (Coder)StringUtf8Coder.of()))).apply("ScheduleDeidentifyFhirStoreOperations", (PTransform)ParDo.of((DoFn)new DeidentifyFn(this.destinationFhirStore, this.deidConfig)));
        }

        public static class DeidentifyFn
        extends DoFn<String, String> {
            private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> destinationFhirStore;
            private static final @UnknownKeyFor @NonNull @Initialized Gson gson = new Gson();
            private final @UnknownKeyFor @NonNull @Initialized String deidConfigJson;

            public DeidentifyFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> destinationFhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized DeidentifyConfig> deidConfig) {
                this.destinationFhirStore = destinationFhirStore;
                this.deidConfigJson = gson.toJson(deidConfig.get());
            }

            @DoFn.Setup
            public void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void deidentify(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized HttpHealthcareApiClient.HealthcareHttpException {
                String sourceFhirStore = (String)context.element();
                String destinationFhirStore = (String)this.destinationFhirStore.get();
                DeidentifyConfig deidConfig = (DeidentifyConfig)gson.fromJson(this.deidConfigJson, DeidentifyConfig.class);
                Operation operation = this.client.deidentifyFhirStore(sourceFhirStore, destinationFhirStore, deidConfig);
                if ((operation = this.client.pollOperation(operation, 1000L)).getError() != null) {
                    throw new IOException(String.format("DeidentifyFhirStore operation (%s) failed.", operation.getName()));
                }
                context.output((Object)destinationFhirStore);
            }
        }
    }

    public static class Export
    extends PTransform<PBegin, PCollection<String>> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> exportGcsUriPrefix;

        public Export(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> exportGcsUriPrefix) {
            this.fhirStore = fhirStore;
            this.exportGcsUriPrefix = exportGcsUriPrefix;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Create.ofProvider(this.fhirStore, (Coder)StringUtf8Coder.of()))).apply("ScheduleExportOperations", (PTransform)ParDo.of((DoFn)new ExportResourcesToGcsFn(this.exportGcsUriPrefix)))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply("ReadResourcesFromFiles", (PTransform)TextIO.readFiles());
        }

        public static class ExportResourcesToGcsFn
        extends DoFn<String, String> {
            private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> exportGcsUriPrefix;

            public ExportResourcesToGcsFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> exportGcsUriPrefix) {
                this.exportGcsUriPrefix = exportGcsUriPrefix;
            }

            @DoFn.Setup
            public void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void exportResourcesToGcs(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized HttpHealthcareApiClient.HealthcareHttpException {
                String fhirStore = (String)context.element();
                String gcsPrefix = (String)this.exportGcsUriPrefix.get();
                Operation operation = this.client.exportFhirResourceToGcs(fhirStore, gcsPrefix);
                if ((operation = this.client.pollOperation(operation, 1000L)).getError() != null) {
                    throw new RuntimeException(String.format("Export operation (%s) failed.", operation.getName()));
                }
                context.output((Object)String.format("%s/*", gcsPrefix.replaceAll("/+$", "")));
            }
        }
    }

    public static class ExecuteBundles
    extends PTransform<PCollection<String>, Write.Result> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;

        ExecuteBundles(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore) {
            this.fhirStore = fhirStore;
        }

        ExecuteBundles(@UnknownKeyFor @NonNull @Initialized String fhirStore) {
            this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
        }

        public @UnknownKeyFor @NonNull @Initialized Write.Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return Write.Result.in(input.getPipeline(), (PCollection<HealthcareIOError<String>>)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new ExecuteBundlesFn(this.fhirStore)))).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of())));
        }

        static class ExecuteBundlesFn
        extends DoFn<String, HealthcareIOError<String>> {
            private static final @UnknownKeyFor @NonNull @Initialized Counter EXECUTE_BUNDLE_ERRORS = Metrics.counter(ExecuteBundlesFn.class, (String)"fhirio/execute_bundle_error_count");
            private static final @UnknownKeyFor @NonNull @Initialized Counter EXECUTE_BUNDLE_SUCCESS = Metrics.counter(ExecuteBundlesFn.class, (String)"fhirio/execute_bundle_success_count");
            private static final @UnknownKeyFor @NonNull @Initialized Distribution EXECUTE_BUNDLE_LATENCY_MS = Metrics.distribution(ExecuteBundlesFn.class, (String)"fhirio/execute_bundle_latency_ms");
            private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
            private final @UnknownKeyFor @NonNull @Initialized ObjectMapper mapper = new ObjectMapper();
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;

            ExecuteBundlesFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore) {
                this.fhirStore = fhirStore;
            }

            @DoFn.Setup
            public void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void executeBundles(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                String body = (String)context.element();
                try {
                    long startTime = Instant.now().toEpochMilli();
                    this.mapper.readTree(body);
                    this.client.executeFhirBundle((String)this.fhirStore.get(), body);
                    EXECUTE_BUNDLE_LATENCY_MS.update(Instant.now().toEpochMilli() - startTime);
                    EXECUTE_BUNDLE_SUCCESS.inc();
                }
                catch (IOException | HttpHealthcareApiClient.HealthcareHttpException e) {
                    EXECUTE_BUNDLE_ERRORS.inc();
                    context.output(HealthcareIOError.of(body, e));
                }
            }
        }
    }

    public static class Import
    extends Write {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath;
        private final @UnknownKeyFor @NonNull @Initialized ContentStructure contentStructure;
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_FILES_PER_BATCH = 10000;
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Import.class);
        private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempGcsPath;

        Import(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempGcsPath, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath, @Nullable @UnknownKeyFor @Initialized ContentStructure contentStructure) {
            this.fhirStore = fhirStore;
            this.tempGcsPath = tempGcsPath;
            this.deadLetterGcsPath = deadLetterGcsPath;
            this.contentStructure = contentStructure == null ? ContentStructure.CONTENT_STRUCTURE_UNSPECIFIED : contentStructure;
        }

        Import(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath, @Nullable @UnknownKeyFor @Initialized ContentStructure contentStructure) {
            this(fhirStore, null, deadLetterGcsPath, contentStructure);
        }

        Import(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String tempGcsPath, @UnknownKeyFor @NonNull @Initialized String deadLetterGcsPath, @Nullable @UnknownKeyFor @Initialized ContentStructure contentStructure) {
            this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
            this.tempGcsPath = ValueProvider.StaticValueProvider.of((Object)tempGcsPath);
            this.deadLetterGcsPath = ValueProvider.StaticValueProvider.of((Object)deadLetterGcsPath);
            this.contentStructure = contentStructure == null ? ContentStructure.CONTENT_STRUCTURE_UNSPECIFIED : contentStructure;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFhirStore() {
            return this.fhirStore;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Write.WriteMethod getWriteMethod() {
            return Write.WriteMethod.IMPORT;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ContentStructure> getContentStructure() {
            return Optional.of(this.contentStructure);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String>> getImportGcsTempPath() {
            return Optional.of(this.tempGcsPath);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String>> getImportGcsDeadLetterPath() {
            return Optional.of(this.deadLetterGcsPath);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Write.Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            Preconditions.checkState((input.isBounded() == PCollection.IsBounded.BOUNDED ? 1 : 0) != 0, (Object)"FhirIO.Import should only be used on unbounded PCollections as it isintended for batch use only.");
            ValueProvider<String> tempPath = this.getImportGcsTempPath().orElse((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input.getPipeline().getOptions().getTempLocation()));
            PCollectionTuple writeTmpFileResults = (PCollectionTuple)input.apply("Write nd json to GCS", (PTransform)ParDo.of((DoFn)new WriteBundlesToFilesFn(this.fhirStore, tempPath, this.deadLetterGcsPath)).withOutputTags(Write.TEMP_FILES, TupleTagList.of(Write.FAILED_BODY)));
            PCollection failedBodies = writeTmpFileResults.get(Write.FAILED_BODY).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            int numShards = 100;
            PCollection failedFiles = ((PCollection)((PCollection)((PCollection)writeTmpFileResults.get(Write.TEMP_FILES).apply("Shard files", (PTransform)WithKeys.of((SerializableFunction & Serializable)elm -> ThreadLocalRandom.current().nextInt(0, numShards)))).setCoder((Coder)KvCoder.of((Coder)TextualIntegerCoder.of(), (Coder)ResourceIdCoder.of())).apply("Assemble File Batches", (PTransform)GroupIntoBatches.ofSize((long)10000L))).setCoder((Coder)KvCoder.of((Coder)TextualIntegerCoder.of(), (Coder)IterableCoder.of((Coder)ResourceIdCoder.of()))).apply("Import Batches", (PTransform)ParDo.of((DoFn)new ImportFn(this.fhirStore, tempPath, this.deadLetterGcsPath, this.contentStructure)))).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.getPipeline().apply("Instantiate Temp Path", (PTransform)Create.ofProvider(tempPath, (Coder)StringUtf8Coder.of()))).apply("Resolve SubDirs", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)path -> path.endsWith("/") ? path + "*" : path + "/*"))).apply("Wait On File Writing", (PTransform)Wait.on((PCollection[])new PCollection[]{failedBodies}))).apply("Wait On FHIR Importing", (PTransform)Wait.on((PCollection[])new PCollection[]{failedFiles}))).apply("Match tempGcsPath", (PTransform)FileIO.matchAll().withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW))).apply("Delete tempGcsPath", (PTransform)ParDo.of((DoFn)new DoFn<MatchResult.Metadata, Void>(){

                @DoFn.ProcessElement
                public void delete(@DoFn.Element // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata path, /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    try {
                        FileSystems.delete(Collections.singleton(path.resourceId()), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                    }
                    catch (IOException e) {
                        LOG.error("error cleaning up tempGcsDir: %s", (Throwable)e);
                    }
                }
            }))).setCoder((Coder)VoidCoder.of());
            return Write.Result.in(input.getPipeline(), (PCollection<HealthcareIOError<String>>)failedBodies, (PCollection<HealthcareIOError<String>>)failedFiles);
        }

        public static enum ContentStructure {
            CONTENT_STRUCTURE_UNSPECIFIED,
            BUNDLE,
            RESOURCE,
            BUNDLE_PRETTY,
            RESOURCE_PRETTY;

        }

        static class ImportFn
        extends DoFn<KV<Integer, Iterable<ResourceId>>, HealthcareIOError<String>> {
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ImportFn.class);
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempGcsPath;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath;
            private @UnknownKeyFor @NonNull @Initialized ResourceId tempDir;
            private final @UnknownKeyFor @NonNull @Initialized ContentStructure contentStructure;
            private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;

            ImportFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempGcsPath, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath, @Nullable @UnknownKeyFor @Initialized ContentStructure contentStructure) {
                this.fhirStore = fhirStore;
                this.tempGcsPath = tempGcsPath;
                this.deadLetterGcsPath = deadLetterGcsPath;
                this.contentStructure = contentStructure == null ? ContentStructure.CONTENT_STRUCTURE_UNSPECIFIED : contentStructure;
            }

            @DoFn.Setup
            public void init() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.tempDir = FileSystems.matchNewResource((String)((String)this.tempGcsPath.get()), (boolean)true).resolve(String.format("tmp-%s", UUID.randomUUID().toString()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
                this.client = new HttpHealthcareApiClient();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @DoFn.ProcessElement
            public void importBatch(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ResourceId>> element, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> output) throws @UnknownKeyFor @NonNull @Initialized IOException {
                Iterable batch = (Iterable)element.getValue();
                ArrayList<ResourceId> tempDestinations = new ArrayList<ResourceId>();
                ArrayList<ResourceId> deadLetterDestinations = new ArrayList<ResourceId>();
                assert (batch != null);
                for (ResourceId file : batch) {
                    tempDestinations.add(this.tempDir.resolve(file.getFilename(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
                    deadLetterDestinations.add(FileSystems.matchNewResource((String)((String)this.deadLetterGcsPath.get()), (boolean)true).resolve(file.getFilename(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
                }
                FileSystems.copy((List)ImmutableList.copyOf((Iterable)batch), tempDestinations, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                boolean hasMissingFile = FileSystems.matchResources(tempDestinations).stream().anyMatch(r -> r.status() != MatchResult.Status.OK);
                if (hasMissingFile) {
                    throw new IllegalStateException("Not all temporary files are present for importing.");
                }
                ResourceId importUri = this.tempDir.resolve("*", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
                try {
                    assert (this.contentStructure != null);
                    Operation operation = this.client.importFhirResource((String)this.fhirStore.get(), importUri.toString(), this.contentStructure.name());
                    this.client.pollOperation(operation, 500L);
                    FileSystems.delete(tempDestinations, (MoveOptions[])new MoveOptions[0]);
                }
                catch (IOException | InterruptedException e) {
                    ResourceId deadLetterResourceId = FileSystems.matchNewResource((String)((String)this.deadLetterGcsPath.get()), (boolean)true);
                    LOG.warn(String.format("Failed to import %s with error: %s. Moving to deadletter path %s", importUri.toString(), e.getMessage(), deadLetterResourceId.toString()));
                    FileSystems.rename(tempDestinations, deadLetterDestinations, (MoveOptions[])new MoveOptions[0]);
                    output.output(HealthcareIOError.of(importUri.toString(), e));
                }
                finally {
                    FileSystems.delete((Collection)ImmutableList.copyOf((Iterable)batch), (MoveOptions[])new MoveOptions[0]);
                }
            }
        }

        static class WriteBundlesToFilesFn
        extends DoFn<String, ResourceId> {
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempGcsPath;
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath;
            private @UnknownKeyFor @NonNull @Initialized ObjectMapper mapper;
            private @UnknownKeyFor @NonNull @Initialized ResourceId resourceId;
            private @UnknownKeyFor @NonNull @Initialized WritableByteChannel ndJsonChannel;
            private @UnknownKeyFor @NonNull @Initialized BoundedWindow window;
            private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteBundlesToFilesFn.class);

            WriteBundlesToFilesFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempGcsPath, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> deadLetterGcsPath) {
                this.fhirStore = fhirStore;
                this.tempGcsPath = tempGcsPath;
                this.deadLetterGcsPath = deadLetterGcsPath;
            }

            WriteBundlesToFilesFn(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String tempGcsPath, @UnknownKeyFor @NonNull @Initialized String deadLetterGcsPath) {
                this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
                this.tempGcsPath = ValueProvider.StaticValueProvider.of((Object)tempGcsPath);
                this.deadLetterGcsPath = ValueProvider.StaticValueProvider.of((Object)deadLetterGcsPath);
            }

            @DoFn.Setup
            public void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.StartBundle
            public void initFile() throws @UnknownKeyFor @NonNull @Initialized IOException {
                String filename = String.format("fhirImportBatch-%s.ndjson", UUID.randomUUID().toString());
                ResourceId tempDir = FileSystems.matchNewResource((String)((String)this.tempGcsPath.get()), (boolean)true);
                this.resourceId = tempDir.resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
                this.ndJsonChannel = FileSystems.create((ResourceId)this.resourceId, (String)"application/ld+json");
                if (this.mapper == null) {
                    this.mapper = new ObjectMapper();
                }
            }

            @DoFn.ProcessElement
            public void addToFile(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.window = window;
                String httpBody = (String)context.element();
                try {
                    Object data = this.mapper.readValue(httpBody, Object.class);
                    String ndJson = this.mapper.writeValueAsString(data) + "\n";
                    this.ndJsonChannel.write(ByteBuffer.wrap(ndJson.getBytes(StandardCharsets.UTF_8)));
                }
                catch (JsonProcessingException e) {
                    String resource = String.format("Failed to parse payload: %s as json at: %s : %s.Dropping message from batch import.", httpBody.toString(), e.getLocation().getCharOffset(), e.getMessage());
                    LOG.warn(resource);
                    context.output(Write.FAILED_BODY, HealthcareIOError.of(httpBody, new IOException(resource)));
                }
            }

            @DoFn.FinishBundle
            public void closeFile(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.ndJsonChannel.close();
                context.output((Object)this.resourceId, this.window.maxTimestamp(), this.window);
            }
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<String>, Result> {
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> FAILED_BODY = new TupleTag<HealthcareIOError<String>>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> FAILED_FILES = new TupleTag<HealthcareIOError<String>>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ResourceId> TEMP_FILES = new TupleTag<ResourceId>(){};
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Write.class);

        abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFhirStore();

        abstract @UnknownKeyFor @NonNull @Initialized WriteMethod getWriteMethod();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Import.ContentStructure> getContentStructure();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String>> getImportGcsTempPath();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String>> getImportGcsDeadLetterPath();

        private static @UnknownKeyFor @NonNull @Initialized Builder write(@UnknownKeyFor @NonNull @Initialized String fhirStore) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore));
        }

        public static @UnknownKeyFor @NonNull @Initialized Write fhirStoresImport(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String gcsTempPath, @UnknownKeyFor @NonNull @Initialized String gcsDeadLetterPath, @Nullable @UnknownKeyFor @Initialized Import.ContentStructure contentStructure) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore)).setWriteMethod(WriteMethod.IMPORT).setContentStructure(contentStructure).setImportGcsTempPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gcsTempPath)).setImportGcsDeadLetterPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gcsDeadLetterPath)).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Write fhirStoresImport(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String gcsDeadLetterPath, @Nullable @UnknownKeyFor @Initialized Import.ContentStructure contentStructure) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore)).setWriteMethod(WriteMethod.IMPORT).setContentStructure(contentStructure).setImportGcsDeadLetterPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gcsDeadLetterPath)).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Write fhirStoresImport(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> gcsTempPath, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> gcsDeadLetterPath, @Nullable @UnknownKeyFor @Initialized Import.ContentStructure contentStructure) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore(fhirStore).setWriteMethod(WriteMethod.IMPORT).setContentStructure(contentStructure).setImportGcsTempPath(gcsTempPath).setImportGcsDeadLetterPath(gcsDeadLetterPath).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Write executeBundles(@UnknownKeyFor @NonNull @Initialized String fhirStore) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore)).setWriteMethod(WriteMethod.EXECUTE_BUNDLE).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Write executeBundles(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fhirStore) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore(fhirStore).setWriteMethod(WriteMethod.EXECUTE_BUNDLE).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            switch (this.getWriteMethod()) {
                case IMPORT: {
                    LOG.warn("Make sure the Cloud Healthcare Service Agent has permissions when using import: https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#fhir_store_cloud_storage_permissions");
                    ValueProvider<String> deadPath = this.getImportGcsDeadLetterPath().orElseThrow(IllegalArgumentException::new);
                    Import.ContentStructure contentStructure = this.getContentStructure().orElseThrow(IllegalArgumentException::new);
                    ValueProvider<String> tempPath = this.getImportGcsTempPath().orElse((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input.getPipeline().getOptions().getTempLocation()));
                    return (Result)input.apply((PTransform)new Import(this.getFhirStore(), tempPath, deadPath, contentStructure));
                }
            }
            PCollection failedBundles = ((PCollection)input.apply("Execute FHIR Bundles", (PTransform)ParDo.of((DoFn)new ExecuteBundles.ExecuteBundlesFn(this.getFhirStore())))).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            return Result.in(input.getPipeline(), (PCollection<HealthcareIOError<String>>)failedBundles);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFhirStore(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteMethod(@UnknownKeyFor @NonNull @Initialized WriteMethod var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setContentStructure(@UnknownKeyFor @NonNull @Initialized Import.ContentStructure var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setImportGcsTempPath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setImportGcsDeadLetterPath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }

        public static class Result
        implements POutput {
            private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
            private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedBodies;
            private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedFiles;

            static @UnknownKeyFor @NonNull @Initialized Result in(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedBodies) {
                return new Result(pipeline, failedBodies, null);
            }

            static @UnknownKeyFor @NonNull @Initialized Result in(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedBodies, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedFiles) {
                return new Result(pipeline, failedBodies, failedFiles);
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> getFailedBodies() {
                return this.failedBodies;
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> getFailedFiles() {
                return this.failedFiles;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pipeline;
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                return ImmutableMap.of(FAILED_BODY, this.failedBodies, FAILED_FILES, this.failedFiles);
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }

            private Result(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedBodies, @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedFiles) {
                this.pipeline = pipeline;
                this.failedBodies = failedBodies;
                if (failedFiles == null) {
                    failedFiles = (PCollection)pipeline.apply((PTransform)Create.empty(HealthcareIOErrorCoder.of(StringUtf8Coder.of())));
                }
                this.failedFiles = failedFiles;
            }
        }

        public static enum WriteMethod {
            EXECUTE_BUNDLE,
            IMPORT;

        }
    }

    public static class Read
    extends PTransform<PCollection<String>, Result> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Read.class);
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> OUT = new TupleTag<String>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return (Result)input.apply("Fetch Fhir messages", (PTransform)new FetchResourceJsonString());
        }

        static class FetchResourceJsonString
        extends PTransform<PCollection<String>, Result> {
            public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> resourceIds) {
                return new Result((PCollectionTuple)resourceIds.apply((PTransform)ParDo.of((DoFn)new ReadResourceFn()).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            static class ReadResourceFn
            extends DoFn<String, String> {
                private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReadResourceFn.class);
                private static final @UnknownKeyFor @NonNull @Initialized Counter READ_RESOURCE_ERRORS = Metrics.counter(ReadResourceFn.class, (String)"fhirio/read_resource_error_count");
                private static final @UnknownKeyFor @NonNull @Initialized Counter READ_RESOURCE_SUCCESS = Metrics.counter(ReadResourceFn.class, (String)"fhirio/read_resource_success_count");
                private static final @UnknownKeyFor @NonNull @Initialized Distribution READ_RESOURCE_LATENCY_MS = Metrics.distribution(ReadResourceFn.class, (String)"fhirio/read_resource_latency_ms");
                private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
                private @UnknownKeyFor @NonNull @Initialized ObjectMapper mapper;

                ReadResourceFn() {
                }

                @DoFn.Setup
                public void instantiateHealthcareClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    this.client = new HttpHealthcareApiClient();
                    this.mapper = new ObjectMapper();
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    String resourceId = (String)context.element();
                    try {
                        context.output((Object)this.fetchResource(this.client, resourceId));
                    }
                    catch (Exception e) {
                        READ_RESOURCE_ERRORS.inc();
                        LOG.warn(String.format("Error fetching Fhir message with ID %s writing to Dead Letter Queue. Cause: %s Stack Trace: %s", resourceId, e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                        context.output(DEAD_LETTER, HealthcareIOError.of(resourceId, e));
                    }
                }

                private @UnknownKeyFor @NonNull @Initialized String fetchResource(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
                    long startTime = Instant.now().toEpochMilli();
                    HttpBody resource = client.readFhirResource(resourceId);
                    READ_RESOURCE_LATENCY_MS.update(Instant.now().toEpochMilli() - startTime);
                    if (resource == null) {
                        throw new IOException(String.format("GET request for %s returned null", resourceId));
                    }
                    READ_RESOURCE_SUCCESS.inc();
                    return this.mapper.writeValueAsString((Object)resource);
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> resources;
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> failedReads;
            @UnknownKeyFor @NonNull @Initialized PCollectionTuple pct;

            static @UnknownKeyFor @NonNull @Initialized Result of(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
                if (pct.getAll().keySet().containsAll((Collection)TupleTagList.of(OUT).and(DEAD_LETTER))) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the FhirIO.Read.OUT and FhirIO.Read.DEAD_LETTER tuple tags");
            }

            private Result(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
                this.pct = pct;
                this.resources = pct.get(OUT);
                this.failedReads = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> getFailedReads() {
                return this.failedReads;
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> getResources() {
                return this.resources;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                return ImmutableMap.of(OUT, this.resources);
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }
        }
    }
}

