/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class WriteBundlesToFiles<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends DoFn<KV<DestinationT, ElementT>, Result<DestinationT>> {
    private static final @UnknownKeyFor @NonNull @Initialized int SPILLED_RECORD_SHARDING_FACTOR = 10;
    private transient @UnknownKeyFor @NonNull @Initialized Map<DestinationT, @UnknownKeyFor @NonNull @Initialized BigQueryRowWriter<ElementT>> writers;
    private transient @UnknownKeyFor @NonNull @Initialized Map<DestinationT, @UnknownKeyFor @NonNull @Initialized BoundedWindow> writerWindows;
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefixView;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, ElementT>> unwrittenRecordsTag;
    private final @UnknownKeyFor @NonNull @Initialized int maxNumWritersPerBundle;
    private final @UnknownKeyFor @NonNull @Initialized long maxFileSize;
    private final @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory;
    private @UnknownKeyFor @NonNull @Initialized int spilledShardNumber;

    WriteBundlesToFiles(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefixView, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, ElementT>> unwrittenRecordsTag, @UnknownKeyFor @NonNull @Initialized int maxNumWritersPerBundle, @UnknownKeyFor @NonNull @Initialized long maxFileSize, @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory) {
        this.tempFilePrefixView = tempFilePrefixView;
        this.unwrittenRecordsTag = unwrittenRecordsTag;
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
        this.maxFileSize = maxFileSize;
        this.rowWriterFactory = rowWriterFactory;
    }

    @DoFn.StartBundle
    public void startBundle() {
        this.writers = Maps.newHashMap();
        this.writerWindows = Maps.newHashMap();
        this.spilledShardNumber = ThreadLocalRandom.current().nextInt(10);
    }

    @UnknownKeyFor @NonNull @Initialized BigQueryRowWriter<ElementT> createAndInsertWriter(DestinationT destination, @UnknownKeyFor @NonNull @Initialized String tempFilePrefix, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryRowWriter<ElementT> writer = this.rowWriterFactory.createRowWriter(tempFilePrefix, destination);
        this.writers.put(destination, writer);
        this.writerWindows.put(destination, window);
        return writer;
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT> element, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryRowWriter<ElementT> writer;
        String tempFilePrefix = (String)c.sideInput(this.tempFilePrefixView);
        Object destination = ((KV)c.element()).getKey();
        if (this.writers.containsKey(destination)) {
            writer = this.writers.get(destination);
        } else if (this.writers.size() <= this.maxNumWritersPerBundle) {
            writer = this.createAndInsertWriter(destination, tempFilePrefix, window);
        } else {
            c.output(this.unwrittenRecordsTag, (Object)KV.of((Object)ShardedKey.of((Object)destination, (int)(++this.spilledShardNumber % 10)), (Object)element.getValue()));
            return;
        }
        if (writer.getByteSize() > this.maxFileSize) {
            writer.close();
            BigQueryRowWriter.Result result = writer.getResult();
            c.output(new Result<Object>(result.resourceId.toString(), result.byteSize, destination));
            writer = this.createAndInsertWriter(destination, tempFilePrefix, window);
        }
        try {
            writer.write(element.getValue());
        }
        catch (Exception e) {
            try {
                writer.close();
            }
            catch (Exception closeException) {
                e.addSuppressed(closeException);
            }
            throw e;
        }
    }

    @DoFn.FinishBundle
    public void finishBundle(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList exceptionList = Lists.newArrayList();
        for (BigQueryRowWriter<ElementT> bigQueryRowWriter : this.writers.values()) {
            try {
                bigQueryRowWriter.close();
            }
            catch (Exception e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            IOException e = new IOException("Failed to close some writers");
            for (Exception thrown : exceptionList) {
                e.addSuppressed(thrown);
            }
            throw e;
        }
        for (Map.Entry entry : this.writers.entrySet()) {
            try {
                Object destination = entry.getKey();
                BigQueryRowWriter writer = (BigQueryRowWriter)entry.getValue();
                BigQueryRowWriter.Result result = writer.getResult();
                c.output(new Result(result.resourceId.toString(), result.byteSize, destination), this.writerWindows.get(destination).maxTimestamp(), this.writerWindows.get(destination));
            }
            catch (Exception e) {
                exceptionList.add(e);
            }
        }
        this.writers.clear();
    }

    public static class ResultCoder<@UnknownKeyFor DestinationT>
    extends StructuredCoder<Result<DestinationT>> {
        private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder stringCoder = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized VarLongCoder longCoder = VarLongCoder.of();
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;

        public static <DestinationT> @UnknownKeyFor @NonNull @Initialized ResultCoder<DestinationT> of(@UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) {
            return new ResultCoder<DestinationT>(destinationCoder);
        }

        ResultCoder(@UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) {
            this.destinationCoder = destinationCoder;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Result<DestinationT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == null) {
                throw new CoderException("cannot encode a null value");
            }
            stringCoder.encode(value.filename, outStream);
            longCoder.encode(value.fileByteSize, outStream);
            this.destinationCoder.encode(value.destination, outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized Result<DestinationT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String filename = stringCoder.decode(inStream);
            long fileByteSize = longCoder.decode(inStream);
            Object destination = this.destinationCoder.decode(inStream);
            return new Result<Object>(filename, fileByteSize, destination);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.destinationCoder);
        }

        public void verifyDeterministic() {
        }
    }

    static final class Result<@UnknownKeyFor DestinationT>
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
        public final @UnknownKeyFor @NonNull @Initialized String filename;
        public final @UnknownKeyFor @NonNull @Initialized Long fileByteSize;
        public final DestinationT destination;

        public Result(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized Long fileByteSize, DestinationT destination) {
            Preconditions.checkNotNull(destination);
            this.filename = filename;
            this.fileByteSize = fileByteSize;
            this.destination = destination;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other instanceof Result) {
                Result o = (Result)other;
                return Objects.equals(this.filename, o.filename) && Objects.equals(this.fileByteSize, o.fileByteSize) && Objects.equals(this.destination, o.destination);
            }
            return false;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.filename, this.fileByteSize, this.destination);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "Result{filename='" + this.filename + '\'' + ", fileByteSize=" + this.fileByteSize + ", destination=" + this.destination + '}';
        }
    }
}

