/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TableDestinationCoderV3
extends AtomicCoder<TableDestination> {
    private static final @UnknownKeyFor @NonNull @Initialized TableDestinationCoderV3 INSTANCE = new TableDestinationCoderV3();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> timePartitioningCoder = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> clusteringCoder = NullableCoder.of((Coder)StringUtf8Coder.of());

    public static @UnknownKeyFor @NonNull @Initialized TableDestinationCoderV3 of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized TableDestination value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TableDestinationCoder.of().encode(value, outStream);
        timePartitioningCoder.encode((Object)value.getJsonTimePartitioning(), outStream);
        clusteringCoder.encode((Object)value.getJsonClustering(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized TableDestination decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TableDestination destination = TableDestinationCoder.of().decode(inStream);
        String jsonTimePartitioning = (String)timePartitioningCoder.decode(inStream);
        String jsonClustering = (String)clusteringCoder.decode(inStream);
        return new TableDestination(destination.getTableSpec(), destination.getTableDescription(), jsonTimePartitioning, jsonClustering);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
    }
}

