/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageSourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryStorageTableSource<@UnknownKeyFor T>
extends BigQueryStorageSourceBase<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageTableSource.class);
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> tableReferenceProvider;
    private transient @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Table> cachedTable;

    public static <T> @UnknownKeyFor @NonNull @Initialized BigQueryStorageTableSource<T> create(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> tableRefProvider, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFields, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestriction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new BigQueryStorageTableSource<T>(tableRefProvider, selectedFields, rowRestriction, parseFn, outputCoder, bqServices);
    }

    private BigQueryStorageTableSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> tableRefProvider, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFields, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestriction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        super(selectedFields, rowRestriction, parseFn, outputCoder, bqServices);
        this.tableReferenceProvider = (ValueProvider)Preconditions.checkNotNull(tableRefProvider, (Object)"tableRefProvider");
        this.cachedTable = new AtomicReference();
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException, @UnknownKeyFor @NonNull @Initialized IOException {
        in.defaultReadObject();
        this.cachedTable = new AtomicReference();
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTable(this.tableReferenceProvider)).withLabel("Table"));
    }

    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.getTargetTable((BigQueryOptions)options.as(BigQueryOptions.class)).getNumBytes();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Table getTargetTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.cachedTable.get() == null) {
            TableReference tableReference = (TableReference)this.tableReferenceProvider.get();
            if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                Preconditions.checkState((!Strings.isNullOrEmpty((String)options.getProject()) ? 1 : 0) != 0, (String)"No project ID set in %s or %s, cannot construct a complete %s", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName(), (Object)TableReference.class.getSimpleName());
                LOG.info("Project ID not set in {}. Using default project from {}.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
                tableReference.setProjectId(options.getProject());
            }
            Table table = this.bqServices.getDatasetService(options).getTable(tableReference);
            this.cachedTable.compareAndSet(null, table);
        }
        return this.cachedTable.get();
    }
}

