/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQueryStorageSourceBase<@UnknownKeyFor T>
extends BoundedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageSourceBase.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_SPLIT_COUNT = 10000;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_SPLIT_COUNT = 10;
    protected final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFieldsProvider;
    protected final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestrictionProvider;
    protected final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
    protected final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder;
    protected final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;

    BigQueryStorageSourceBase(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFieldsProvider, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestrictionProvider, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        this.selectedFieldsProvider = selectedFieldsProvider;
        this.rowRestrictionProvider = rowRestrictionProvider;
        this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized Table getTargetTable(@UnknownKeyFor @NonNull @Initialized BigQueryOptions var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ReadSession readSession;
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        Table targetTable = this.getTargetTable(bqOptions);
        ReadSession.Builder readSessionBuilder = ReadSession.newBuilder().setTable(BigQueryHelpers.toTableResourceName(targetTable.getTableReference())).setDataFormat(DataFormat.AVRO);
        if (this.selectedFieldsProvider != null || this.rowRestrictionProvider != null) {
            ReadSession.TableReadOptions.Builder tableReadOptionsBuilder = ReadSession.TableReadOptions.newBuilder();
            if (this.selectedFieldsProvider != null) {
                tableReadOptionsBuilder.addAllSelectedFields((Iterable)this.selectedFieldsProvider.get());
            }
            if (this.rowRestrictionProvider != null) {
                tableReadOptionsBuilder.setRowRestriction((String)this.rowRestrictionProvider.get());
            }
            readSessionBuilder.setReadOptions(tableReadOptionsBuilder);
        }
        int streamCount = 0;
        if (desiredBundleSizeBytes > 0L) {
            long tableSizeBytes = targetTable != null ? targetTable.getNumBytes() : 0L;
            streamCount = (int)Math.min(tableSizeBytes / desiredBundleSizeBytes, 10000L);
        }
        streamCount = Math.max(streamCount, 10);
        CreateReadSessionRequest createReadSessionRequest = CreateReadSessionRequest.newBuilder().setParent(BigQueryHelpers.toProjectResourceName(bqOptions.getProject())).setReadSession(readSessionBuilder).setMaxStreamCount(streamCount).build();
        try (BigQueryServices.StorageClient client = this.bqServices.getStorageClient(bqOptions);){
            readSession = client.createReadSession(createReadSessionRequest);
            LOG.info("Sent BigQuery Storage API CreateReadSession request '{}'; received response '{}'.", (Object)createReadSessionRequest, (Object)readSession);
        }
        if (readSession.getStreamsList().isEmpty()) {
            return ImmutableList.of();
        }
        Schema sessionSchema = new Schema.Parser().parse(readSession.getAvroSchema().getSchema());
        TableSchema trimmedSchema = BigQueryAvroUtils.trimBigQueryTableSchema(targetTable.getSchema(), sessionSchema);
        ArrayList sources = Lists.newArrayList();
        for (ReadStream readStream : readSession.getStreamsList()) {
            sources.add(BigQueryStorageStreamSource.create(readSession, readStream, trimmedSchema, this.parseFn, this.outputCoder, this.bqServices));
        }
        return ImmutableList.copyOf((Collection)sources);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("BigQuery storage source must be split before reading");
    }
}

