/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import java.io.Serializable;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReaderImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReaderSettings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class SubscriberOptions
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 269598118L;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private static final @UnknownKeyFor @NonNull @Initialized long MEBIBYTE = 0x100000L;
    public static final @UnknownKeyFor @NonNull @Initialized FlowControlSettings DEFAULT_FLOW_CONTROL = FlowControlSettings.builder().setMessagesOutstanding(Long.MAX_VALUE).setBytesOutstanding(0x6400000L).build();

    public abstract @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPath();

    public abstract @UnknownKeyFor @NonNull @Initialized FlowControlSettings flowControlSettings();

    public abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Partition> partitions();

    abstract @Nullable @UnknownKeyFor @Initialized SubscriberFactory subscriberFactory();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Committer> committerSupplier();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized TopicBacklogReader> backlogReaderSupplier();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized InitialOffsetReader> offsetReaderSupplier();

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        AutoValue_SubscriberOptions.Builder builder = new AutoValue_SubscriberOptions.Builder();
        return ((Builder)builder).setPartitions((Set<Partition>)ImmutableSet.of()).setFlowControlSettings(DEFAULT_FLOW_CONTROL);
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    @UnknownKeyFor @NonNull @Initialized SubscriberFactory getSubscriberFactory(@UnknownKeyFor @NonNull @Initialized Partition partition) {
        SubscriberFactory factory = this.subscriberFactory();
        if (factory != null) {
            return factory;
        }
        return consumer -> SubscriberBuilder.newBuilder().setMessageConsumer(consumer).setSubscriptionPath(this.subscriptionPath()).setPartition(partition).setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK)).build();
    }

    @UnknownKeyFor @NonNull @Initialized Committer getCommitter(@UnknownKeyFor @NonNull @Initialized Partition partition) {
        SerializableSupplier<Committer> supplier = this.committerSupplier();
        if (supplier != null) {
            return supplier.get();
        }
        return CommitterBuilder.newBuilder().setSubscriptionPath(this.subscriptionPath()).setPartition(partition).build();
    }

    @UnknownKeyFor @NonNull @Initialized TopicBacklogReader getBacklogReader(@UnknownKeyFor @NonNull @Initialized Partition partition) {
        SerializableSupplier<TopicBacklogReader> supplier = this.backlogReaderSupplier();
        if (supplier != null) {
            return supplier.get();
        }
        return TopicBacklogReaderSettings.newBuilder().setTopicPathFromSubscriptionPath(this.subscriptionPath()).setPartition(partition).build().instantiate();
    }

    @UnknownKeyFor @NonNull @Initialized InitialOffsetReader getInitialOffsetReader(@UnknownKeyFor @NonNull @Initialized Partition partition) {
        SerializableSupplier<InitialOffsetReader> supplier = this.offsetReaderSupplier();
        if (supplier != null) {
            return supplier.get();
        }
        return new InitialOffsetReaderImpl(CursorClient.create((CursorClientSettings)CursorClientSettings.newBuilder().setRegion(this.subscriptionPath().location().region()).build()), this.subscriptionPath(), partition);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriptionPath(@UnknownKeyFor @NonNull @Initialized SubscriptionPath var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitions(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Partition> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFlowControlSettings(@UnknownKeyFor @NonNull @Initialized FlowControlSettings var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriberFactory(@UnknownKeyFor @NonNull @Initialized SubscriberFactory var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCommitterSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Committer> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setBacklogReaderSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized TopicBacklogReader> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setOffsetReaderSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized InitialOffsetReader> var1);

        abstract @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPath();

        abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Partition> partitions();

        abstract @UnknownKeyFor @NonNull @Initialized SubscriberOptions autoBuild();

        public @UnknownKeyFor @NonNull @Initialized SubscriberOptions build() throws @UnknownKeyFor @NonNull @Initialized ApiException {
            if (!this.partitions().isEmpty()) {
                return this.autoBuild();
            }
            if (this.partitions().isEmpty()) {
                int partitionCount = PartitionLookupUtils.numPartitions((SubscriptionPath)this.subscriptionPath());
                ImmutableSet.Builder partitions = ImmutableSet.builder();
                for (int i = 0; i < partitionCount; ++i) {
                    partitions.add((Object)Partition.of((long)i));
                }
                this.setPartitions((Set<Partition>)partitions.build());
            }
            return this.autoBuild();
        }
    }
}

