/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoValue
public abstract class SpannerConfig
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_HOST = "https://batch-spanner.googleapis.com/";
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_COMMIT_DEADLINE = Duration.standardSeconds((long)15L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardMinutes((long)15L);

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getProjectId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getInstanceId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getDatabaseId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getHost();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getCommitDeadline();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getMaxCumulativeBackoff();

    @VisibleForTesting
    abstract @Nullable @UnknownKeyFor @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> getServiceFactory();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized SpannerConfig create() {
        return SpannerConfig.builder().setHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_HOST)).setCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_COMMIT_DEADLINE)).setMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_MAX_CUMULATIVE_BACKOFF)).build();
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_SpannerConfig.Builder();
    }

    public void validate() {
        Preconditions.checkNotNull(this.getInstanceId(), (Object)"SpannerIO.read() requires instance id to be set with withInstanceId method");
        Preconditions.checkNotNull(this.getDatabaseId(), (Object)"SpannerIO.read() requires database id to be set with withDatabaseId method");
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Output Project")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Output Instance")).addIfNotNull(DisplayData.item((String)"databaseId", this.getDatabaseId()).withLabel("Output Database"));
        if (this.getServiceFactory() != null) {
            builder.addIfNotNull(DisplayData.item((String)"serviceFactory", (String)this.getServiceFactory().getClass().getName()).withLabel("Service Factory"));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
        return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
        return this.toBuilder().setDatabaseId(databaseId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
        return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
        return this.toBuilder().setHost(host).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCommitDeadline(@UnknownKeyFor @NonNull @Initialized Duration commitDeadline) {
        return this.withCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)commitDeadline));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCommitDeadline(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> commitDeadline) {
        return this.toBuilder().setCommitDeadline(commitDeadline).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff) {
        return this.withMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)maxCumulativeBackoff));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> maxCumulativeBackoff) {
        return this.toBuilder().setMaxCumulativeBackoff(maxCumulativeBackoff).build();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized SpannerConfig withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
        return this.toBuilder().setServiceFactory(serviceFactory).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCommitDeadline(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig build();
    }
}

