/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_UuidDeduplicationOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableStatusFunction;
import org.apache.beam.sdk.io.gcp.pubsublite.Uuid;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.Deduplicate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoValue
public abstract class UuidDeduplicationOptions
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 9837489720893L;
    public static final @UnknownKeyFor @NonNull @Initialized SerializableStatusFunction<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @NonNull @Initialized Uuid> DEFAULT_UUID_EXTRACTOR = message -> {
        Preconditions.checkArgument((boolean)message.getMessage().getAttributesMap().containsKey("x-goog-pubsublite-dataflow-uuid"), (String)"Uuid attribute missing.");
        List attributes = ((AttributeValues)message.getMessage().getAttributesMap().get("x-goog-pubsublite-dataflow-uuid")).getValuesList();
        Preconditions.checkArgument((attributes.size() == 1 ? 1 : 0) != 0, (String)"Duplicate Uuid attribute values exist.");
        return Uuid.of((ByteString)attributes.get(0));
    };
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_HASH_PARTITIONS = 10000;
    public static final @UnknownKeyFor @NonNull @Initialized TimeDomain DEFAULT_TIME_DOMAIN = TimeDomain.EVENT_TIME;
    public static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_DEDUPLICATE_DURATION = Duration.standardDays((long)1L);

    public abstract @UnknownKeyFor @NonNull @Initialized SerializableStatusFunction<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @NonNull @Initialized Uuid> uuidExtractor();

    public abstract // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Deduplicate.KeyedValues<@UnknownKeyFor @NonNull @Initialized Uuid, @UnknownKeyFor @NonNull @Initialized SequencedMessage> deduplicate();

    public abstract @UnknownKeyFor @NonNull @Initialized int hashPartitions();

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        AutoValue_UuidDeduplicationOptions.Builder builder = new AutoValue_UuidDeduplicationOptions.Builder();
        ((Builder)builder).setUuidExtractor(DEFAULT_UUID_EXTRACTOR);
        ((Builder)builder).setDeduplicate((Deduplicate.KeyedValues<Uuid, SequencedMessage>)Deduplicate.keyedValues().withTimeDomain(DEFAULT_TIME_DOMAIN).withDuration(DEFAULT_DEDUPLICATE_DURATION));
        ((Builder)builder).setHashPartitions(10000);
        return builder;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setUuidExtractor(@UnknownKeyFor @NonNull @Initialized SerializableStatusFunction<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @NonNull @Initialized Uuid> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setDeduplicate(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Deduplicate.KeyedValues<@UnknownKeyFor @NonNull @Initialized Uuid, @UnknownKeyFor @NonNull @Initialized SequencedMessage> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setHashPartitions(@UnknownKeyFor @NonNull @Initialized int var1);

        public abstract @UnknownKeyFor @NonNull @Initialized UuidDeduplicationOptions build();
    }
}

