/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubJsonClient
extends PubsubClient {
    public static final @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory FACTORY = new PubsubJsonClientFactory();
    private final @Nullable @UnknownKeyFor @Initialized String timestampAttribute;
    private final @Nullable @UnknownKeyFor @Initialized String idAttribute;
    private @UnknownKeyFor @NonNull @Initialized Pubsub pubsub;

    @VisibleForTesting
    PubsubJsonClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized Pubsub pubsub) {
        this.timestampAttribute = timestampAttribute;
        this.idAttribute = idAttribute;
        this.pubsub = pubsub;
    }

    @Override
    public void close() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int publish(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> outgoingMessages) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<com.google.api.services.pubsub.model.PubsubMessage> pubsubMessages = new ArrayList<com.google.api.services.pubsub.model.PubsubMessage>(outgoingMessages.size());
        for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
            com.google.api.services.pubsub.model.PubsubMessage pubsubMessage = new com.google.api.services.pubsub.model.PubsubMessage().encodeData(outgoingMessage.message().getData().toByteArray());
            pubsubMessage.setAttributes(this.getMessageAttributes(outgoingMessage));
            if (!outgoingMessage.message().getOrderingKey().isEmpty()) {
                pubsubMessage.setOrderingKey(outgoingMessage.message().getOrderingKey());
            }
            pubsubMessages.add(pubsubMessage);
        }
        PublishRequest request = new PublishRequest().setMessages(pubsubMessages);
        PublishResponse response = (PublishResponse)this.pubsub.projects().topics().publish(topic.getPath(), request).execute();
        return response.getMessageIds().size();
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getMessageAttributes(@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage outgoingMessage) {
        TreeMap<String, String> attributes = null;
        attributes = outgoingMessage.message().getAttributesMap() == null ? new TreeMap<String, String>() : new TreeMap(outgoingMessage.message().getAttributesMap());
        if (this.timestampAttribute != null) {
            attributes.put(this.timestampAttribute, String.valueOf(outgoingMessage.timestampMsSinceEpoch()));
        }
        if (this.idAttribute != null && !Strings.isNullOrEmpty((String)outgoingMessage.recordId())) {
            attributes.put(this.idAttribute, outgoingMessage.recordId());
        }
        return attributes;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.IncomingMessage> pull(@UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int batchSize, @UnknownKeyFor @NonNull @Initialized boolean returnImmediately) throws @UnknownKeyFor @NonNull @Initialized IOException {
        PullRequest request = new PullRequest().setReturnImmediately(Boolean.valueOf(returnImmediately)).setMaxMessages(Integer.valueOf(batchSize));
        PullResponse response = (PullResponse)this.pubsub.projects().subscriptions().pull(subscription.getPath(), request).execute();
        if (response.getReceivedMessages() == null || response.getReceivedMessages().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>(response.getReceivedMessages().size());
        for (ReceivedMessage message : response.getReceivedMessages()) {
            byte[] elementBytes;
            com.google.api.services.pubsub.model.PubsubMessage pubsubMessage = message.getMessage();
            HashMap<String, String> attributes = pubsubMessage.getAttributes() != null ? pubsubMessage.getAttributes() : new HashMap<String, String>();
            byte[] byArray = elementBytes = pubsubMessage.getData() == null ? null : pubsubMessage.decodeData();
            if (elementBytes == null) {
                elementBytes = new byte[]{};
            }
            long timestampMsSinceEpoch = PubsubJsonClient.extractTimestamp(this.timestampAttribute, message.getMessage().getPublishTime(), attributes);
            String ackId = message.getAckId();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)ackId) ? 1 : 0) != 0);
            String recordId = null;
            if (this.idAttribute != null) {
                recordId = (String)attributes.get(this.idAttribute);
            }
            if (Strings.isNullOrEmpty(recordId)) {
                recordId = pubsubMessage.getMessageId();
            }
            PubsubMessage.Builder protoMessage = PubsubMessage.newBuilder();
            protoMessage.setData(ByteString.copyFrom((byte[])elementBytes));
            protoMessage.putAllAttributes(attributes);
            if (pubsubMessage.getOrderingKey() != null) {
                protoMessage.setOrderingKey(pubsubMessage.getOrderingKey());
            } else {
                protoMessage.setOrderingKey("");
            }
            incomingMessages.add(PubsubClient.IncomingMessage.of(protoMessage.build(), timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId));
        }
        return incomingMessages;
    }

    @Override
    public void acknowledge(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ackIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        AcknowledgeRequest request = new AcknowledgeRequest().setAckIds(ackIds);
        this.pubsub.projects().subscriptions().acknowledge(subscription.getPath(), request).execute();
    }

    @Override
    public void modifyAckDeadline(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ackIds, @UnknownKeyFor @NonNull @Initialized int deadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ModifyAckDeadlineRequest request = new ModifyAckDeadlineRequest().setAckIds(ackIds).setAckDeadlineSeconds(Integer.valueOf(deadlineSeconds));
        this.pubsub.projects().subscriptions().modifyAckDeadline(subscription.getPath(), request).execute();
    }

    @Override
    public void createTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pubsub.projects().topics().create(topic.getPath(), new Topic()).execute();
    }

    @Override
    public void deleteTopic(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pubsub.projects().topics().delete(topic.getPath()).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath> listTopics(@UnknownKeyFor @NonNull @Initialized PubsubClient.ProjectPath project) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Pubsub.Projects.Topics.List request = this.pubsub.projects().topics().list(project.getPath());
        ListTopicsResponse response = (ListTopicsResponse)request.execute();
        if (response.getTopics() == null || response.getTopics().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.TopicPath> topics = new ArrayList<PubsubClient.TopicPath>(response.getTopics().size());
        while (true) {
            for (Topic topic : response.getTopics()) {
                topics.add(PubsubJsonClient.topicPathFromPath(topic.getName()));
            }
            if (Strings.isNullOrEmpty((String)response.getNextPageToken())) break;
            request.setPageToken(response.getNextPageToken());
            response = (ListTopicsResponse)request.execute();
        }
        return topics;
    }

    @Override
    public void createSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic, @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Subscription request = new Subscription().setTopic(topic.getPath()).setAckDeadlineSeconds(Integer.valueOf(ackDeadlineSeconds));
        this.pubsub.projects().subscriptions().create(subscription.getPath(), request).execute();
    }

    @Override
    public void deleteSubscription(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.pubsub.projects().subscriptions().delete(subscription.getPath()).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath> listSubscriptions(@UnknownKeyFor @NonNull @Initialized PubsubClient.ProjectPath project, @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath topic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Pubsub.Projects.Subscriptions.List request = this.pubsub.projects().subscriptions().list(project.getPath());
        ListSubscriptionsResponse response = (ListSubscriptionsResponse)request.execute();
        if (response.getSubscriptions() == null || response.getSubscriptions().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.SubscriptionPath> subscriptions = new ArrayList<PubsubClient.SubscriptionPath>(response.getSubscriptions().size());
        while (true) {
            for (Subscription subscription : response.getSubscriptions()) {
                if (!subscription.getTopic().equals(topic.getPath())) continue;
                subscriptions.add(PubsubJsonClient.subscriptionPathFromPath(subscription.getName()));
            }
            if (Strings.isNullOrEmpty((String)response.getNextPageToken())) break;
            request.setPageToken(response.getNextPageToken());
            response = (ListSubscriptionsResponse)request.execute();
        }
        return subscriptions;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath subscription) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Subscription response = (Subscription)this.pubsub.projects().subscriptions().get(subscription.getPath()).execute();
        return response.getAckDeadlineSeconds();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isEOF() {
        return false;
    }

    private static class PubsubJsonClientFactory
    implements PubsubClient.PubsubClientFactory {
        private PubsubJsonClientFactory() {
        }

        private static @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer chainHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Credentials credential, @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer) {
            if (credential == null) {
                return httpRequestInitializer;
            }
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Pubsub pubsub = new Pubsub.Builder(Transport.getTransport(), Transport.getJsonFactory(), PubsubJsonClientFactory.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setRootUrl(options.getPubsubRootUrl()).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace()).build();
            return new PubsubJsonClient(timestampAttribute, idAttribute, pubsub);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getKind() {
            return "Json";
        }
    }
}

