/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.VendoredListenableFutureAdapter;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Closer;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.FutureCallback;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Futures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigtableServiceImpl
implements BigtableService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigtableServiceImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized BigtableOptions options;

    public BigtableServiceImpl(@UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
        this.options = options;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigtableOptions getBigtableOptions() {
        return this.options;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigtableWriterImpl openForWriting(@UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigtableSession session = new BigtableSession(this.options);
        BigtableTableName tableName = this.options.getInstanceName().toTableName(tableId);
        return new BigtableWriterImpl(session, tableName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean tableExists(@UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        boolean bl;
        BigtableSession session = new BigtableSession(this.options);
        Throwable throwable = null;
        try {
            GetTableRequest getTable = GetTableRequest.newBuilder().setName(this.options.getInstanceName().toTableNameStr(tableId)).build();
            session.getTableAdminClient().getTable(getTable);
            bl = true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    BigtableServiceImpl.$closeResource(throwable, (AutoCloseable)session);
                    throw throwable3;
                }
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    return false;
                }
                String message = String.format("Error checking whether table %s (BigtableOptions %s) exists", tableId, this.options);
                LOG.error(message, (Throwable)e);
                throw new IOException(message, e);
            }
        }
        BigtableServiceImpl.$closeResource(throwable, (AutoCloseable)session);
        return bl;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(BigtableServiceImpl.class).add("options", (Object)this.options).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BigtableService.Reader createReader(@UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource source) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigtableSession session = new BigtableSession(this.options);
        return new BigtableReaderImpl(session, source);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SampleRowKeysResponse> getSampleRowKeys(@UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource source) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (BigtableSession session = new BigtableSession(this.options);){
            SampleRowKeysRequest request = SampleRowKeysRequest.newBuilder().setTableName(this.options.getInstanceName().toTableNameStr((String)source.getTableId().get())).build();
            List list = session.getDataClient().sampleRowKeys(request);
            return list;
        }
    }

    @VisibleForTesting
    static class BigtableWriterImpl
    implements BigtableService.Writer {
        private @UnknownKeyFor @NonNull @Initialized BigtableSession session;
        private @UnknownKeyFor @NonNull @Initialized BulkMutation bulkMutation;

        BigtableWriterImpl(@UnknownKeyFor @NonNull @Initialized BigtableSession session, @UnknownKeyFor @NonNull @Initialized BigtableTableName tableName) {
            this.session = session;
            this.bulkMutation = session.createBulkMutation(tableName);
        }

        @Override
        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.bulkMutation != null) {
                try {
                    this.bulkMutation.flush();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
            }
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            block6: {
                try {
                    if (this.bulkMutation == null) break block6;
                    try {
                        this.bulkMutation.flush();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(e);
                    }
                    this.bulkMutation = null;
                }
                finally {
                    if (this.session != null) {
                        this.session.close();
                        this.session = null;
                    }
                }
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @NonNull @Initialized MutateRowResponse> writeRecord(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> record) throws @UnknownKeyFor @NonNull @Initialized IOException {
            MutateRowsRequest.Entry request = MutateRowsRequest.Entry.newBuilder().setRowKey((ByteString)record.getKey()).addAllMutations((Iterable)record.getValue()).build();
            final CompletableFuture<MutateRowResponse> result = new CompletableFuture<MutateRowResponse>();
            Futures.addCallback(new VendoredListenableFutureAdapter(this.bulkMutation.add(request)), (FutureCallback)new FutureCallback<MutateRowResponse>(){

                public void onSuccess(@UnknownKeyFor @NonNull @Initialized MutateRowResponse mutateRowResponse) {
                    result.complete(mutateRowResponse);
                }

                public void onFailure(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                    result.completeExceptionally(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
            return result;
        }
    }

    @VisibleForTesting
    static class BigtableReaderImpl
    implements BigtableService.Reader {
        private @UnknownKeyFor @NonNull @Initialized BigtableSession session;
        private final @UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource source;
        private @UnknownKeyFor @NonNull @Initialized ResultScanner<@UnknownKeyFor @NonNull @Initialized Row> results;
        private @UnknownKeyFor @NonNull @Initialized Row currentRow;

        @VisibleForTesting
        BigtableReaderImpl(@UnknownKeyFor @NonNull @Initialized BigtableSession session, @UnknownKeyFor @NonNull @Initialized BigtableIO.BigtableSource source) {
            this.session = session;
            this.source = source;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            RowSet.Builder rowSetBuilder = RowSet.newBuilder();
            for (ByteKeyRange sourceRange : this.source.getRanges()) {
                rowSetBuilder = rowSetBuilder.addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFrom((ByteBuffer)sourceRange.getStartKey().getValue())).setEndKeyOpen(ByteString.copyFrom((ByteBuffer)sourceRange.getEndKey().getValue())));
            }
            RowSet rowSet = rowSetBuilder.build();
            String tableNameSr = this.session.getOptions().getInstanceName().toTableNameStr((String)this.source.getTableId().get());
            ReadRowsRequest.Builder requestB = ReadRowsRequest.newBuilder().setRows(rowSet).setTableName(tableNameSr);
            if (this.source.getRowFilter() != null) {
                requestB.setFilter(this.source.getRowFilter());
            }
            this.results = this.session.getDataClient().readRows(requestB.build());
            return this.advance();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.currentRow = (Row)this.results.next();
            return this.currentRow != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.session == null) {
                return;
            }
            try (Closer closer = Closer.create();){
                if (this.results != null) {
                    closer.register(this.results);
                    this.results = null;
                }
                this.session.close();
            }
            finally {
                this.session = null;
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row getCurrentRow() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            return this.currentRow;
        }
    }
}

