/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.RowToPubsubMessage;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.io.InvalidSchemaException;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class PubsubSchemaIOProvider
implements SchemaIOProvider {
    public static final Schema.FieldType VARCHAR = Schema.FieldType.STRING;
    public static final Schema.FieldType TIMESTAMP = Schema.FieldType.DATETIME;

    public String identifier() {
        return "pubsub";
    }

    public Schema configurationSchema() {
        return Schema.builder().addNullableField("timestampAttributeKey", Schema.FieldType.STRING).addNullableField("deadLetterQueue", Schema.FieldType.STRING).build();
    }

    public PubsubSchemaIO from(String location, Row configuration, Schema dataSchema) {
        this.validateConfigurationSchema(configuration);
        this.validateDlq((String)configuration.getValue("deadLetterQueue"));
        this.validateDataSchema(dataSchema);
        return new PubsubSchemaIO(location, configuration, dataSchema);
    }

    public boolean requiresDataSchema() {
        return true;
    }

    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    private void validateDataSchema(Schema schema) {
        if (schema == null) {
            throw new InvalidSchemaException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must not be null");
        }
        if (!PubsubSchemaIO.fieldPresent(schema, "event_timestamp", PubsubSchemaIOProvider.TIMESTAMP)) {
            throw new InvalidSchemaException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must include at least 'event_timestamp' field of type 'TIMESTAMP'");
        }
    }

    private void validateDlq(String deadLetterQueue) {
        if (deadLetterQueue != null && deadLetterQueue.isEmpty()) {
            throw new InvalidConfigurationException("Dead letter queue topic name is not specified");
        }
    }

    private void validateConfigurationSchema(Row configuration) {
        if (!configuration.getSchema().equals((Object)this.configurationSchema())) {
            throw new InvalidConfigurationException("Configuration schema provided does not match expected");
        }
    }

    @AutoValue
    static abstract class Config
    implements Serializable {
        Config() {
        }

        abstract @Nullable String getTimestampAttributeKey();

        abstract @Nullable String getDeadLetterQueue();

        boolean useDeadLetterQueue() {
            return this.getDeadLetterQueue() != null;
        }

        boolean useTimestampAttribute() {
            return this.getTimestampAttributeKey() != null;
        }
    }

    private static class PubsubSchemaIO
    implements SchemaIO,
    Serializable {
        protected final Schema dataSchema;
        protected final String location;
        protected final boolean useFlatSchema;
        protected final Config config;

        private PubsubSchemaIO(String location, Row config, Schema dataSchema) {
            this.dataSchema = dataSchema;
            this.location = location;
            this.useFlatSchema = !this.definesAttributeAndPayload(dataSchema);
            this.config = (Config)new AutoValueSchema().fromRowFunction(TypeDescriptor.of(Config.class)).apply((Object)config);
        }

        public Schema schema() {
            return this.dataSchema;
        }

        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public PCollection<Row> expand(PBegin begin) {
                    PCollectionTuple rowsWithDlq = (PCollectionTuple)((PCollection)begin.apply("ReadFromPubsub", (PTransform)this.readMessagesWithAttributes())).apply("PubsubMessageToRow", (PTransform)PubsubMessageToRow.builder().messageSchema(dataSchema).useDlq(config.useDeadLetterQueue()).useFlatSchema(useFlatSchema).build());
                    rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG).setRowSchema(dataSchema);
                    if (config.useDeadLetterQueue()) {
                        rowsWithDlq.get(PubsubMessageToRow.DLQ_TAG).apply((PTransform)this.writeMessagesToDlq());
                    }
                    return rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG);
                }
            };
        }

        public PTransform<PCollection<Row>, POutput> buildWriter() {
            if (!this.useFlatSchema) {
                throw new UnsupportedOperationException("Writing to a Pubsub topic is only supported for flattened schemas");
            }
            return new PTransform<PCollection<Row>, POutput>(){

                public POutput expand(PCollection<Row> input) {
                    return ((PCollection)input.apply((PTransform)RowToPubsubMessage.withTimestampAttribute(config.useTimestampAttribute()))).apply((PTransform)this.createPubsubMessageWrite());
                }
            };
        }

        private PubsubIO.Read<PubsubMessage> readMessagesWithAttributes() {
            PubsubIO.Read<PubsubMessage> read = PubsubIO.readMessagesWithAttributes().fromTopic(this.location);
            return this.config.useTimestampAttribute() ? read.withTimestampAttribute(this.config.getTimestampAttributeKey()) : read;
        }

        private PubsubIO.Write<PubsubMessage> createPubsubMessageWrite() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.location);
            if (this.config.useTimestampAttribute()) {
                write = write.withTimestampAttribute(this.config.getTimestampAttributeKey());
            }
            return write;
        }

        private PubsubIO.Write<PubsubMessage> writeMessagesToDlq() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.config.getDeadLetterQueue());
            return this.config.useTimestampAttribute() ? write.withTimestampAttribute(this.config.getTimestampAttributeKey()) : write;
        }

        private boolean definesAttributeAndPayload(Schema schema) {
            return PubsubSchemaIO.fieldPresent(schema, "attributes", Schema.FieldType.map((Schema.FieldType)VARCHAR.withNullable(false), (Schema.FieldType)VARCHAR)) && schema.hasField("payload") && Schema.TypeName.ROW.equals((Object)schema.getField("payload").getType().getTypeName());
        }

        private static boolean fieldPresent(Schema schema, String field, Schema.FieldType expectedType) {
            return schema.hasField(field) && expectedType.equivalent(schema.getField(field).getType(), Schema.EquivalenceNullablePolicy.IGNORE);
        }
    }
}

