/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryHelpers {
    private static final String RESOURCE_NOT_FOUND_ERROR = "BigQuery %1$s not found for table \"%2$s\" . Please create the %1$s before pipeline execution. If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";
    private static final String UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR = "Unable to confirm BigQuery %1$s presence for table \"%2$s\". If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryHelpers.class);

    static RetryJobIdResult getRetryJobId(RetryJobId currentJobId, SerializableFunction<RetryJobId, Job> lookupJob) {
        int retryIndex = currentJobId.getRetryIndex();
        while (true) {
            RetryJobId jobId = new RetryJobId(currentJobId.getJobIdPrefix(), retryIndex);
            try {
                Job loadJob = (Job)lookupJob.apply((Object)jobId);
                if (loadJob == null) {
                    LOG.info("job id {} not found, so retrying with that id", (Object)jobId);
                    return new RetryJobIdResult(jobId, true);
                }
                JobStatus jobStatus = loadJob.getStatus();
                if (jobStatus == null) {
                    LOG.info("job status for {} not found, so retrying with that job id", (Object)jobId);
                    return new RetryJobIdResult(jobId, true);
                }
                if ("PENDING".equals(jobStatus.getState()) || "RUNNING".equals(jobStatus.getState())) {
                    LOG.info("job {} in pending or running state, so continuing with that job id", (Object)jobId);
                    return new RetryJobIdResult(jobId, false);
                }
                if (jobStatus.getErrorResult() == null && (jobStatus.getErrors() == null || jobStatus.getErrors().isEmpty())) {
                    LOG.info("job {} succeeded, so not retrying ", (Object)jobId);
                    return new RetryJobIdResult(jobId, false);
                }
                LOG.info("job {} is failed. Checking the next job id", (Object)jobId);
            }
            catch (RuntimeException e) {
                LOG.info("caught exception while querying job {}", (Object)jobId);
                return new RetryJobIdResult(jobId, true);
            }
            ++retryIndex;
        }
    }

    static String toProjectResourceName(String projectName) {
        return "projects/" + projectName;
    }

    static String toTableResourceName(TableReference tableReference) {
        return "projects/" + tableReference.getProjectId() + "/datasets/" + tableReference.getDatasetId() + "/tables/" + tableReference.getTableId();
    }

    static @Nullable ValueProvider<String> displayTable(@Nullable ValueProvider<TableReference> table) {
        if (table == null) {
            return null;
        }
        return ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToTableSpec());
    }

    public static String toTableSpec(TableReference ref) {
        StringBuilder sb = new StringBuilder();
        if (ref.getProjectId() != null) {
            sb.append(ref.getProjectId());
            sb.append(":");
        }
        sb.append(ref.getDatasetId()).append('.').append(ref.getTableId());
        return sb.toString();
    }

    static <K, V> List<V> getOrCreateMapListValue(Map<K, List<V>> map, K key) {
        return map.computeIfAbsent(key, k -> new ArrayList());
    }

    public static TableReference parseTableSpec(String tableSpec) {
        Matcher match = BigQueryIO.TABLE_SPEC.matcher(tableSpec);
        if (!match.matches()) {
            throw new IllegalArgumentException("Table reference is not in [project_id]:[dataset_id].[table_id] format: " + tableSpec);
        }
        TableReference ref = new TableReference();
        ref.setProjectId(match.group("PROJECT"));
        return ref.setDatasetId(match.group("DATASET")).setTableId(match.group("TABLE"));
    }

    public static String stripPartitionDecorator(String tableSpec) {
        int index = tableSpec.lastIndexOf(36);
        return index == -1 ? tableSpec : tableSpec.substring(0, index);
    }

    static String jobToPrettyString(@Nullable Job job) throws IOException {
        if (job != null && job.getConfiguration().getLoad() != null) {
            job = job.clone();
            job.getConfiguration().getLoad().setSchema(null);
            job.getConfiguration().getLoad().setSourceUris(null);
        }
        return job == null ? "null" : job.toPrettyString();
    }

    static String statusToPrettyString(@Nullable JobStatus status) throws IOException {
        return status == null ? "Unknown status: null." : status.toPrettyString();
    }

    static Status parseStatus(@Nullable Job job) {
        if (job == null) {
            return Status.UNKNOWN;
        }
        JobStatus status = job.getStatus();
        if (status.getErrorResult() != null) {
            return Status.FAILED;
        }
        if (status.getErrors() != null && !status.getErrors().isEmpty()) {
            return Status.FAILED;
        }
        return Status.SUCCEEDED;
    }

    public static String toJsonString(Object item) {
        if (item == null) {
            return null;
        }
        try {
            return BigQueryIO.JSON_FACTORY.toString(item);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot serialize %s to a JSON string.", item.getClass().getSimpleName()), e);
        }
    }

    public static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)BigQueryIO.JSON_FACTORY.fromString(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot deserialize %s from a JSON string: %s.", clazz, json), e);
        }
    }

    static String randomUUIDString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    static void verifyTableNotExistOrEmpty(BigQueryServices.DatasetService datasetService, TableReference tableRef) {
        try {
            if (datasetService.getTable(tableRef) != null) {
                Preconditions.checkState((boolean)datasetService.isTableEmpty(tableRef), (String)"BigQuery table is not empty: %s.", (Object)BigQueryHelpers.toTableSpec(tableRef));
            }
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("unable to confirm BigQuery table emptiness for table " + BigQueryHelpers.toTableSpec(tableRef), e);
        }
    }

    static void verifyDatasetPresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getDataset(table.getProjectId(), table.getDatasetId());
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "dataset", BigQueryHelpers.toTableSpec(table)), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "dataset", BigQueryHelpers.toTableSpec(table)), e);
        }
    }

    public static @Nullable BigInteger getNumRows(BigQueryOptions options, TableReference tableRef) throws InterruptedException, IOException {
        BigQueryServices.DatasetService datasetService = new BigQueryServicesImpl().getDatasetService(options);
        Table table = datasetService.getTable(tableRef);
        if (table == null) {
            return null;
        }
        return table.getNumRows();
    }

    static String getDatasetLocation(BigQueryServices.DatasetService datasetService, String projectId, String datasetId) {
        Dataset dataset;
        try {
            dataset = datasetService.getDataset(projectId, datasetId);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(String.format("unable to obtain dataset for dataset %s in project %s", datasetId, projectId), e);
        }
        return dataset.getLocation();
    }

    static void verifyTablePresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getTable(table);
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "table", BigQueryHelpers.toTableSpec(table)), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "table", BigQueryHelpers.toTableSpec(table)), e);
        }
    }

    static String resolveTempLocation(String tempLocationDir, String bigQueryOperationName, String stepUuid) {
        return FileSystems.matchNewResource((String)tempLocationDir, (boolean)true).resolve(bigQueryOperationName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(stepUuid, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).toString();
    }

    static class TimePartitioningToJson
    implements SerializableFunction<TimePartitioning, String> {
        TimePartitioningToJson() {
        }

        public String apply(TimePartitioning partitioning) {
            return BigQueryHelpers.toJsonString(partitioning);
        }
    }

    @VisibleForTesting
    static class TableSpecToTableRef
    implements SerializableFunction<String, TableReference> {
        TableSpecToTableRef() {
        }

        public TableReference apply(String from) {
            return BigQueryHelpers.parseTableSpec(from);
        }
    }

    static class TableRefToTableSpec
    implements SerializableFunction<TableReference, String> {
        TableRefToTableSpec() {
        }

        public String apply(TableReference from) {
            return BigQueryHelpers.toTableSpec(from);
        }
    }

    static class TableRefToJson
    implements SerializableFunction<TableReference, String> {
        TableRefToJson() {
        }

        public String apply(TableReference from) {
            return BigQueryHelpers.toJsonString(from);
        }
    }

    static class JsonTableRefToTableSpec
    implements SerializableFunction<String, String> {
        JsonTableRefToTableSpec() {
        }

        public String apply(String from) {
            return BigQueryHelpers.toTableSpec(BigQueryHelpers.fromJsonString(from, TableReference.class));
        }
    }

    static class JsonTableRefToTableRef
    implements SerializableFunction<String, TableReference> {
        JsonTableRefToTableRef() {
        }

        public TableReference apply(String from) {
            return BigQueryHelpers.fromJsonString(from, TableReference.class);
        }
    }

    static class TableSchemaToJsonSchema
    implements SerializableFunction<TableSchema, String> {
        TableSchemaToJsonSchema() {
        }

        public String apply(TableSchema from) {
            return BigQueryHelpers.toJsonString(from);
        }
    }

    @VisibleForTesting
    static class JsonSchemaToTableSchema
    implements SerializableFunction<String, TableSchema> {
        JsonSchemaToTableSchema() {
        }

        public TableSchema apply(String from) {
            return BigQueryHelpers.fromJsonString(from, TableSchema.class);
        }
    }

    static enum Status {
        SUCCEEDED,
        FAILED,
        UNKNOWN;

    }

    static class RetryJobId {
        private final String jobIdPrefix;
        private final int retryIndex;

        RetryJobId(String jobIdPrefix, int retryIndex) {
            this.jobIdPrefix = jobIdPrefix;
            this.retryIndex = retryIndex;
        }

        String getJobIdPrefix() {
            return this.jobIdPrefix;
        }

        int getRetryIndex() {
            return this.retryIndex;
        }

        String getJobId() {
            return this.jobIdPrefix + "-" + this.retryIndex;
        }

        public String toString() {
            return this.getJobId();
        }
    }

    static class PendingJob {
        private final SerializableFunction<RetryJobId, Void> executeJob;
        private final SerializableFunction<RetryJobId, Job> pollJob;
        private final SerializableFunction<RetryJobId, Job> lookupJob;
        private final int maxRetries;
        private int currentAttempt;
        RetryJobId currentJobId;
        Job lastJobAttempted;
        boolean started;

        PendingJob(SerializableFunction<RetryJobId, Void> executeJob, SerializableFunction<RetryJobId, Job> pollJob, SerializableFunction<RetryJobId, Job> lookupJob, int maxRetries, String jobIdPrefix) {
            this.executeJob = executeJob;
            this.pollJob = pollJob;
            this.lookupJob = lookupJob;
            this.maxRetries = maxRetries;
            this.currentAttempt = 0;
            this.currentJobId = new RetryJobId(jobIdPrefix, 0);
            this.started = false;
        }

        void runJob() throws IOException {
            block3: {
                ++this.currentAttempt;
                if (!this.shouldRetry()) {
                    throw new RuntimeException(String.format("Failed to create job with prefix %s, reached max retries: %d, last failed job: %s.", this.currentJobId.getJobIdPrefix(), this.maxRetries, BigQueryHelpers.jobToPrettyString(this.lastJobAttempted)));
                }
                try {
                    this.started = false;
                    this.executeJob.apply((Object)this.currentJobId);
                }
                catch (RuntimeException e) {
                    LOG.warn("Job {} failed with {}", (Object)this.currentJobId.getJobId(), (Object)e);
                    RetryJobIdResult result = BigQueryHelpers.getRetryJobId(this.currentJobId, this.lookupJob);
                    this.currentJobId = result.jobId;
                    if (!result.shouldRetry) break block3;
                    LOG.info("Will retry with job id {}", (Object)this.currentJobId.getJobId());
                    return;
                }
            }
            LOG.info("job {} started", (Object)this.currentJobId.getJobId());
            this.started = true;
        }

        boolean pollJob() throws IOException {
            if (this.started) {
                Job job;
                this.lastJobAttempted = job = (Job)this.pollJob.apply((Object)this.currentJobId);
                Status jobStatus = BigQueryHelpers.parseStatus(job);
                switch (jobStatus) {
                    case SUCCEEDED: {
                        LOG.info("Load job {} succeeded. Statistics: {}", (Object)this.currentJobId, (Object)job.getStatistics());
                        return true;
                    }
                    case UNKNOWN: {
                        LOG.info("Load job {} finished in unknown state: {}: {}", new Object[]{this.currentJobId, job.getStatus(), this.shouldRetry() ? "will retry" : "will not retry"});
                        return false;
                    }
                    case FAILED: {
                        String oldJobId = this.currentJobId.getJobId();
                        this.currentJobId = BigQueryHelpers.getRetryJobId((RetryJobId)this.currentJobId, this.lookupJob).jobId;
                        LOG.info("Load job {} failed, {}: {}. Next job id {}", new Object[]{oldJobId, this.shouldRetry() ? "will retry" : "will not retry", job.getStatus(), this.currentJobId});
                        return false;
                    }
                }
                throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", job.getStatus(), BigQueryHelpers.jobToPrettyString(job)));
            }
            return false;
        }

        boolean shouldRetry() {
            return this.currentAttempt < this.maxRetries + 1;
        }
    }

    static class PendingJobManager {
        private List<JobInfo> pendingJobs = Lists.newArrayList();
        private final BackOff backOff;

        PendingJobManager() {
            this(BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(Integer.MAX_VALUE).withInitialBackoff(Duration.standardSeconds((long)1L)).withMaxBackoff(Duration.standardMinutes((long)1L)).backoff()));
        }

        PendingJobManager(BackOff backOff) {
            this.backOff = backOff;
        }

        PendingJobManager addPendingJob(PendingJob pendingJob, @Nullable SerializableFunction<PendingJob, Exception> onSuccess) {
            this.pendingJobs.add(new JobInfo(pendingJob, onSuccess));
            return this;
        }

        void waitForDone() throws Exception {
            LOG.info("Waiting for jobs to complete.");
            Sleeper sleeper = Sleeper.DEFAULT;
            while (!this.pendingJobs.isEmpty()) {
                ArrayList retryJobs = Lists.newArrayList();
                for (JobInfo jobInfo : this.pendingJobs) {
                    if (jobInfo.pendingJob.pollJob()) {
                        LOG.info("Job {} completed successfully.", (Object)((JobInfo)jobInfo).pendingJob.currentJobId);
                        Exception e = (Exception)jobInfo.onSuccess.apply((Object)jobInfo.pendingJob);
                        if (e == null) continue;
                        throw e;
                    }
                    LOG.info("Job {} pending. retrying.", (Object)((JobInfo)jobInfo).pendingJob.currentJobId);
                    retryJobs.add(jobInfo);
                }
                this.pendingJobs = retryJobs;
                if (this.pendingJobs.isEmpty()) continue;
                PendingJobManager.nextBackOff(sleeper, this.backOff);
                for (JobInfo job : this.pendingJobs) {
                    job.pendingJob.runJob();
                }
            }
        }

        private static boolean nextBackOff(Sleeper sleeper, BackOff backOff) throws InterruptedException {
            try {
                return BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static class JobInfo {
            private final PendingJob pendingJob;
            private final @Nullable SerializableFunction<PendingJob, Exception> onSuccess;

            public JobInfo(PendingJob pendingJob, SerializableFunction<PendingJob, Exception> onSuccess) {
                this.pendingJob = pendingJob;
                this.onSuccess = onSuccess;
            }
        }
    }

    static class RetryJobIdResult {
        public final RetryJobId jobId;
        public final boolean shouldRetry;

        public RetryJobIdResult(RetryJobId jobId, boolean shouldRetry) {
            this.jobId = jobId;
            this.shouldRetry = shouldRetry;
        }
    }
}

