/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.proto.CursorServiceGrpc;
import com.google.cloud.pubsublite.proto.SubscriberServiceGrpc;
import io.grpc.StatusException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class SubscriberOptions
implements Serializable {
    private static final long serialVersionUID = 269598118L;
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    abstract SubscriptionPath subscriptionPath();

    abstract FlowControlSettings flowControlSettings();

    abstract Set<Partition> partitions();

    abstract @Nullable SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
    SubscriberServiceGrpc.SubscriberServiceStub> subscriberStubSupplier();

    abstract @Nullable SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
    CursorServiceGrpc.CursorServiceStub> committerStubSupplier();

    abstract @Nullable SubscriberFactory subscriberFactory();

    abstract @Nullable SerializableSupplier<Committer> committerSupplier();

    public static Builder newBuilder() {
        AutoValue_SubscriberOptions.Builder builder = new AutoValue_SubscriberOptions.Builder();
        return ((Builder)builder).setPartitions((Set<Partition>)ImmutableSet.of());
    }

    public abstract Builder toBuilder();

    Map<Partition, SubscriberFactory> getSubscriberFactories() {
        ImmutableMap.Builder factories = ImmutableMap.builder();
        for (Partition partition : this.partitions()) {
            factories.put((Object)partition, (Object)((SubscriberFactory)Optional.fromNullable((Object)this.subscriberFactory()).or(consumer -> {
                SubscriberBuilder.Builder builder = SubscriberBuilder.newBuilder();
                builder.setMessageConsumer(consumer);
                builder.setSubscriptionPath(this.subscriptionPath());
                builder.setPartition(partition);
                builder.setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK));
                if (this.subscriberStubSupplier() != null) {
                    builder.setSubscriberServiceStub(this.subscriberStubSupplier().get());
                }
                return builder.build();
            })));
        }
        return factories.build();
    }

    Map<Partition, Committer> getCommitters() throws StatusException {
        ImmutableMap.Builder committers = ImmutableMap.builder();
        for (Partition partition : this.partitions()) {
            if (this.committerSupplier() != null) {
                committers.put((Object)partition, (Object)this.committerSupplier().get());
                continue;
            }
            CommitterBuilder.Builder builder = CommitterBuilder.newBuilder();
            builder.setSubscriptionPath(this.subscriptionPath());
            builder.setPartition(partition);
            if (this.committerStubSupplier() != null) {
                builder.setCursorStub(this.committerStubSupplier().get());
            }
            committers.put((Object)partition, (Object)builder.build());
        }
        return committers.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartitions(Set<Partition> var1);

        public abstract Builder setFlowControlSettings(FlowControlSettings var1);

        public abstract Builder setSubscriberStubSupplier(SerializableSupplier<SubscriberServiceGrpc.SubscriberServiceStub> var1);

        public abstract Builder setCommitterStubSupplier(SerializableSupplier<CursorServiceGrpc.CursorServiceStub> var1);

        abstract Builder setSubscriberFactory(SubscriberFactory var1);

        abstract Builder setCommitterSupplier(SerializableSupplier<Committer> var1);

        abstract SubscriberOptions autoBuild();

        public SubscriberOptions build() throws StatusException {
            SubscriberOptions built = this.autoBuild();
            if (!built.partitions().isEmpty()) {
                return built;
            }
            int partitionCount = PartitionLookupUtils.numPartitions((SubscriptionPath)built.subscriptionPath());
            Builder builder = built.toBuilder();
            ImmutableSet.Builder partitions = ImmutableSet.builder();
            for (int i = 0; i < partitionCount; ++i) {
                partitions.add((Object)Partition.of((long)i));
            }
            return builder.setPartitions((Set<Partition>)partitions.build()).autoBuild();
        }
    }
}

