/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.core.ApiFuture;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteUnboundedReader_PartitionedSequencedMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetCheckpointMark;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetFinalizer;
import org.apache.beam.sdk.io.gcp.pubsublite.PullSubscriber;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.joda.time.base.AbstractInstant;

class PubsubLiteUnboundedReader
extends UnboundedSource.UnboundedReader<SequencedMessage>
implements OffsetFinalizer {
    private final UnboundedSource<SequencedMessage, ?> source;
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    private final ImmutableMap<Partition, SubscriberState> subscriberMap;
    private final CommitterProxy committerProxy;
    @GuardedBy(value="monitor.monitor")
    private final Queue<PartitionedSequencedMessage> messages = new ArrayDeque<PartitionedSequencedMessage>();
    @GuardedBy(value="monitor.monitor")
    private Optional<StatusException> permanentError = Optional.empty();

    public PubsubLiteUnboundedReader(UnboundedSource<SequencedMessage, ?> source, Map<Partition, SubscriberState> subscriberMap) throws StatusException {
        this.source = source;
        this.subscriberMap = ImmutableMap.copyOf(subscriberMap);
        this.committerProxy = new CommitterProxy(subscriberMap.values(), error -> {
            CloseableMonitor.Hold h = this.monitor.enter();
            Throwable throwable = null;
            try {
                this.permanentError = Optional.of(this.permanentError.orElse((StatusException)((Object)error)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    PubsubLiteUnboundedReader.$closeResource(throwable, (AutoCloseable)h);
                }
            }
        });
        this.committerProxy.startAsync().awaitRunning();
    }

    @Override
    public void finalizeOffsets(Map<Partition, Offset> offsets) throws StatusException {
        ArrayList<ApiFuture> commitFutures = new ArrayList<ApiFuture>();
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            for (Partition partition : offsets.keySet()) {
                if (!this.subscriberMap.containsKey((Object)partition)) {
                    throw Status.INVALID_ARGUMENT.withDescription(String.format("Asked to finalize an offset for partition %s which was not managed by this reader.", partition)).asException();
                }
                commitFutures.add(((SubscriberState)this.subscriberMap.get((Object)partition)).committer.commitOffset(offsets.get(partition)));
            }
        }
        commitFutures.forEach(commitFuture -> ExtractStatus.addFailureHandler((ApiFuture)commitFuture, error -> {
            CloseableMonitor.Hold h = this.monitor.enter();
            Throwable throwable = null;
            try {
                if (!this.permanentError.isPresent()) {
                    this.permanentError = Optional.of(error);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    PubsubLiteUnboundedReader.$closeResource(throwable, (AutoCloseable)h);
                }
            }
        }));
    }

    public boolean start() throws IOException {
        return this.advance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean advance() throws IOException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.permanentError.isPresent()) {
                throw this.permanentError.get();
            }
            if (!this.messages.isEmpty()) {
                PartitionedSequencedMessage partitionedSequencedMessage = this.messages.poll();
            }
            if (!this.messages.isEmpty()) {
                this.setLastDelivered(this.messages.peek());
                boolean bl = true;
                return bl;
            }
            this.pullFromSubscribers();
            if (!this.messages.isEmpty()) {
                this.setLastDelivered(this.messages.peek());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (StatusException e) {
            throw new IOException(e);
        }
    }

    @GuardedBy(value="monitor.monitor")
    private void setLastDelivered(PartitionedSequencedMessage message) {
        SubscriberState state = (SubscriberState)this.subscriberMap.get((Object)message.partition());
        state.lastDelivered = Optional.of(Offset.of((long)message.sequencedMessage().getCursor().getOffset()));
        Timestamp timestamp = message.sequencedMessage().getPublishTime();
        state.lastDeliveredPublishTimestamp = new Instant(Timestamps.toMillis((Timestamp)timestamp));
    }

    @GuardedBy(value="monitor.monitor")
    private void pullFromSubscribers() throws StatusException {
        for (Map.Entry entry : this.subscriberMap.entrySet()) {
            for (SequencedMessage message : ((SubscriberState)entry.getValue()).subscriber.pull()) {
                this.messages.add(PartitionedSequencedMessage.of((Partition)entry.getKey(), message));
            }
        }
    }

    public SequencedMessage getCurrent() throws NoSuchElementException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.messages.isEmpty()) {
                throw new NoSuchElementException();
            }
            SequencedMessage sequencedMessage = this.messages.peek().sequencedMessage();
            return sequencedMessage;
        }
    }

    public Instant getCurrentTimestamp() throws NoSuchElementException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.messages.isEmpty()) {
                throw new NoSuchElementException();
            }
            Instant instant = new Instant(Timestamps.toMillis((Timestamp)this.messages.peek().sequencedMessage().getPublishTime()));
            return instant;
        }
    }

    /*
     * Exception decompiling
     */
    public void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Instant getWatermark() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Instant instant = this.subscriberMap.values().stream().map(state -> state.lastDeliveredPublishTimestamp).min(AbstractInstant::compareTo).get();
            return instant;
        }
    }

    public UnboundedSource.CheckpointMark getCheckpointMark() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.subscriberMap.forEach((partition, subscriberState) -> subscriberState.lastDelivered.ifPresent(offset -> builder.put(partition, offset)));
            OffsetCheckpointMark offsetCheckpointMark = new OffsetCheckpointMark(this, (Map<Partition, Offset>)builder.build());
            return offsetCheckpointMark;
        }
    }

    public UnboundedSource<SequencedMessage, ?> getCurrentSource() {
        return this.source;
    }

    @AutoValue
    static abstract class PartitionedSequencedMessage {
        PartitionedSequencedMessage() {
        }

        abstract Partition partition();

        abstract SequencedMessage sequencedMessage();

        private static PartitionedSequencedMessage of(Partition partition, SequencedMessage sequencedMessage) {
            return new AutoValue_PubsubLiteUnboundedReader_PartitionedSequencedMessage(partition, sequencedMessage);
        }
    }

    static class SubscriberState {
        Instant lastDeliveredPublishTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
        Optional<Offset> lastDelivered = Optional.empty();
        PullSubscriber subscriber;
        Committer committer;

        SubscriberState() {
        }
    }

    private static class CommitterProxy
    extends ProxyService {
        private final Consumer<StatusException> permanentErrorSetter;

        CommitterProxy(Collection<SubscriberState> states, Consumer<StatusException> permanentErrorSetter) throws StatusException {
            this.permanentErrorSetter = permanentErrorSetter;
            this.addServices(states.stream().map(state -> state.committer).collect(Collectors.toList()));
        }

        protected void start() {
        }

        protected void stop() {
        }

        protected void handlePermanentError(StatusException error) {
            this.permanentErrorSetter.accept(error);
        }
    }
}

