/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.healthcare.v1beta1.model.Message;
import com.google.api.services.healthcare.v1beta1.model.SchematizedData;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;

public class HL7v2Message {
    private final String name;
    private final String messageType;
    private final String sendTime;
    private final String createTime;
    private final String data;
    private final String sendFacility;
    private String schematizedData;
    private final Map<String, String> labels;

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return this.getData();
        }
    }

    public static HL7v2Message fromModel(Message msg) {
        SchematizedData schematizedData = msg.getSchematizedData();
        return new HL7v2Message(msg.getName(), msg.getMessageType(), msg.getSendTime(), msg.getCreateTime(), msg.getData(), msg.getSendFacility(), schematizedData != null ? schematizedData.getData() : null, msg.getLabels());
    }

    public Message toModel() {
        Message out = new Message();
        out.setName(this.getName());
        out.setMessageType(this.getMessageType());
        out.setSendTime(this.getSendTime());
        out.setCreateTime(this.getCreateTime());
        out.setData(this.getData());
        out.setSendFacility(this.getSendFacility());
        out.setSchematizedData(new SchematizedData().setData(this.schematizedData));
        out.setLabels(this.labels);
        return out;
    }

    public HL7v2Message(String name, String messageType, String sendTime, String createTime, String data, String sendFacility, @Nullable String schematizedData, @Nullable Map<String, String> labels) {
        this.name = name;
        this.messageType = messageType;
        this.sendTime = sendTime;
        this.createTime = createTime;
        this.data = data;
        this.sendFacility = sendFacility;
        this.schematizedData = schematizedData;
        this.labels = labels;
    }

    public String getName() {
        return this.name;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getData() {
        return this.data;
    }

    public String getSendFacility() {
        return this.sendFacility;
    }

    public String getSchematizedData() {
        return this.schematizedData;
    }

    public void setSchematizedData(String schematizedData) {
        this.schematizedData = schematizedData;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }
}

