/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.ReifyAsIterable;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV3;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WriteGroupedRecordsToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WritePartition;
import org.apache.beam.sdk.io.gcp.bigquery.WriteRename;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchLoads<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    static final Logger LOG = LoggerFactory.getLogger(BatchLoads.class);
    @VisibleForTesting
    static final int DEFAULT_MAX_NUM_WRITERS_PER_BUNDLE = 20;
    @VisibleForTesting
    static final int DEFAULT_MAX_FILES_PER_PARTITION = 10000;
    @VisibleForTesting
    static final long DEFAULT_MAX_BYTES_PER_PARTITION = 0xB0000000000L;
    static final long DEFAULT_MAX_FILE_SIZE = 0x40000000000L;
    static final int DEFAULT_NUM_FILE_SHARDS = 0;
    static final int FILE_TRIGGERING_RECORD_COUNT = 500000;
    static final int LOAD_JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    static final int DEFAULT_MAX_RETRY_JOBS = 3;
    private BigQueryServices bigQueryServices = new BigQueryServicesImpl();
    private final BigQueryIO.Write.WriteDisposition writeDisposition;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
    private final boolean ignoreUnknownValues;
    private final boolean useAvroLogicalTypes;
    private final boolean singletonTable;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final Coder<DestinationT> destinationCoder;
    private int maxNumWritersPerBundle;
    private long maxFileSize;
    private int maxFilesPerPartition;
    private long maxBytesPerPartition;
    private int numFileShards;
    private Duration triggeringFrequency;
    private ValueProvider<String> customGcsTempLocation;
    private ValueProvider<String> loadJobProjectId;
    private final Coder<ElementT> elementCoder;
    private final RowWriterFactory<ElementT, DestinationT> rowWriterFactory;
    private String kmsKey;
    private boolean clusteringEnabled;
    private int maxRetryJobs = 3;

    BatchLoads(BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, boolean singletonTable, DynamicDestinations<?, DestinationT> dynamicDestinations, Coder<DestinationT> destinationCoder, ValueProvider<String> customGcsTempLocation, @Nullable ValueProvider<String> loadJobProjectId, boolean ignoreUnknownValues, Coder<ElementT> elementCoder, RowWriterFactory<ElementT, DestinationT> rowWriterFactory, @Nullable String kmsKey, boolean clusteringEnabled, boolean useAvroLogicalTypes) {
        this.writeDisposition = writeDisposition;
        this.createDisposition = createDisposition;
        this.singletonTable = singletonTable;
        this.dynamicDestinations = dynamicDestinations;
        this.destinationCoder = destinationCoder;
        this.maxNumWritersPerBundle = 20;
        this.maxFileSize = 0x40000000000L;
        this.numFileShards = 0;
        this.maxFilesPerPartition = 10000;
        this.maxBytesPerPartition = 0xB0000000000L;
        this.triggeringFrequency = null;
        this.customGcsTempLocation = customGcsTempLocation;
        this.loadJobProjectId = loadJobProjectId;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.useAvroLogicalTypes = useAvroLogicalTypes;
        this.elementCoder = elementCoder;
        this.kmsKey = kmsKey;
        this.rowWriterFactory = rowWriterFactory;
        this.clusteringEnabled = clusteringEnabled;
        this.schemaUpdateOptions = Collections.emptySet();
    }

    void setSchemaUpdateOptions(Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
        this.schemaUpdateOptions = schemaUpdateOptions;
    }

    void setTestServices(BigQueryServices bigQueryServices) {
        this.bigQueryServices = bigQueryServices;
    }

    public int getMaxNumWritersPerBundle() {
        return this.maxNumWritersPerBundle;
    }

    public void setMaxNumWritersPerBundle(int maxNumWritersPerBundle) {
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
    }

    public void setTriggeringFrequency(Duration triggeringFrequency) {
        this.triggeringFrequency = triggeringFrequency;
    }

    public int getMaxRetryJobs() {
        return this.maxRetryJobs;
    }

    public void setMaxRetryJobs(int maxRetryJobs) {
        this.maxRetryJobs = maxRetryJobs;
    }

    public void setNumFileShards(int numFileShards) {
        this.numFileShards = numFileShards;
    }

    @VisibleForTesting
    void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @VisibleForTesting
    void setMaxFilesPerPartition(int maxFilesPerPartition) {
        this.maxFilesPerPartition = maxFilesPerPartition;
    }

    @VisibleForTesting
    void setMaxBytesPerPartition(long maxBytesPerPartition) {
        this.maxBytesPerPartition = maxBytesPerPartition;
    }

    public void validate(PipelineOptions options) {
        String tempLocation;
        if (this.customGcsTempLocation == null) {
            tempLocation = options.getTempLocation();
        } else {
            if (!this.customGcsTempLocation.isAccessible()) {
                return;
            }
            tempLocation = (String)this.customGcsTempLocation.get();
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Write needs a GCS temp location to store temp files.This can be set by withCustomGcsTempLocation() in the Builderor through the fallback pipeline option --tempLocation.");
        if (this.bigQueryServices == null) {
            try {
                GcsPath.fromUri((String)tempLocation);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
            }
        }
    }

    private WriteResult expandTriggered(PCollection<KV<DestinationT, ElementT>> input) {
        Preconditions.checkArgument((this.numFileShards > 0 ? 1 : 0) != 0);
        Pipeline p = input.getPipeline();
        PCollectionView<String> loadJobIdPrefixView = this.createLoadJobIdPrefixView(p);
        PCollectionView<String> tempFilePrefixView = this.createTempFilePrefixView(p, loadJobIdPrefixView);
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.triggeringFrequency), AfterPane.elementCountAtLeast((int)500000)}))).discardingFiredPanes());
        PCollection results = this.writeShardedFiles(inputInGlobalWindow, tempFilePrefixView);
        results = (PCollection)results.apply("applyUserTrigger", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.triggeringFrequency))).discardingFiredPanes());
        TupleTag multiPartitionsTag = new TupleTag("multiPartitionsTag");
        TupleTag singlePartitionTag = new TupleTag("singlePartitionTag");
        PCollectionTuple partitions = (PCollectionTuple)((PCollection)((PCollection)((PCollection)results.apply("AttachSingletonKey", (PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), WriteBundlesToFiles.ResultCoder.of(this.destinationCoder))).apply("GroupOntoSingleton", (PTransform)GroupByKey.create())).apply("ExtractResultValues", (PTransform)Values.create())).apply("WritePartitionTriggered", (PTransform)ParDo.of(new WritePartition<DestinationT>(this.singletonTable, this.dynamicDestinations, tempFilePrefixView, this.maxFilesPerPartition, this.maxBytesPerPartition, multiPartitionsTag, singlePartitionTag, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefixView}).withOutputTags(multiPartitionsTag, TupleTagList.of((TupleTag)singlePartitionTag)));
        PCollection<KV<TableDestination, String>> tempTables = this.writeTempTables(partitions.get(multiPartitionsTag), loadJobIdPrefixView);
        ((PCollection)((PCollection)((PCollection)((PCollection)tempTables.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))))).apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)tempTables.getCoder())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply("WriteRenameTriggered", (PTransform)ParDo.of((DoFn)new WriteRename(this.bigQueryServices, loadJobIdPrefixView, this.writeDisposition, this.createDisposition, this.maxRetryJobs, this.kmsKey)).withSideInputs(new PCollectionView[]{loadJobIdPrefixView}));
        this.writeSinglePartition(partitions.get(singlePartitionTag), loadJobIdPrefixView);
        return this.writeResult(p);
    }

    public WriteResult expandUntriggered(PCollection<KV<DestinationT, ElementT>> input) {
        Pipeline p = input.getPipeline();
        PCollectionView<String> loadJobIdPrefixView = this.createLoadJobIdPrefixView(p);
        PCollectionView<String> tempFilePrefixView = this.createTempFilePrefixView(p, loadJobIdPrefixView);
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes());
        PCollection<WriteBundlesToFiles.Result<DestinationT>> results = this.numFileShards == 0 ? this.writeDynamicallyShardedFiles(inputInGlobalWindow, tempFilePrefixView) : this.writeShardedFiles(inputInGlobalWindow, tempFilePrefixView);
        TupleTag multiPartitionsTag = new TupleTag<KV<ShardedKey<DestinationT>, List<String>>>("multiPartitionsTag"){};
        TupleTag singlePartitionTag = new TupleTag<KV<ShardedKey<DestinationT>, List<String>>>("singlePartitionTag"){};
        PCollectionTuple partitions = (PCollectionTuple)((PCollection)results.apply("ReifyResults", new ReifyAsIterable())).setCoder((Coder)IterableCoder.of(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder))).apply("WritePartitionUntriggered", (PTransform)ParDo.of(new WritePartition<DestinationT>(this.singletonTable, this.dynamicDestinations, tempFilePrefixView, this.maxFilesPerPartition, this.maxBytesPerPartition, multiPartitionsTag, singlePartitionTag, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefixView}).withOutputTags(multiPartitionsTag, TupleTagList.of((TupleTag)singlePartitionTag)));
        PCollection<KV<TableDestination, String>> tempTables = this.writeTempTables(partitions.get(multiPartitionsTag), loadJobIdPrefixView);
        ((PCollection)tempTables.apply("ReifyRenameInput", new ReifyAsIterable())).apply("WriteRenameUntriggered", (PTransform)ParDo.of((DoFn)new WriteRename(this.bigQueryServices, loadJobIdPrefixView, this.writeDisposition, this.createDisposition, this.maxRetryJobs, this.kmsKey)).withSideInputs(new PCollectionView[]{loadJobIdPrefixView}));
        this.writeSinglePartition(partitions.get(singlePartitionTag), loadJobIdPrefixView);
        return this.writeResult(p);
    }

    private PCollectionView<String> createLoadJobIdPrefixView(Pipeline p) {
        return (PCollectionView)((PCollection)((PCollection)p.apply("JobIdCreationRoot", (PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply("CreateJobId", (PTransform)ParDo.of((DoFn)new DoFn<Void, String>(){

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
                c.output((Object)String.format("beam_load_%s_%s", c.getPipelineOptions().getJobName().replaceAll("-", ""), BigQueryHelpers.randomUUIDString()));
            }
        }))).apply((PTransform)View.asSingleton());
    }

    private PCollectionView<String> createTempFilePrefixView(Pipeline p, final PCollectionView<String> jobIdView) {
        return (PCollectionView)((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)"", (Object[])new String[0]))).apply("GetTempFilePrefix", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void getTempFilePrefix(DoFn.ProcessContext c) {
                String tempLocationRoot = BatchLoads.this.customGcsTempLocation != null ? (String)BatchLoads.this.customGcsTempLocation.get() : c.getPipelineOptions().getTempLocation();
                String tempLocation = BigQueryHelpers.resolveTempLocation(tempLocationRoot, "BigQueryWriteTemp", (String)c.sideInput(jobIdView));
                LOG.info("Writing BigQuery temporary files to {} before loading them.", (Object)tempLocation);
                c.output((Object)tempLocation);
            }
        }).withSideInputs(new PCollectionView[]{jobIdView}))).apply("TempFilePrefixView", (PTransform)View.asSingleton());
    }

    PCollection<WriteBundlesToFiles.Result<DestinationT>> writeDynamicallyShardedFiles(PCollection<KV<DestinationT, ElementT>> input, PCollectionView<String> tempFilePrefix) {
        TupleTag writtenFilesTag = new TupleTag<WriteBundlesToFiles.Result<DestinationT>>("writtenFiles"){};
        TupleTag unwrittedRecordsTag = new TupleTag<KV<ShardedKey<DestinationT>, ElementT>>("unwrittenRecords"){};
        PCollectionTuple writeBundlesTuple = (PCollectionTuple)input.apply("WriteBundlesToFiles", (PTransform)ParDo.of(new WriteBundlesToFiles<DestinationT, ElementT>(tempFilePrefix, unwrittedRecordsTag, this.maxNumWritersPerBundle, this.maxFileSize, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefix}).withOutputTags(writtenFilesTag, TupleTagList.of((TupleTag)unwrittedRecordsTag)));
        PCollection writtenFiles = writeBundlesTuple.get(writtenFilesTag).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
        PCollection unwrittenRecords = writeBundlesTuple.get(unwrittedRecordsTag).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of(this.destinationCoder), this.elementCoder));
        PCollection<WriteBundlesToFiles.Result<DestinationT>> writtenFilesGrouped = this.writeShardedRecords(unwrittenRecords, tempFilePrefix);
        return ((PCollection)PCollectionList.of((PCollection)writtenFiles).and(writtenFilesGrouped).apply("FlattenFiles", (PTransform)Flatten.pCollections())).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
    }

    PCollection<WriteBundlesToFiles.Result<DestinationT>> writeShardedFiles(PCollection<KV<DestinationT, ElementT>> input, PCollectionView<String> tempFilePrefix) {
        Preconditions.checkState((this.numFileShards > 0 ? 1 : 0) != 0);
        PCollection shardedRecords = ((PCollection)input.apply("AddShard", (PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, ElementT>, KV<ShardedKey<DestinationT>, ElementT>>(){
            int shardNumber;

            @DoFn.Setup
            public void setup() {
                this.shardNumber = ThreadLocalRandom.current().nextInt(BatchLoads.this.numFileShards);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element KV<DestinationT, ElementT> element, DoFn.OutputReceiver<KV<ShardedKey<DestinationT>, ElementT>> o) {
                Object destination = element.getKey();
                o.output((Object)KV.of((Object)ShardedKey.of((Object)destination, (int)(++this.shardNumber % BatchLoads.this.numFileShards)), (Object)element.getValue()));
            }
        }))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of(this.destinationCoder), this.elementCoder));
        return this.writeShardedRecords(shardedRecords, tempFilePrefix);
    }

    private PCollection<WriteBundlesToFiles.Result<DestinationT>> writeShardedRecords(PCollection<KV<ShardedKey<DestinationT>, ElementT>> shardedRecords, PCollectionView<String> tempFilePrefix) {
        return ((PCollection)((PCollection)shardedRecords.apply("GroupByDestination", (PTransform)GroupByKey.create())).apply("WriteGroupedRecords", (PTransform)ParDo.of(new WriteGroupedRecordsToFiles<DestinationT, ElementT>(tempFilePrefix, this.maxFileSize, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefix}))).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
    }

    private PCollection<KV<TableDestination, String>> writeTempTables(PCollection<KV<ShardedKey<DestinationT>, List<String>>> input, PCollectionView<String> jobIdTokenView) {
        ArrayList sideInputs = Lists.newArrayList((Object[])new PCollectionView[]{jobIdTokenView});
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        KvCoder partitionsCoder = KvCoder.of((Coder)ShardedKeyCoder.of((Coder)NullableCoder.of(this.destinationCoder)), (Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        DynamicDestinations<?, DestinationT> destinations = this.dynamicDestinations;
        if (this.createDisposition.equals((Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED) || this.createDisposition.equals((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER)) {
            destinations = DynamicDestinationsHelpers.matchTableDynamicDestinations(destinations, this.bigQueryServices);
        }
        AtomicCoder tableDestinationCoder = this.clusteringEnabled ? TableDestinationCoderV3.of() : TableDestinationCoderV2.of();
        return ((PCollection)((PCollection)input.setCoder((Coder)partitionsCoder).apply("MultiPartitionsReshuffle", (PTransform)Reshuffle.of())).apply("MultiPartitionsWriteTables", new WriteTables<DestinationT>(true, this.bigQueryServices, jobIdTokenView, BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED, sideInputs, destinations, this.loadJobProjectId, this.maxRetryJobs, this.ignoreUnknownValues, this.kmsKey, this.rowWriterFactory.getSourceFormat(), this.useAvroLogicalTypes, this.schemaUpdateOptions))).setCoder((Coder)KvCoder.of((Coder)tableDestinationCoder, (Coder)StringUtf8Coder.of()));
    }

    void writeSinglePartition(PCollection<KV<ShardedKey<DestinationT>, List<String>>> input, PCollectionView<String> loadJobIdPrefixView) {
        ArrayList sideInputs = Lists.newArrayList((Object[])new PCollectionView[]{loadJobIdPrefixView});
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        KvCoder partitionsCoder = KvCoder.of((Coder)ShardedKeyCoder.of((Coder)NullableCoder.of(this.destinationCoder)), (Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        ((PCollection)input.setCoder((Coder)partitionsCoder).apply("SinglePartitionsReshuffle", (PTransform)Reshuffle.of())).apply("SinglePartitionWriteTables", new WriteTables<DestinationT>(false, this.bigQueryServices, loadJobIdPrefixView, this.writeDisposition, this.createDisposition, sideInputs, this.dynamicDestinations, this.loadJobProjectId, this.maxRetryJobs, this.ignoreUnknownValues, this.kmsKey, this.rowWriterFactory.getSourceFormat(), this.useAvroLogicalTypes, this.schemaUpdateOptions));
    }

    private WriteResult writeResult(Pipeline p) {
        PCollection empty = (PCollection)p.apply("CreateEmptyFailedInserts", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(TableRow.class)));
        return WriteResult.in(p, (TupleTag<TableRow>)new TupleTag("failedInserts"), (PCollection<TableRow>)empty);
    }

    public WriteResult expand(PCollection<KV<DestinationT, ElementT>> input) {
        return this.triggeringFrequency != null ? this.expandTriggered(input) : this.expandUntriggered(input);
    }
}

