/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.Type;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema_Column;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema_KeyPart;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

@AutoValue
abstract class SpannerSchema
implements Serializable {
    SpannerSchema() {
    }

    abstract ImmutableList<String> tables();

    abstract ImmutableListMultimap<String, Column> columns();

    abstract ImmutableListMultimap<String, KeyPart> keyParts();

    abstract ImmutableTable<String, String, Long> cellsMutatedPerColumn();

    abstract ImmutableMap<String, Long> cellsMutatedPerRow();

    public static Builder builder() {
        return new AutoValue_SpannerSchema.Builder();
    }

    public List<String> getTables() {
        return this.tables();
    }

    public List<Column> getColumns(String table) {
        return this.columns().get((Object)table.toLowerCase());
    }

    public List<KeyPart> getKeyParts(String table) {
        return this.keyParts().get((Object)table.toLowerCase());
    }

    public long getCellsMutatedPerColumn(String table, String column) {
        return (Long)this.cellsMutatedPerColumn().row((Object)table.toLowerCase()).getOrDefault((Object)column.toLowerCase(), (Object)1L);
    }

    public long getCellsMutatedPerRow(String table) {
        return (Long)this.cellsMutatedPerRow().getOrDefault((Object)table.toLowerCase(), (Object)1L);
    }

    @AutoValue
    static abstract class Column
    implements Serializable {
        Column() {
        }

        static Column create(String name, Type type) {
            return new AutoValue_SpannerSchema_Column(name, type);
        }

        static Column create(String name, String spannerType) {
            return Column.create(name, Column.parseSpannerType(spannerType));
        }

        public abstract String getName();

        public abstract Type getType();

        private static Type parseSpannerType(String spannerType) {
            if ("BOOL".equals(spannerType = spannerType.toUpperCase())) {
                return Type.bool();
            }
            if ("INT64".equals(spannerType)) {
                return Type.int64();
            }
            if ("FLOAT64".equals(spannerType)) {
                return Type.float64();
            }
            if (spannerType.startsWith("STRING")) {
                return Type.string();
            }
            if (spannerType.startsWith("BYTES")) {
                return Type.bytes();
            }
            if ("TIMESTAMP".equals(spannerType)) {
                return Type.timestamp();
            }
            if ("DATE".equals(spannerType)) {
                return Type.date();
            }
            if (spannerType.startsWith("ARRAY")) {
                String spannerArrayType = spannerType.substring(6, spannerType.length() - 1);
                Type itemType = Column.parseSpannerType(spannerArrayType);
                return Type.array((Type)itemType);
            }
            throw new IllegalArgumentException("Unknown spanner type " + spannerType);
        }
    }

    @AutoValue
    static abstract class KeyPart
    implements Serializable {
        KeyPart() {
        }

        static KeyPart create(String field, boolean desc) {
            return new AutoValue_SpannerSchema_KeyPart(field, desc);
        }

        abstract String getField();

        abstract boolean isDesc();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setTables(ImmutableList<String> var1);

        abstract ImmutableListMultimap.Builder<String, Column> columnsBuilder();

        abstract ImmutableListMultimap.Builder<String, KeyPart> keyPartsBuilder();

        abstract ImmutableTable.Builder<String, String, Long> cellsMutatedPerColumnBuilder();

        abstract ImmutableMap.Builder<String, Long> cellsMutatedPerRowBuilder();

        abstract ImmutableListMultimap<String, Column> columns();

        abstract ImmutableTable<String, String, Long> cellsMutatedPerColumn();

        @VisibleForTesting
        public Builder addColumn(String table, String name, String type) {
            return this.addColumn(table, name, type, 1L);
        }

        public Builder addColumn(String table, String name, String type, long cellsMutated) {
            String tableLower = table.toLowerCase();
            String nameLower = name.toLowerCase();
            this.columnsBuilder().put((Object)tableLower, (Object)Column.create(nameLower, type));
            this.cellsMutatedPerColumnBuilder().put((Object)tableLower, (Object)nameLower, (Object)cellsMutated);
            return this;
        }

        public Builder addKeyPart(String table, String column, boolean desc) {
            this.keyPartsBuilder().put((Object)table.toLowerCase(), (Object)KeyPart.create(column.toLowerCase(), desc));
            return this;
        }

        abstract SpannerSchema autoBuild();

        public final SpannerSchema build() {
            this.cellsMutatedPerRowBuilder().putAll(Maps.transformValues((Map)this.cellsMutatedPerColumn().rowMap(), entry -> entry.values().stream().mapToLong(Long::longValue).sum()));
            this.setTables((ImmutableList<String>)ImmutableList.copyOf((Collection)this.columns().keySet()));
            return this.autoBuild();
        }
    }
}

