/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

@AutoValue
abstract class BatchSpannerRead
extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
    BatchSpannerRead() {
    }

    public static BatchSpannerRead create(SpannerConfig spannerConfig, PCollectionView<Transaction> txView, TimestampBound timestampBound) {
        return new AutoValue_BatchSpannerRead(spannerConfig, txView, timestampBound);
    }

    abstract SpannerConfig getSpannerConfig();

    @Nullable
    abstract PCollectionView<Transaction> getTxView();

    abstract TimestampBound getTimestampBound();

    public PCollection<Struct> expand(PCollection<ReadOperation> input) {
        PCollectionView txView = this.getTxView();
        if (txView == null) {
            Pipeline begin = input.getPipeline();
            SpannerIO.CreateTransaction createTx = SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound());
            txView = (PCollectionView)begin.apply((PTransform)createTx);
        }
        return (PCollection)((PCollection)((PCollection)input.apply("Generate Partitions", (PTransform)ParDo.of((DoFn)new GeneratePartitionsFn(this.getSpannerConfig(), txView)).withSideInputs(new PCollectionView[]{txView}))).apply("Shuffle partitions", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Partitions", (PTransform)ParDo.of((DoFn)new ReadFromPartitionFn(this.getSpannerConfig(), (PCollectionView<? extends Transaction>)txView)).withSideInputs(new PCollectionView[]{txView}));
    }

    private static class ReadFromPartitionFn
    extends DoFn<Partition, Struct> {
        private final SpannerConfig config;
        private final PCollectionView<? extends Transaction> txView;
        private transient SpannerAccessor spannerAccessor;

        public ReadFromPartitionFn(SpannerConfig config, PCollectionView<? extends Transaction> txView) {
            this.config = config;
            this.txView = txView;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = SpannerAccessor.create(this.config);
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction batchTx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            Partition p = (Partition)c.element();
            try (ResultSet resultSet = batchTx.execute(p);){
                while (resultSet.next()) {
                    Struct s = resultSet.getCurrentRowAsStruct();
                    c.output((Object)s);
                }
            }
        }
    }

    @VisibleForTesting
    static class GeneratePartitionsFn
    extends DoFn<ReadOperation, Partition> {
        private final SpannerConfig config;
        private final PCollectionView<? extends Transaction> txView;
        private transient SpannerAccessor spannerAccessor;

        public GeneratePartitionsFn(SpannerConfig config, PCollectionView<? extends Transaction> txView) {
            this.config = config;
            this.txView = txView;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = SpannerAccessor.create(this.config);
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction context = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            for (Partition p : this.execute((ReadOperation)c.element(), context)) {
                c.output((Object)p);
            }
        }

        private List<Partition> execute(ReadOperation op, BatchReadOnlyTransaction tx) {
            if (op.getQuery() != null) {
                return tx.partitionQuery(op.getPartitionOptions(), op.getQuery(), new Options.QueryOption[0]);
            }
            if (op.getIndex() != null) {
                return tx.partitionReadUsingIndex(op.getPartitionOptions(), op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
            }
            return tx.partitionRead(op.getPartitionOptions(), op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
        }
    }
}

