/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@Experimental
public class PubsubTestClient
extends PubsubClient
implements Serializable {
    private static final State STATE = new State();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PubsubTestClientFactory createFactoryForPublish(PubsubClient.TopicPath expectedTopic, Iterable<PubsubClient.OutgoingMessage> expectedOutgoingMessages, Iterable<PubsubClient.OutgoingMessage> failingOutgoingMessages) {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((!PubsubTestClient.STATE.isActive ? 1 : 0) != 0, (Object)"Test still in flight");
            PubsubTestClient.STATE.expectedTopic = expectedTopic;
            PubsubTestClient.STATE.remainingExpectedOutgoingMessages = Sets.newHashSet(expectedOutgoingMessages);
            PubsubTestClient.STATE.remainingFailingOutgoingMessages = Sets.newHashSet(failingOutgoingMessages);
            PubsubTestClient.STATE.isActive = true;
        }
        return new PubsubTestClientFactory(){

            @Override
            public PubsubClient newClient(@Nullable String timestampAttribute, @Nullable String idAttribute, PubsubOptions options) throws IOException {
                return new PubsubTestClient();
            }

            @Override
            public String getKind() {
                return "PublishTest";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                State state = STATE;
                synchronized (state) {
                    Preconditions.checkState((boolean)STATE.isActive, (Object)"No test still in flight");
                    Preconditions.checkState((boolean)STATE.remainingExpectedOutgoingMessages.isEmpty(), (String)"Still waiting for %s messages to be published", (int)STATE.remainingExpectedOutgoingMessages.size());
                    STATE.isActive = false;
                    STATE.remainingExpectedOutgoingMessages = null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PubsubTestClientFactory createFactoryForPull(Clock clock, PubsubClient.SubscriptionPath expectedSubscription, int ackTimeoutSec, Iterable<PubsubClient.IncomingMessage> expectedIncomingMessages) {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((!PubsubTestClient.STATE.isActive ? 1 : 0) != 0, (Object)"Test still in flight");
            PubsubTestClient.STATE.clock = clock;
            PubsubTestClient.STATE.expectedSubscription = expectedSubscription;
            PubsubTestClient.STATE.ackTimeoutSec = ackTimeoutSec;
            PubsubTestClient.STATE.remainingPendingIncomingMessages = Lists.newArrayList(expectedIncomingMessages);
            PubsubTestClient.STATE.pendingAckIncomingMessages = new HashMap<String, PubsubClient.IncomingMessage>();
            PubsubTestClient.STATE.ackDeadline = new HashMap<String, Long>();
            PubsubTestClient.STATE.isActive = true;
        }
        return new PubsubTestClientFactory(){

            @Override
            public PubsubClient newClient(@Nullable String timestampAttribute, @Nullable String idAttribute, PubsubOptions options) throws IOException {
                return new PubsubTestClient();
            }

            @Override
            public String getKind() {
                return "PullTest";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                State state = STATE;
                synchronized (state) {
                    Preconditions.checkState((boolean)STATE.isActive, (Object)"No test still in flight");
                    Preconditions.checkState((boolean)STATE.remainingPendingIncomingMessages.isEmpty(), (String)"Still waiting for %s messages to be pulled", (int)STATE.remainingPendingIncomingMessages.size());
                    Preconditions.checkState((boolean)STATE.pendingAckIncomingMessages.isEmpty(), (String)"Still waiting for %s messages to be ACKed", (int)STATE.pendingAckIncomingMessages.size());
                    Preconditions.checkState((boolean)STATE.ackDeadline.isEmpty(), (String)"Still waiting for %s messages to be ACKed", (int)STATE.ackDeadline.size());
                    STATE.isActive = false;
                    STATE.remainingPendingIncomingMessages = null;
                    STATE.pendingAckIncomingMessages = null;
                    STATE.ackDeadline = null;
                }
            }
        };
    }

    public static PubsubTestClientFactory createFactoryForCreateSubscription() {
        return new PubsubTestClientFactory(){
            int numCalls = 0;

            @Override
            public void close() throws IOException {
                Preconditions.checkState((this.numCalls == 1 ? 1 : 0) != 0, (String)"Expected exactly one subscription to be created, got %s", (int)this.numCalls);
            }

            @Override
            public PubsubClient newClient(@Nullable String timestampAttribute, @Nullable String idAttribute, PubsubOptions options) throws IOException {
                return new PubsubTestClient(){

                    @Override
                    public void createSubscription(PubsubClient.TopicPath topic, PubsubClient.SubscriptionPath subscription, int ackDeadlineSeconds) throws IOException {
                        Preconditions.checkState((numCalls == 0 ? 1 : 0) != 0, (Object)"Expected at most one subscription to be created");
                        ++numCalls;
                    }
                };
            }

            @Override
            public String getKind() {
                return "CreateSubscriptionTest";
            }
        };
    }

    private boolean inPullMode() {
        Preconditions.checkState((boolean)PubsubTestClient.STATE.isActive, (Object)"No test is active");
        return PubsubTestClient.STATE.expectedSubscription != null;
    }

    private boolean inPublishMode() {
        Preconditions.checkState((boolean)PubsubTestClient.STATE.isActive, (Object)"No test is active");
        return PubsubTestClient.STATE.expectedTopic != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advance() {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only advance in pull mode");
            Iterator<Map.Entry<String, Long>> deadlineItr = PubsubTestClient.STATE.ackDeadline.entrySet().iterator();
            while (deadlineItr.hasNext()) {
                Map.Entry<String, Long> entry = deadlineItr.next();
                if (entry.getValue() > PubsubTestClient.STATE.clock.currentTimeMillis()) continue;
                PubsubTestClient.STATE.remainingPendingIncomingMessages.add(PubsubTestClient.STATE.pendingAckIncomingMessages.remove(entry.getKey()));
                deadlineItr.remove();
            }
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int publish(PubsubClient.TopicPath topic, List<PubsubClient.OutgoingMessage> outgoingMessages) throws IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPublishMode(), (Object)"Can only publish in publish mode");
            Preconditions.checkState((boolean)topic.equals(PubsubTestClient.STATE.expectedTopic), (String)"Topic %s does not match expected %s", (Object)topic, (Object)PubsubTestClient.STATE.expectedTopic);
            for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
                if (PubsubTestClient.STATE.remainingFailingOutgoingMessages.remove(outgoingMessage)) {
                    throw new RuntimeException("Simulating failure for " + outgoingMessage);
                }
                Preconditions.checkState((boolean)PubsubTestClient.STATE.remainingExpectedOutgoingMessages.remove(outgoingMessage), (String)"Unexpected outgoing message %s", (Object)outgoingMessage);
            }
            return outgoingMessages.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PubsubClient.IncomingMessage> pull(long requestTimeMsSinceEpoch, PubsubClient.SubscriptionPath subscription, int batchSize, boolean returnImmediately) throws IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only pull in pull mode");
            long now = PubsubTestClient.STATE.clock.currentTimeMillis();
            Preconditions.checkState((requestTimeMsSinceEpoch == now ? 1 : 0) != 0, (String)"Simulated time %s does not match request time %s", (long)now, (long)requestTimeMsSinceEpoch);
            Preconditions.checkState((boolean)subscription.equals(PubsubTestClient.STATE.expectedSubscription), (String)"Subscription %s does not match expected %s", (Object)subscription, (Object)PubsubTestClient.STATE.expectedSubscription);
            Preconditions.checkState((boolean)returnImmediately, (Object)"Pull only supported if returning immediately");
            ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>();
            Iterator<PubsubClient.IncomingMessage> pendItr = PubsubTestClient.STATE.remainingPendingIncomingMessages.iterator();
            while (pendItr.hasNext()) {
                PubsubClient.IncomingMessage incomingMessage = pendItr.next();
                pendItr.remove();
                PubsubClient.IncomingMessage incomingMessageWithRequestTime = incomingMessage.withRequestTime(requestTimeMsSinceEpoch);
                incomingMessages.add(incomingMessageWithRequestTime);
                PubsubTestClient.STATE.pendingAckIncomingMessages.put(incomingMessageWithRequestTime.ackId, incomingMessageWithRequestTime);
                PubsubTestClient.STATE.ackDeadline.put(incomingMessageWithRequestTime.ackId, requestTimeMsSinceEpoch + (long)(PubsubTestClient.STATE.ackTimeoutSec * 1000));
                if (incomingMessages.size() < batchSize) continue;
                break;
            }
            return incomingMessages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(PubsubClient.SubscriptionPath subscription, List<String> ackIds) throws IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only acknowledge in pull mode");
            Preconditions.checkState((boolean)subscription.equals(PubsubTestClient.STATE.expectedSubscription), (String)"Subscription %s does not match expected %s", (Object)subscription, (Object)PubsubTestClient.STATE.expectedSubscription);
            for (String ackId : ackIds) {
                Preconditions.checkState((PubsubTestClient.STATE.ackDeadline.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                Preconditions.checkState((PubsubTestClient.STATE.pendingAckIncomingMessages.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyAckDeadline(PubsubClient.SubscriptionPath subscription, List<String> ackIds, int deadlineSeconds) throws IOException {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only modify ack deadline in pull mode");
            Preconditions.checkState((boolean)subscription.equals(PubsubTestClient.STATE.expectedSubscription), (String)"Subscription %s does not match expected %s", (Object)subscription, (Object)PubsubTestClient.STATE.expectedSubscription);
            for (String ackId : ackIds) {
                if (deadlineSeconds > 0) {
                    Preconditions.checkState((PubsubTestClient.STATE.ackDeadline.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                    Preconditions.checkState((boolean)PubsubTestClient.STATE.pendingAckIncomingMessages.containsKey(ackId), (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                    PubsubTestClient.STATE.ackDeadline.put(ackId, PubsubTestClient.STATE.clock.currentTimeMillis() + (long)(deadlineSeconds * 1000));
                    continue;
                }
                Preconditions.checkState((PubsubTestClient.STATE.ackDeadline.remove(ackId) != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                PubsubClient.IncomingMessage message = PubsubTestClient.STATE.pendingAckIncomingMessages.remove(ackId);
                Preconditions.checkState((message != null ? 1 : 0) != 0, (String)"No message with ACK id %s is waiting for an ACK", (Object)ackId);
                PubsubTestClient.STATE.remainingPendingIncomingMessages.add(message);
            }
        }
    }

    @Override
    public void createTopic(PubsubClient.TopicPath topic) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteTopic(PubsubClient.TopicPath topic) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PubsubClient.TopicPath> listTopics(PubsubClient.ProjectPath project) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSubscription(PubsubClient.TopicPath topic, PubsubClient.SubscriptionPath subscription, int ackDeadlineSeconds) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteSubscription(PubsubClient.SubscriptionPath subscription) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PubsubClient.SubscriptionPath> listSubscriptions(PubsubClient.ProjectPath project, PubsubClient.TopicPath topic) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ackDeadlineSeconds(PubsubClient.SubscriptionPath subscription) throws IOException {
        State state = STATE;
        synchronized (state) {
            return PubsubTestClient.STATE.ackTimeoutSec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEOF() {
        State state = STATE;
        synchronized (state) {
            Preconditions.checkState((boolean)this.inPullMode(), (Object)"Can only check EOF in pull mode");
            return PubsubTestClient.STATE.remainingPendingIncomingMessages.isEmpty();
        }
    }

    public static interface PubsubTestClientFactory
    extends PubsubClient.PubsubClientFactory,
    Closeable,
    Serializable {
    }

    private static class State {
        boolean isActive;
        @Nullable
        PubsubClient.TopicPath expectedTopic;
        @Nullable
        Set<PubsubClient.OutgoingMessage> remainingExpectedOutgoingMessages;
        @Nullable
        Set<PubsubClient.OutgoingMessage> remainingFailingOutgoingMessages;
        @Nullable
        Clock clock;
        @Nullable
        PubsubClient.SubscriptionPath expectedSubscription;
        int ackTimeoutSec;
        @Nullable
        List<PubsubClient.IncomingMessage> remainingPendingIncomingMessages;
        @Nullable
        Map<String, PubsubClient.IncomingMessage> pendingAckIncomingMessages;
        @Nullable
        Map<String, Long> ackDeadline;

        private State() {
        }
    }
}

