/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQueryHelper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class BigQueryQuerySource<T>
extends BigQuerySourceBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryQuerySource.class);
    private final ValueProvider<String> query;
    private final Boolean flattenResults;
    private final Boolean useLegacySql;
    private final BigQueryIO.TypedRead.QueryPriority priority;
    private final String location;
    private final String kmsKey;
    private transient AtomicReference<JobStatistics> dryRunJobStats;

    static <T> BigQueryQuerySource<T> create(String stepUuid, ValueProvider<String> query, Boolean flattenResults, Boolean useLegacySql, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn, BigQueryIO.TypedRead.QueryPriority priority, String location, String kmsKey) {
        return new BigQueryQuerySource<T>(stepUuid, query, flattenResults, useLegacySql, bqServices, coder, parseFn, priority, location, kmsKey);
    }

    private BigQueryQuerySource(String stepUuid, ValueProvider<String> query, Boolean flattenResults, Boolean useLegacySql, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn, BigQueryIO.TypedRead.QueryPriority priority, String location, String kmsKey) {
        super(stepUuid, bqServices, coder, parseFn);
        this.query = (ValueProvider)Preconditions.checkNotNull(query, (Object)"query");
        this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
        this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
        this.priority = priority;
        this.location = location;
        this.kmsKey = kmsKey;
        this.dryRunJobStats = new AtomicReference();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dryRunJobStats = new AtomicReference();
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, (BigQueryOptions)options.as(BigQueryOptions.class), this.dryRunJobStats, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.location).getQuery().getTotalBytesProcessed();
    }

    @Override
    protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException, InterruptedException {
        return BigQueryQueryHelper.executeQuery(this.bqServices, bqOptions, this.dryRunJobStats, this.stepUuid, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.priority, this.location, this.kmsKey);
    }

    @Override
    protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
        TableReference tableToRemove = BigQueryHelpers.createTempTableReference(bqOptions.getProject(), BigQueryHelpers.createJobIdToken(bqOptions.getJobName(), this.stepUuid));
        BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
        LOG.info("Deleting temporary table with query results {}", (Object)tableToRemove);
        tableService.deleteTable(tableToRemove);
        LOG.info("Deleting temporary dataset with query results {}", (Object)tableToRemove.getDatasetId());
        tableService.deleteDataset(tableToRemove.getProjectId(), tableToRemove.getDatasetId());
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"query", this.query));
    }
}

