/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
class TableRowInfoCoder
extends AtomicCoder<TableRowInfo> {
    private static final TableRowInfoCoder INSTANCE = new TableRowInfoCoder();
    TableRowJsonCoder tableRowCoder = TableRowJsonCoder.of();
    StringUtf8Coder idCoder = StringUtf8Coder.of();

    TableRowInfoCoder() {
    }

    public static TableRowInfoCoder of() {
        return INSTANCE;
    }

    public void encode(TableRowInfo value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(TableRowInfo value, OutputStream outStream, Coder.Context context) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null value");
        }
        this.tableRowCoder.encode(value.tableRow, outStream);
        this.idCoder.encode(value.uniqueId, outStream, context);
    }

    public TableRowInfo decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public TableRowInfo decode(InputStream inStream, Coder.Context context) throws IOException {
        return new TableRowInfo(this.tableRowCoder.decode(inStream), this.idCoder.decode(inStream, context));
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "TableRows are not deterministic.");
    }
}

