/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerConfig;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;

public abstract class SpannerConfig
implements Serializable {
    @Nullable
    abstract ValueProvider<String> getProjectId();

    @Nullable
    abstract ValueProvider<String> getInstanceId();

    @Nullable
    abstract ValueProvider<String> getDatabaseId();

    @Nullable
    @VisibleForTesting
    abstract ServiceFactory<Spanner, SpannerOptions> getServiceFactory();

    abstract Builder toBuilder();

    SpannerOptions buildSpannerOptions() {
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        if (this.getProjectId() != null) {
            builder.setProjectId((String)this.getProjectId().get());
        }
        if (this.getServiceFactory() != null) {
            builder.setServiceFactory(this.getServiceFactory());
        }
        return builder.build();
    }

    public static SpannerConfig create() {
        return SpannerConfig.builder().build();
    }

    static Builder builder() {
        return new AutoValue_SpannerConfig.Builder();
    }

    public void validate(PipelineOptions options) {
        Preconditions.checkNotNull(this.getInstanceId(), (Object)"SpannerIO.read() requires instance id to be set with withInstanceId method");
        Preconditions.checkNotNull(this.getDatabaseId(), (Object)"SpannerIO.read() requires database id to be set with withDatabaseId method");
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Output Project")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Output Instance")).addIfNotNull(DisplayData.item((String)"databaseId", this.getDatabaseId()).withLabel("Output Database"));
        if (this.getServiceFactory() != null) {
            builder.addIfNotNull(DisplayData.item((String)"serviceFactory", (String)this.getServiceFactory().getClass().getName()).withLabel("Service Factory"));
        }
    }

    public SpannerConfig withProjectId(ValueProvider<String> projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public SpannerConfig withProjectId(String projectId) {
        return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
    }

    public SpannerConfig withInstanceId(ValueProvider<String> instanceId) {
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    public SpannerConfig withInstanceId(String instanceId) {
        return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
    }

    public SpannerConfig withDatabaseId(ValueProvider<String> databaseId) {
        return this.toBuilder().setDatabaseId(databaseId).build();
    }

    public SpannerConfig withDatabaseId(String databaseId) {
        return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
    }

    @VisibleForTesting
    SpannerConfig withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
        return this.toBuilder().setServiceFactory(serviceFactory).build();
    }

    public static abstract class Builder {
        abstract Builder setProjectId(ValueProvider<String> var1);

        abstract Builder setInstanceId(ValueProvider<String> var1);

        abstract Builder setDatabaseId(ValueProvider<String> var1);

        abstract Builder setServiceFactory(ServiceFactory<Spanner, SpannerOptions> var1);

        public abstract SpannerConfig build();
    }
}

