/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdk.io.gcp.spanner.AbstractSpannerFn;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;

@VisibleForTesting
class NaiveSpannerReadFn
extends AbstractSpannerFn<Object, Struct> {
    private final SpannerIO.Read config;

    NaiveSpannerReadFn(SpannerIO.Read config) {
        this.config = config;
    }

    @Override
    SpannerConfig getSpannerConfig() {
        return this.config.getSpannerConfig();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        TimestampBound timestampBound = TimestampBound.strong();
        if (this.config.getTransaction() != null) {
            Transaction transaction = (Transaction)c.sideInput(this.config.getTransaction());
            timestampBound = TimestampBound.ofReadTimestamp((Timestamp)transaction.timestamp());
        }
        try (ReadOnlyTransaction readOnlyTransaction = this.databaseClient().readOnlyTransaction(timestampBound);){
            ResultSet resultSet = this.execute(readOnlyTransaction);
            while (resultSet.next()) {
                c.output((Object)resultSet.getCurrentRowAsStruct());
            }
        }
    }

    private ResultSet execute(ReadOnlyTransaction readOnlyTransaction) {
        if (this.config.getQuery() != null) {
            return readOnlyTransaction.executeQuery(this.config.getQuery(), new Options.QueryOption[0]);
        }
        if (this.config.getIndex() != null) {
            return readOnlyTransaction.readUsingIndex(this.config.getTable(), this.config.getIndex(), this.config.getKeySet(), this.config.getColumns(), new Options.ReadOption[0]);
        }
        return readOnlyTransaction.read(this.config.getTable(), this.config.getKeySet(), this.config.getColumns(), new Options.ReadOption[0]);
    }
}

