/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CalculateSchemas;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKey;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKeyCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WriteGroupedRecordsToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WritePartition;
import org.apache.beam.sdk.io.gcp.bigquery.WriteRename;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchLoads<DestinationT>
extends PTransform<PCollection<KV<DestinationT, TableRow>>, WriteResult> {
    static final Logger LOG = LoggerFactory.getLogger(BatchLoads.class);
    @VisibleForTesting
    static final int DEFAULT_MAX_NUM_WRITERS_PER_BUNDLE = 20;
    @VisibleForTesting
    static final int MAX_NUM_FILES = 10000;
    @VisibleForTesting
    static final long MAX_SIZE_BYTES = 0xB0000000000L;
    static final long DEFAULT_MAX_FILE_SIZE = 0x40000000000L;
    static final int LOAD_JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    static final int MAX_RETRY_JOBS = 3;
    private BigQueryServices bigQueryServices = new BigQueryServicesImpl();
    private final BigQueryIO.Write.WriteDisposition writeDisposition;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final boolean singletonTable;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final Coder<DestinationT> destinationCoder;
    private int maxNumWritersPerBundle;
    private long maxFileSize;

    BatchLoads(BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, boolean singletonTable, DynamicDestinations<?, DestinationT> dynamicDestinations, Coder<DestinationT> destinationCoder) {
        this.writeDisposition = writeDisposition;
        this.createDisposition = createDisposition;
        this.singletonTable = singletonTable;
        this.dynamicDestinations = dynamicDestinations;
        this.destinationCoder = destinationCoder;
        this.maxNumWritersPerBundle = 20;
        this.maxFileSize = 0x40000000000L;
    }

    void setTestServices(BigQueryServices bigQueryServices) {
        this.bigQueryServices = bigQueryServices;
    }

    public int getMaxNumWritersPerBundle() {
        return this.maxNumWritersPerBundle;
    }

    public void setMaxNumWritersPerBundle(int maxNumWritersPerBundle) {
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
    }

    @VisibleForTesting
    void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void validate(PipelineOptions options) {
        String tempLocation = options.getTempLocation();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Write needs a GCS temp location to store temp files.");
        if (this.bigQueryServices == null) {
            try {
                GcsPath.fromUri((String)tempLocation);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
            }
        }
    }

    public WriteResult expand(PCollection<KV<DestinationT, TableRow>> input) {
        Pipeline p = input.getPipeline();
        PCollection jobIdToken = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

            public String apply(String input) {
                return BigQueryHelpers.randomUUIDString();
            }
        }));
        PCollectionView jobIdTokenView = (PCollectionView)jobIdToken.apply((PTransform)View.asSingleton());
        PCollectionView tempFilePrefix = (PCollectionView)((PCollection)jobIdToken.apply("GetTempFilePrefix", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void getTempFilePrefix(DoFn.ProcessContext c) {
                String tempLocation = BigQueryHelpers.resolveTempLocation(c.getPipelineOptions().getTempLocation(), "BigQueryWriteTemp", (String)c.element());
                LOG.info("Writing BigQuery temporary files to {} before loading them.", (Object)tempLocation);
                c.output((Object)tempLocation);
            }
        }))).apply("TempFilePrefixView", (PTransform)View.asSingleton());
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes());
        PCollectionView schemasView = (PCollectionView)inputInGlobalWindow.apply(new CalculateSchemas<DestinationT>(this.dynamicDestinations));
        TupleTag writtenFilesTag = new TupleTag<WriteBundlesToFiles.Result<DestinationT>>("writtenFiles"){};
        TupleTag unwrittedRecordsTag = new TupleTag<KV<ShardedKey<DestinationT>, TableRow>>("unwrittenRecords"){};
        PCollectionTuple writeBundlesTuple = (PCollectionTuple)inputInGlobalWindow.apply("WriteBundlesToFiles", (PTransform)ParDo.of(new WriteBundlesToFiles((PCollectionView<String>)tempFilePrefix, unwrittedRecordsTag, this.maxNumWritersPerBundle, this.maxFileSize)).withSideInputs(new PCollectionView[]{tempFilePrefix}).withOutputTags(writtenFilesTag, TupleTagList.of((TupleTag)unwrittedRecordsTag)));
        PCollection writtenFiles = writeBundlesTuple.get(writtenFilesTag).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
        PCollection writtenFilesGrouped = ((PCollection)((PCollection)writeBundlesTuple.get(unwrittedRecordsTag).setCoder((Coder)KvCoder.of(ShardedKeyCoder.of(this.destinationCoder), (Coder)TableRowJsonCoder.of())).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of(new WriteGroupedRecordsToFiles((PCollectionView<String>)tempFilePrefix, this.maxFileSize)).withSideInputs(new PCollectionView[]{tempFilePrefix}))).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
        PCollection results = (PCollection)PCollectionList.of((PCollection)writtenFiles).and(writtenFilesGrouped).apply((PTransform)Flatten.pCollections());
        TupleTag multiPartitionsTag = new TupleTag<KV<ShardedKey<DestinationT>, List<String>>>("multiPartitionsTag"){};
        TupleTag singlePartitionTag = new TupleTag<KV<ShardedKey<DestinationT>, List<String>>>("singlePartitionTag"){};
        PCollectionView resultsView = (PCollectionView)results.apply("ResultsView", (PTransform)View.asIterable());
        PCollection singleton = (PCollection)p.apply("singleton", (PTransform)Create.of((Object)null, (Object[])new Void[0]).withCoder((Coder)VoidCoder.of()));
        PCollectionTuple partitions = (PCollectionTuple)singleton.apply("WritePartition", (PTransform)ParDo.of(new WritePartition<DestinationT>(this.singletonTable, this.dynamicDestinations, (PCollectionView<String>)tempFilePrefix, resultsView, multiPartitionsTag, singlePartitionTag)).withSideInputs(new PCollectionView[]{tempFilePrefix, resultsView}).withOutputTags(multiPartitionsTag, TupleTagList.of((TupleTag)singlePartitionTag)));
        ArrayList writeTablesSideInputs = Lists.newArrayList((Object[])new PCollectionView[]{jobIdTokenView, schemasView});
        writeTablesSideInputs.addAll(this.dynamicDestinations.getSideInputs());
        KvCoder partitionsCoder = KvCoder.of(ShardedKeyCoder.of(NullableCoder.of(this.destinationCoder)), (Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        PCollection tempTables = (PCollection)((PCollection)partitions.get(multiPartitionsTag).setCoder((Coder)partitionsCoder).apply("MultiPartitionsReshuffle", (PTransform)Reshuffle.of())).apply("MultiPartitionsWriteTables", (PTransform)ParDo.of(new WriteTables<DestinationT>(false, this.bigQueryServices, (PCollectionView<String>)jobIdTokenView, schemasView, BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED, this.dynamicDestinations)).withSideInputs((Iterable)writeTablesSideInputs));
        PCollectionView tempTablesView = (PCollectionView)tempTables.apply("TempTablesView", (PTransform)View.asMultimap());
        singleton.apply("WriteRename", (PTransform)ParDo.of((DoFn)new WriteRename(this.bigQueryServices, (PCollectionView<String>)jobIdTokenView, this.writeDisposition, this.createDisposition, (PCollectionView<Map<TableDestination, Iterable<String>>>)tempTablesView)).withSideInputs(new PCollectionView[]{tempTablesView, jobIdTokenView}));
        ((PCollection)partitions.get(singlePartitionTag).setCoder((Coder)partitionsCoder).apply("SinglePartitionsReshuffle", (PTransform)Reshuffle.of())).apply("SinglePartitionWriteTables", (PTransform)ParDo.of(new WriteTables<DestinationT>(true, this.bigQueryServices, (PCollectionView<String>)jobIdTokenView, schemasView, this.writeDisposition, this.createDisposition, this.dynamicDestinations)).withSideInputs((Iterable)writeTablesSideInputs));
        PCollection empty = (PCollection)p.apply("CreateEmptyFailedInserts", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(TableRow.class)));
        return WriteResult.in(input.getPipeline(), (TupleTag<TableRow>)new TupleTag("failedInserts"), (PCollection<TableRow>)empty);
    }
}

