/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.storage;

import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.storage.GcsResourceId;
import org.apache.beam.sdk.options.GcsOptions;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GcsFileSystem
extends FileSystem<GcsResourceId> {
    private static final Logger LOG = LoggerFactory.getLogger(GcsFileSystem.class);
    private final GcsOptions options;

    GcsFileSystem(GcsOptions options) {
        this.options = (GcsOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
    }

    protected List<MatchResult> match(List<String> specs) throws IOException {
        List<GcsPath> gcsPaths = this.toGcsPaths(specs);
        ArrayList globs = Lists.newArrayList();
        ArrayList nonGlobs = Lists.newArrayList();
        ArrayList isGlobBooleans = Lists.newArrayList();
        for (int i = 0; i < gcsPaths.size(); ++i) {
            GcsPath path = gcsPaths.get(i);
            if (GcsUtil.isGlob((GcsPath)path)) {
                globs.add(path);
                isGlobBooleans.add(true);
                continue;
            }
            nonGlobs.add(path);
            isGlobBooleans.add(false);
        }
        Iterator<MatchResult> globsMatchResults = this.matchGlobs(globs).iterator();
        Iterator<MatchResult> nonGlobsMatchResults = this.matchNonGlobs(nonGlobs).iterator();
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Boolean isGlob : isGlobBooleans) {
            if (isGlob.booleanValue()) {
                Preconditions.checkState((boolean)globsMatchResults.hasNext(), (Object)"Expect globsMatchResults has next.");
                ret.add((Object)globsMatchResults.next());
                continue;
            }
            Preconditions.checkState((boolean)nonGlobsMatchResults.hasNext(), (Object)"Expect nonGlobsMatchResults has next.");
            ret.add((Object)nonGlobsMatchResults.next());
        }
        Preconditions.checkState((!globsMatchResults.hasNext() ? 1 : 0) != 0, (Object)"Expect no more elements in globsMatchResults.");
        Preconditions.checkState((!nonGlobsMatchResults.hasNext() ? 1 : 0) != 0, (Object)"Expect no more elements in nonGlobsMatchResults.");
        return ret.build();
    }

    protected WritableByteChannel create(GcsResourceId resourceId, CreateOptions createOptions) throws IOException {
        return this.options.getGcsUtil().create(resourceId.getGcsPath(), createOptions.mimeType());
    }

    protected ReadableByteChannel open(GcsResourceId resourceId) throws IOException {
        return this.options.getGcsUtil().open(resourceId.getGcsPath());
    }

    protected void rename(List<GcsResourceId> srcResourceIds, List<GcsResourceId> destResourceIds) throws IOException {
        this.copy(srcResourceIds, destResourceIds);
        this.delete(srcResourceIds);
    }

    protected void delete(Collection<GcsResourceId> resourceIds) throws IOException {
        this.options.getGcsUtil().remove(this.toFilenames(resourceIds));
    }

    protected void copy(List<GcsResourceId> srcResourceIds, List<GcsResourceId> destResourceIds) throws IOException {
        this.options.getGcsUtil().copy(this.toFilenames(srcResourceIds), this.toFilenames(destResourceIds));
    }

    private List<MatchResult> matchGlobs(List<GcsPath> globs) {
        return FluentIterable.from(globs).transform((Function)new Function<GcsPath, MatchResult>(){

            public MatchResult apply(GcsPath gcsPath) {
                try {
                    return GcsFileSystem.this.expand(gcsPath);
                }
                catch (IOException e) {
                    return MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)e);
                }
            }
        }).toList();
    }

    @VisibleForTesting
    MatchResult expand(GcsPath gcsPattern) throws IOException {
        Objects objects;
        String prefix = GcsUtil.getGlobPrefix((String)gcsPattern.getObject());
        Pattern p = Pattern.compile(GcsUtil.globToRegexp((String)gcsPattern.getObject()));
        LOG.debug("matching files in bucket {}, prefix {} against pattern {}", new Object[]{gcsPattern.getBucket(), prefix, p.toString()});
        String pageToken = null;
        LinkedList<MatchResult.Metadata> results = new LinkedList<MatchResult.Metadata>();
        while ((objects = this.options.getGcsUtil().listObjects(gcsPattern.getBucket(), prefix, pageToken)).getItems() != null) {
            for (StorageObject o : objects.getItems()) {
                String name = o.getName();
                if (!p.matcher(name).matches() || name.endsWith("/")) continue;
                LOG.debug("Matched object: {}", (Object)name);
                results.add(this.toMetadata(o));
            }
            pageToken = objects.getNextPageToken();
            if (pageToken != null) continue;
        }
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, (MatchResult.Metadata[])results.toArray(new MatchResult.Metadata[results.size()]));
    }

    @VisibleForTesting
    List<MatchResult> matchNonGlobs(List<GcsPath> gcsPaths) throws IOException {
        List results = this.options.getGcsUtil().getObjects(gcsPaths);
        ImmutableList.Builder ret = ImmutableList.builder();
        for (GcsUtil.StorageObjectOrIOException result : results) {
            ret.add((Object)this.toMatchResult(result));
        }
        return ret.build();
    }

    private MatchResult toMatchResult(GcsUtil.StorageObjectOrIOException objectOrException) {
        if (objectOrException.ioException() instanceof FileNotFoundException) {
            return MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, (IOException)objectOrException.ioException());
        }
        if (objectOrException.ioException() != null) {
            return MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)objectOrException.ioException());
        }
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, (MatchResult.Metadata[])new MatchResult.Metadata[]{this.toMetadata(objectOrException.storageObject())});
    }

    private MatchResult.Metadata toMetadata(StorageObject storageObject) {
        MatchResult.Metadata.Builder ret = MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)GcsResourceId.fromGcsPath(GcsPath.fromObject((StorageObject)storageObject)));
        BigInteger size = storageObject.getSize();
        if (size != null) {
            ret.setSizeBytes(size.longValue());
        }
        return ret.build();
    }

    private List<String> toFilenames(Collection<GcsResourceId> resources) {
        return FluentIterable.from(resources).transform((Function)new Function<GcsResourceId, String>(){

            public String apply(GcsResourceId resource) {
                return resource.getGcsPath().toString();
            }
        }).toList();
    }

    private List<GcsPath> toGcsPaths(Collection<String> specs) {
        return FluentIterable.from(specs).transform((Function)new Function<String, GcsPath>(){

            public GcsPath apply(String spec) {
                return GcsPath.fromUri((String)spec);
            }
        }).toList();
    }
}

