/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.datastore.v1beta3.CommitRequest;
import com.google.datastore.v1beta3.Entity;
import com.google.datastore.v1beta3.EntityResult;
import com.google.datastore.v1beta3.Filter;
import com.google.datastore.v1beta3.Key;
import com.google.datastore.v1beta3.PartitionId;
import com.google.datastore.v1beta3.PropertyFilter;
import com.google.datastore.v1beta3.PropertyOrder;
import com.google.datastore.v1beta3.Query;
import com.google.datastore.v1beta3.QueryResultBatch;
import com.google.datastore.v1beta3.RunQueryRequest;
import com.google.datastore.v1beta3.RunQueryResponse;
import com.google.datastore.v1beta3.Value;
import com.google.datastore.v1beta3.client.Datastore;
import com.google.datastore.v1beta3.client.DatastoreException;
import com.google.datastore.v1beta3.client.DatastoreFactory;
import com.google.datastore.v1beta3.client.DatastoreHelper;
import com.google.datastore.v1beta3.client.DatastoreOptions;
import com.google.datastore.v1beta3.client.QuerySplitter;
import com.google.protobuf.Int32Value;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Sink;
import org.apache.beam.sdk.options.GcpOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.AttemptBoundedExponentialBackOff;
import org.apache.beam.sdk.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class V1Beta3 {
    private static final int DATASTORE_BATCH_UPDATE_LIMIT = 500;

    V1Beta3() {
    }

    public Read read() {
        return new Read(null, null, null);
    }

    public Write write() {
        return new Write(null);
    }

    private static class DatastoreWriteResult
    implements Serializable {
        final long entitiesWritten;

        public DatastoreWriteResult(long recordsWritten) {
            this.entitiesWritten = recordsWritten;
        }
    }

    @VisibleForTesting
    static class DatastoreWriter
    extends Sink.Writer<Entity, DatastoreWriteResult> {
        private static final Logger LOG = LoggerFactory.getLogger(DatastoreWriter.class);
        private final DatastoreWriteOperation writeOp;
        private final Datastore datastore;
        private long totalWritten = 0L;
        final List<Entity> entities = new ArrayList<Entity>();
        private static final int MAX_RETRIES = 5;
        private static final int INITIAL_BACKOFF_MILLIS = 5000;

        static boolean isValidKey(Key key) {
            List elementList = key.getPathList();
            if (elementList.isEmpty()) {
                return false;
            }
            Key.PathElement lastElement = (Key.PathElement)elementList.get(elementList.size() - 1);
            return lastElement.getId() != 0L || !lastElement.getName().isEmpty();
        }

        DatastoreWriter(DatastoreWriteOperation writeOp, Datastore datastore) {
            this.writeOp = writeOp;
            this.datastore = datastore;
        }

        public void open(String uId) throws Exception {
        }

        public void write(Entity value) throws Exception {
            if (!DatastoreWriter.isValidKey(value.getKey())) {
                throw new IllegalArgumentException("Entities to be written to the Datastore must have complete keys");
            }
            this.entities.add(value);
            if (this.entities.size() >= 500) {
                this.flushBatch();
            }
        }

        public DatastoreWriteResult close() throws Exception {
            if (this.entities.size() > 0) {
                this.flushBatch();
            }
            return new DatastoreWriteResult(this.totalWritten);
        }

        public DatastoreWriteOperation getWriteOperation() {
            return this.writeOp;
        }

        private void flushBatch() throws DatastoreException, IOException, InterruptedException {
            LOG.debug("Writing batch of {} entities", (Object)this.entities.size());
            Sleeper sleeper = Sleeper.DEFAULT;
            AttemptBoundedExponentialBackOff backoff = new AttemptBoundedExponentialBackOff(5, 5000L);
            while (true) {
                try {
                    CommitRequest.Builder commitRequest = CommitRequest.newBuilder();
                    for (Entity entity : this.entities) {
                        commitRequest.addMutations(DatastoreHelper.makeUpsert((Entity)entity));
                    }
                    commitRequest.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                    this.datastore.commit(commitRequest.build());
                }
                catch (DatastoreException exception) {
                    LOG.error("Error writing to the Datastore ({}): {}", (Object)exception.getCode(), (Object)exception.getMessage());
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                    LOG.error("Aborting after {} retries.", (Object)5);
                    throw exception;
                }
                break;
            }
            this.totalWritten += (long)this.entities.size();
            LOG.debug("Successfully wrote {} entities", (Object)this.entities.size());
            this.entities.clear();
        }
    }

    private static class DatastoreWriteOperation
    extends Sink.WriteOperation<Entity, DatastoreWriteResult> {
        private static final Logger LOG = LoggerFactory.getLogger(DatastoreWriteOperation.class);
        private final DatastoreSink sink;

        public DatastoreWriteOperation(DatastoreSink sink) {
            this.sink = sink;
        }

        public Coder<DatastoreWriteResult> getWriterResultCoder() {
            return SerializableCoder.of(DatastoreWriteResult.class);
        }

        public void initialize(PipelineOptions options) throws Exception {
        }

        public void finalize(Iterable<DatastoreWriteResult> writerResults, PipelineOptions options) throws Exception {
            long totalEntities = 0L;
            for (DatastoreWriteResult result : writerResults) {
                totalEntities += result.entitiesWritten;
            }
            LOG.info("Wrote {} elements.", (Object)totalEntities);
        }

        public DatastoreWriter createWriter(PipelineOptions options) throws Exception {
            DatastoreOptions.Builder builder = new DatastoreOptions.Builder().projectId(this.sink.projectId).initializer((HttpRequestInitializer)new RetryHttpRequestInitializer());
            Credential credential = ((GcpOptions)options.as(GcpOptions.class)).getGcpCredential();
            if (credential != null) {
                builder.credential(credential);
            }
            Datastore datastore = DatastoreFactory.get().create(builder.build());
            return new DatastoreWriter(this, datastore);
        }

        public DatastoreSink getSink() {
            return this.sink;
        }
    }

    static class DatastoreSink
    extends Sink<Entity> {
        final String projectId;

        public DatastoreSink(String projectId) {
            this.projectId = projectId;
        }

        public void validate(PipelineOptions options) {
            Preconditions.checkNotNull((Object)this.projectId, (Object)"projectId");
        }

        public DatastoreWriteOperation createWriteOperation(PipelineOptions options) {
            return new DatastoreWriteOperation(this);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"projectId", (String)this.projectId).withLabel("Output Project"));
        }
    }

    @VisibleForTesting
    static class DatastoreReader
    extends BoundedSource.BoundedReader<Entity> {
        private final DatastoreSource source;
        private final Datastore datastore;
        private boolean moreResults;
        private Iterator<EntityResult> entities;
        private QueryResultBatch currentBatch;
        private static final int QUERY_BATCH_LIMIT = 500;
        private int userLimit;
        private volatile boolean done = false;
        private Entity currentEntity;

        public DatastoreReader(DatastoreSource source, Datastore datastore) {
            this.source = source;
            this.datastore = datastore;
            this.userLimit = source.query.hasLimit() ? source.query.getLimit().getValue() : Integer.MAX_VALUE;
        }

        public Entity getCurrent() {
            return this.currentEntity;
        }

        public final long getSplitPointsConsumed() {
            return this.done ? 1L : 0L;
        }

        public final long getSplitPointsRemaining() {
            return this.done ? 0L : 1L;
        }

        public boolean start() throws IOException {
            return this.advance();
        }

        public boolean advance() throws IOException {
            if (this.entities == null || !this.entities.hasNext() && this.moreResults) {
                try {
                    this.entities = this.getIteratorAndMoveCursor();
                }
                catch (DatastoreException e) {
                    throw new IOException(e);
                }
            }
            if (this.entities == null || !this.entities.hasNext()) {
                this.currentEntity = null;
                this.done = true;
                return false;
            }
            this.currentEntity = this.entities.next().getEntity();
            return true;
        }

        public void close() throws IOException {
        }

        public DatastoreSource getCurrentSource() {
            return this.source;
        }

        public DatastoreSource splitAtFraction(double fraction) {
            return null;
        }

        public Double getFractionConsumed() {
            return null;
        }

        private Iterator<EntityResult> getIteratorAndMoveCursor() throws DatastoreException {
            Query.Builder query = (Query.Builder)this.source.query.toBuilder().clone();
            query.setLimit(Int32Value.newBuilder().setValue(Math.min(this.userLimit, 500)));
            if (this.currentBatch != null && !this.currentBatch.getEndCursor().isEmpty()) {
                query.setStartCursor(this.currentBatch.getEndCursor());
            }
            RunQueryRequest request = this.source.makeRequest(query.build());
            RunQueryResponse response = this.datastore.runQuery(request);
            this.currentBatch = response.getBatch();
            int numFetch = this.currentBatch.getEntityResultsCount();
            if (this.source.query.hasLimit()) {
                Verify.verify((this.userLimit >= numFetch ? 1 : 0) != 0, (String)"Expected userLimit %s >= numFetch %s, because query limit %s should be <= userLimit", (Object[])new Object[]{this.userLimit, numFetch, query.getLimit()});
                this.userLimit -= numFetch;
            }
            boolean bl = this.moreResults = this.userLimit > 0 && (numFetch == 500 || this.currentBatch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
            if (numFetch == 0) {
                return null;
            }
            return this.currentBatch.getEntityResultsList().iterator();
        }
    }

    static class DatastoreSource
    extends BoundedSource<Entity> {
        private static final Logger LOG = LoggerFactory.getLogger(DatastoreSource.class);
        private final String projectId;
        private final Query query;
        @Nullable
        private final String namespace;
        @Nullable
        private QuerySplitter mockSplitter;
        @Nullable
        private Long mockEstimateSizeBytes;

        public Coder<Entity> getDefaultOutputCoder() {
            return ProtoCoder.of(Entity.class);
        }

        public boolean producesSortedKeys(PipelineOptions options) {
            return false;
        }

        public List<DatastoreSource> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            List<Query> datastoreSplits;
            long numSplits;
            if (this.query.hasLimit()) {
                return ImmutableList.of((Object)((Object)this));
            }
            try {
                numSplits = Math.round((double)this.getEstimatedSizeBytes(options) / (double)desiredBundleSizeBytes);
            }
            catch (Exception e) {
                numSplits = 12L;
            }
            if (numSplits <= 1L) {
                return ImmutableList.of((Object)((Object)this));
            }
            try {
                datastoreSplits = this.getSplitQueries(Ints.checkedCast((long)numSplits), options);
            }
            catch (DatastoreException | IllegalArgumentException e) {
                LOG.warn("Unable to parallelize the given query: {}", (Object)this.query, (Object)e);
                return ImmutableList.of((Object)((Object)this));
            }
            ImmutableList.Builder splits = ImmutableList.builder();
            for (Query splitQuery : datastoreSplits) {
                splits.add((Object)new DatastoreSource(this.projectId, splitQuery, this.namespace));
            }
            return splits.build();
        }

        public BoundedSource.BoundedReader<Entity> createReader(PipelineOptions pipelineOptions) throws IOException {
            return new DatastoreReader(this, this.getDatastore(pipelineOptions));
        }

        public void validate() {
            Preconditions.checkNotNull((Object)this.query, (Object)"query");
            Preconditions.checkNotNull((Object)this.projectId, (Object)"projectId");
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            if (this.mockEstimateSizeBytes != null) {
                return this.mockEstimateSizeBytes;
            }
            Datastore datastore = this.getDatastore(options);
            if (this.query.getKindCount() != 1) {
                throw new UnsupportedOperationException("Can only estimate size for queries specifying exactly 1 kind.");
            }
            String ourKind = this.query.getKind(0).getName();
            long latestTimestamp = this.queryLatestStatisticsTimestamp(datastore);
            Query.Builder query = Query.newBuilder();
            if (this.namespace == null) {
                query.addKindBuilder().setName("__Stat_Kind__");
            } else {
                query.addKindBuilder().setName("__Ns_Stat_Kind__");
            }
            query.setFilter(DatastoreHelper.makeAndFilter((Filter[])new Filter[]{DatastoreHelper.makeFilter((String)"kind_name", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value.Builder)DatastoreHelper.makeValue((String)ourKind)).build(), DatastoreHelper.makeFilter((String)"timestamp", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value.Builder)DatastoreHelper.makeValue((long)latestTimestamp)).build()}));
            RunQueryRequest request = this.makeRequest(query.build());
            long now = System.currentTimeMillis();
            RunQueryResponse response = datastore.runQuery(request);
            LOG.info("Query for per-kind statistics took {}ms", (Object)(System.currentTimeMillis() - now));
            QueryResultBatch batch = response.getBatch();
            if (batch.getEntityResultsCount() == 0) {
                throw new NoSuchElementException("Datastore statistics for kind " + ourKind + " unavailable");
            }
            Entity entity = batch.getEntityResults(0).getEntity();
            return ((Value)entity.getProperties().get("entity_bytes")).getIntegerValue();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"projectId", (String)this.projectId).withLabel("ProjectId")).addIfNotNull(DisplayData.item((String)"namespace", (String)this.namespace).withLabel("Namespace")).addIfNotNull(DisplayData.item((String)"query", (String)this.query.toString()).withLabel("Query"));
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("projectId", (Object)this.projectId).add("query", (Object)this.query).add("namespace", (Object)this.namespace).toString();
        }

        DatastoreSource(String projectId, Query query, @Nullable String namespace) {
            this.projectId = projectId;
            this.query = query;
            this.namespace = namespace;
        }

        private List<Query> getSplitQueries(int numSplits, PipelineOptions options) throws DatastoreException {
            PartitionId.Builder partitionBuilder = PartitionId.newBuilder();
            if (this.namespace != null) {
                partitionBuilder.setNamespaceId(this.namespace);
            }
            if (this.mockSplitter != null) {
                return this.mockSplitter.getSplits(this.query, partitionBuilder.build(), numSplits, null);
            }
            return DatastoreHelper.getQuerySplitter().getSplits(this.query, partitionBuilder.build(), numSplits, this.getDatastore(options));
        }

        private RunQueryRequest makeRequest(Query query) {
            RunQueryRequest.Builder requestBuilder = RunQueryRequest.newBuilder().setQuery(query);
            if (this.namespace != null) {
                requestBuilder.getPartitionIdBuilder().setNamespaceId(this.namespace);
            }
            return requestBuilder.build();
        }

        private long queryLatestStatisticsTimestamp(Datastore datastore) throws DatastoreException {
            Query.Builder query = Query.newBuilder();
            query.addKindBuilder().setName("__Stat_Total__");
            query.addOrder(DatastoreHelper.makeOrder((String)"timestamp", (PropertyOrder.Direction)PropertyOrder.Direction.DESCENDING));
            query.setLimit(Int32Value.newBuilder().setValue(1));
            RunQueryRequest request = this.makeRequest(query.build());
            long now = System.currentTimeMillis();
            RunQueryResponse response = datastore.runQuery(request);
            LOG.info("Query for latest stats timestamp of project {} took {}ms", (Object)this.projectId, (Object)(System.currentTimeMillis() - now));
            QueryResultBatch batch = response.getBatch();
            if (batch.getEntityResultsCount() == 0) {
                throw new NoSuchElementException("Datastore total statistics for project " + this.projectId + " unavailable");
            }
            Entity entity = batch.getEntityResults(0).getEntity();
            return ((Value)entity.getProperties().get("timestamp")).getTimestampValue().getNanos();
        }

        private Datastore getDatastore(PipelineOptions pipelineOptions) {
            DatastoreOptions.Builder builder = new DatastoreOptions.Builder().projectId(this.projectId).initializer((HttpRequestInitializer)new RetryHttpRequestInitializer());
            Credential credential = ((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential();
            if (credential != null) {
                builder.credential(credential);
            }
            return DatastoreFactory.get().create(builder.build());
        }

        DatastoreSource withMockSplitter(QuerySplitter splitter) {
            DatastoreSource res = new DatastoreSource(this.projectId, this.query, this.namespace);
            res.mockSplitter = splitter;
            res.mockEstimateSizeBytes = this.mockEstimateSizeBytes;
            return res;
        }

        DatastoreSource withMockEstimateSizeBytes(Long estimateSizeBytes) {
            DatastoreSource res = new DatastoreSource(this.projectId, this.query, this.namespace);
            res.mockSplitter = this.mockSplitter;
            res.mockEstimateSizeBytes = estimateSizeBytes;
            return res;
        }

        @VisibleForTesting
        Query getQuery() {
            return this.query;
        }
    }

    public static class Write
    extends PTransform<PCollection<Entity>, PDone> {
        @Nullable
        private final String projectId;

        public Write(@Nullable String projectId) {
            this.projectId = projectId;
        }

        public Write withProjectId(String projectId) {
            Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
            return new Write(projectId);
        }

        public PDone apply(PCollection<Entity> input) {
            return (PDone)input.apply((PTransform)org.apache.beam.sdk.io.Write.to((Sink)new DatastoreSink(this.projectId)));
        }

        public void validate(PCollection<Entity> input) {
            Preconditions.checkNotNull((Object)this.projectId, (Object)"projectId");
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("projectId", (Object)this.projectId).toString();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"projectId", (String)this.projectId).withLabel("Output Project"));
        }
    }

    public static class Read
    extends PTransform<PBegin, PCollection<Entity>> {
        @Nullable
        private final String projectId;
        @Nullable
        private final Query query;
        @Nullable
        private final String namespace;

        private Read(@Nullable String projectId, @Nullable Query query, @Nullable String namespace) {
            this.projectId = projectId;
            this.query = query;
            this.namespace = namespace;
        }

        public Read withProjectId(String projectId) {
            Preconditions.checkNotNull((Object)projectId, (Object)"projectId");
            return new Read(projectId, this.query, this.namespace);
        }

        public Read withQuery(Query query) {
            Preconditions.checkNotNull((Object)query, (Object)"query");
            Preconditions.checkArgument((!query.hasLimit() || query.getLimit().getValue() > 0 ? 1 : 0) != 0, (String)"Invalid query limit %s: must be positive", (Object[])new Object[]{query.getLimit().getValue()});
            return new Read(this.projectId, query, this.namespace);
        }

        public Read withNamespace(String namespace) {
            return new Read(this.projectId, this.query, namespace);
        }

        @Nullable
        public Query getQuery() {
            return this.query;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        @Nullable
        public String getNamespace() {
            return this.namespace;
        }

        public PCollection<Entity> apply(PBegin input) {
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)this.getSource()));
        }

        public void validate(PBegin input) {
            Preconditions.checkNotNull((Object)this.projectId, (Object)"projectId");
            Preconditions.checkNotNull((Object)this.query, (Object)"query");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"projectId", (String)this.projectId).withLabel("ProjectId")).addIfNotNull(DisplayData.item((String)"namespace", (String)this.namespace).withLabel("Namespace")).addIfNotNull(DisplayData.item((String)"query", (String)this.query.toString()).withLabel("Query"));
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("projectId", (Object)this.projectId).add("query", (Object)this.query).add("namespace", (Object)this.namespace).toString();
        }

        @VisibleForTesting
        DatastoreSource getSource() {
            return new DatastoreSource(this.projectId, this.query, this.namespace);
        }
    }
}

