/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.util.List;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_ElasticsearchIO_ConnectionConfiguration
extends ElasticsearchIO.ConnectionConfiguration {
    private final List<String> addresses;
    private final @Nullable String username;
    private final @Nullable String password;
    private final @Nullable String apiKey;
    private final @Nullable String bearerToken;
    private final @Nullable String keystorePath;
    private final @Nullable String keystorePassword;
    private final String index;
    private final String type;
    private final @Nullable Integer socketTimeout;
    private final @Nullable Integer connectTimeout;
    private final boolean trustSelfSignedCerts;

    private AutoValue_ElasticsearchIO_ConnectionConfiguration(List<String> addresses, @Nullable String username, @Nullable String password, @Nullable String apiKey, @Nullable String bearerToken, @Nullable String keystorePath, @Nullable String keystorePassword, String index, String type, @Nullable Integer socketTimeout, @Nullable Integer connectTimeout, boolean trustSelfSignedCerts) {
        this.addresses = addresses;
        this.username = username;
        this.password = password;
        this.apiKey = apiKey;
        this.bearerToken = bearerToken;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.index = index;
        this.type = type;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
        this.trustSelfSignedCerts = trustSelfSignedCerts;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public @Nullable String getUsername() {
        return this.username;
    }

    @Override
    public @Nullable String getPassword() {
        return this.password;
    }

    @Override
    public @Nullable String getApiKey() {
        return this.apiKey;
    }

    @Override
    public @Nullable String getBearerToken() {
        return this.bearerToken;
    }

    @Override
    public @Nullable String getKeystorePath() {
        return this.keystorePath;
    }

    @Override
    public @Nullable String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public String getIndex() {
        return this.index;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public @Nullable Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public @Nullable Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public boolean isTrustSelfSignedCerts() {
        return this.trustSelfSignedCerts;
    }

    public String toString() {
        return "ConnectionConfiguration{addresses=" + this.addresses + ", username=" + this.username + ", password=" + this.password + ", apiKey=" + this.apiKey + ", bearerToken=" + this.bearerToken + ", keystorePath=" + this.keystorePath + ", keystorePassword=" + this.keystorePassword + ", index=" + this.index + ", type=" + this.type + ", socketTimeout=" + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + ", trustSelfSignedCerts=" + this.trustSelfSignedCerts + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.ConnectionConfiguration) {
            ElasticsearchIO.ConnectionConfiguration that = (ElasticsearchIO.ConnectionConfiguration)o;
            return this.addresses.equals(that.getAddresses()) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && (this.apiKey == null ? that.getApiKey() == null : this.apiKey.equals(that.getApiKey())) && (this.bearerToken == null ? that.getBearerToken() == null : this.bearerToken.equals(that.getBearerToken())) && (this.keystorePath == null ? that.getKeystorePath() == null : this.keystorePath.equals(that.getKeystorePath())) && (this.keystorePassword == null ? that.getKeystorePassword() == null : this.keystorePassword.equals(that.getKeystorePassword())) && this.index.equals(that.getIndex()) && this.type.equals(that.getType()) && (this.socketTimeout == null ? that.getSocketTimeout() == null : this.socketTimeout.equals(that.getSocketTimeout())) && (this.connectTimeout == null ? that.getConnectTimeout() == null : this.connectTimeout.equals(that.getConnectTimeout())) && this.trustSelfSignedCerts == that.isTrustSelfSignedCerts();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.addresses.hashCode();
        h$ *= 1000003;
        h$ ^= this.username == null ? 0 : this.username.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= this.apiKey == null ? 0 : this.apiKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.bearerToken == null ? 0 : this.bearerToken.hashCode();
        h$ *= 1000003;
        h$ ^= this.keystorePath == null ? 0 : this.keystorePath.hashCode();
        h$ *= 1000003;
        h$ ^= this.keystorePassword == null ? 0 : this.keystorePassword.hashCode();
        h$ *= 1000003;
        h$ ^= this.index.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.socketTimeout == null ? 0 : this.socketTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectTimeout == null ? 0 : this.connectTimeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.trustSelfSignedCerts ? 1231 : 1237;
    }

    @Override
    ElasticsearchIO.ConnectionConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.ConnectionConfiguration.Builder {
        private List<String> addresses;
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String apiKey;
        private @Nullable String bearerToken;
        private @Nullable String keystorePath;
        private @Nullable String keystorePassword;
        private String index;
        private String type;
        private @Nullable Integer socketTimeout;
        private @Nullable Integer connectTimeout;
        private Boolean trustSelfSignedCerts;

        Builder() {
        }

        private Builder(ElasticsearchIO.ConnectionConfiguration source) {
            this.addresses = source.getAddresses();
            this.username = source.getUsername();
            this.password = source.getPassword();
            this.apiKey = source.getApiKey();
            this.bearerToken = source.getBearerToken();
            this.keystorePath = source.getKeystorePath();
            this.keystorePassword = source.getKeystorePassword();
            this.index = source.getIndex();
            this.type = source.getType();
            this.socketTimeout = source.getSocketTimeout();
            this.connectTimeout = source.getConnectTimeout();
            this.trustSelfSignedCerts = source.isTrustSelfSignedCerts();
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setAddresses(List<String> addresses) {
            if (addresses == null) {
                throw new NullPointerException("Null addresses");
            }
            this.addresses = addresses;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setIndex(String index) {
            if (index == null) {
                throw new NullPointerException("Null index");
            }
            this.index = index;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setType(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration.Builder setTrustSelfSignedCerts(boolean trustSelfSignedCerts) {
            this.trustSelfSignedCerts = trustSelfSignedCerts;
            return this;
        }

        @Override
        ElasticsearchIO.ConnectionConfiguration build() {
            if (this.addresses == null || this.index == null || this.type == null || this.trustSelfSignedCerts == null) {
                StringBuilder missing = new StringBuilder();
                if (this.addresses == null) {
                    missing.append(" addresses");
                }
                if (this.index == null) {
                    missing.append(" index");
                }
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.trustSelfSignedCerts == null) {
                    missing.append(" trustSelfSignedCerts");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration(this.addresses, this.username, this.password, this.apiKey, this.bearerToken, this.keystorePath, this.keystorePassword, this.index, this.type, this.socketTimeout, this.connectTimeout, this.trustSelfSignedCerts);
        }
    }
}

