/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;

final class AutoValue_ElasticsearchIO_ConnectionConfiguration
extends ElasticsearchIO.ConnectionConfiguration {
    private final List<String> addresses;
    private final String username;
    private final String password;
    private final String index;
    private final String type;

    private AutoValue_ElasticsearchIO_ConnectionConfiguration(List<String> addresses, @Nullable String username, @Nullable String password, String index, String type) {
        this.addresses = addresses;
        this.username = username;
        this.password = password;
        this.index = index;
        this.type = type;
    }

    @Override
    List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    @Nullable
    String getUsername() {
        return this.username;
    }

    @Override
    @Nullable
    String getPassword() {
        return this.password;
    }

    @Override
    String getIndex() {
        return this.index;
    }

    @Override
    String getType() {
        return this.type;
    }

    public String toString() {
        return "ConnectionConfiguration{addresses=" + this.addresses + ", username=" + this.username + ", password=" + this.password + ", index=" + this.index + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.ConnectionConfiguration) {
            ElasticsearchIO.ConnectionConfiguration that = (ElasticsearchIO.ConnectionConfiguration)o;
            return this.addresses.equals(that.getAddresses()) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && this.index.equals(that.getIndex()) && this.type.equals(that.getType());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.addresses.hashCode();
        h *= 1000003;
        h ^= this.username == null ? 0 : this.username.hashCode();
        h *= 1000003;
        h ^= this.password == null ? 0 : this.password.hashCode();
        h *= 1000003;
        h ^= this.index.hashCode();
        h *= 1000003;
        return h ^= this.type.hashCode();
    }

    @Override
    public ElasticsearchIO.ConnectionConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.ConnectionConfiguration.Builder {
        private List<String> addresses;
        private String username;
        private String password;
        private String index;
        private String type;

        Builder() {
        }

        Builder(ElasticsearchIO.ConnectionConfiguration source) {
            this.addresses = source.getAddresses();
            this.username = source.getUsername();
            this.password = source.getPassword();
            this.index = source.getIndex();
            this.type = source.getType();
        }

        @Override
        public ElasticsearchIO.ConnectionConfiguration.Builder setAddresses(List<String> addresses) {
            this.addresses = addresses;
            return this;
        }

        @Override
        public ElasticsearchIO.ConnectionConfiguration.Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        @Override
        public ElasticsearchIO.ConnectionConfiguration.Builder setPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        @Override
        public ElasticsearchIO.ConnectionConfiguration.Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        @Override
        public ElasticsearchIO.ConnectionConfiguration.Builder setType(String type) {
            this.type = type;
            return this;
        }

        @Override
        public ElasticsearchIO.ConnectionConfiguration build() {
            String missing = "";
            if (this.addresses == null) {
                missing = missing + " addresses";
            }
            if (this.index == null) {
                missing = missing + " index";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_ConnectionConfiguration(this.addresses, this.username, this.password, this.index, this.type);
        }
    }
}

