/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class RingRange
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized BigInteger start;
    private final @UnknownKeyFor @NonNull @Initialized BigInteger end;

    private RingRange(@UnknownKeyFor @NonNull @Initialized BigInteger start, @UnknownKeyFor @NonNull @Initialized BigInteger end) {
        this.start = start;
        this.end = end;
    }

    public @UnknownKeyFor @NonNull @Initialized BigInteger getStart() {
        return this.start;
    }

    public @UnknownKeyFor @NonNull @Initialized BigInteger getEnd() {
        return this.end;
    }

    @UnknownKeyFor @NonNull @Initialized BigInteger span(@UnknownKeyFor @NonNull @Initialized BigInteger ringSize) {
        return this.start.compareTo(this.end) >= 0 ? this.end.subtract(this.start).add(ringSize) : this.end.subtract(this.start);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isWrapping() {
        return this.start.compareTo(this.end) >= 0;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("(%s,%s]", this.start.toString(), this.end.toString());
    }

    public static @UnknownKeyFor @NonNull @Initialized RingRange of(@UnknownKeyFor @NonNull @Initialized BigInteger start, @UnknownKeyFor @NonNull @Initialized BigInteger end) {
        return new RingRange(start, end);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RingRange ringRange = (RingRange)o;
        if (this.getStart() != null ? !this.getStart().equals(ringRange.getStart()) : ringRange.getStart() != null) {
            return false;
        }
        return this.getEnd() != null ? this.getEnd().equals(ringRange.getEnd()) : ringRange.getEnd() == null;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = this.getStart() != null ? this.getStart().hashCode() : 0;
        result = 31 * result + (this.getEnd() != null ? this.getEnd().hashCode() : 0);
        return result;
    }
}

