/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.auto.value.AutoValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Read;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Write;
import org.apache.beam.sdk.io.cassandra.DefaultObjectMapperFactory;
import org.apache.beam.sdk.io.cassandra.Mapper;
import org.apache.beam.sdk.io.cassandra.RingRange;
import org.apache.beam.sdk.io.cassandra.SplitGenerator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CassandraIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CassandraIO.class);

    private CassandraIO() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return new AutoValue_CassandraIO_Read.Builder().build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return Write.builder(MutationType.WRITE).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> delete() {
        return Write.builder(MutationType.DELETE).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Cluster getCluster(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> connectTimeout, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> readTimeout) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(((List)hosts.get()).toArray(new String[0])).withPort(((Integer)port.get()).intValue());
        if (username != null) {
            builder.withAuthProvider((AuthProvider)new PlainTextAuthProvider((String)username.get(), (String)password.get()));
        }
        DCAwareRoundRobinPolicy.Builder dcAwarePolicyBuilder = new DCAwareRoundRobinPolicy.Builder();
        if (localDc != null) {
            dcAwarePolicyBuilder.withLocalDc((String)localDc.get());
        }
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)dcAwarePolicyBuilder.build()));
        if (consistencyLevel != null) {
            builder.withQueryOptions(new QueryOptions().setConsistencyLevel(ConsistencyLevel.valueOf((String)((String)consistencyLevel.get()))));
        }
        SocketOptions socketOptions = new SocketOptions();
        builder.withSocketOptions(socketOptions);
        if (connectTimeout != null) {
            socketOptions.setConnectTimeoutMillis(((Integer)connectTimeout.get()).intValue());
        }
        if (readTimeout != null) {
            socketOptions.setReadTimeoutMillis(((Integer)readTimeout.get()).intValue());
        }
        return builder.build();
    }

    private static class Mutator<@UnknownKeyFor T> {
        private static final @UnknownKeyFor @NonNull @Initialized int CONCURRENT_ASYNC_QUERIES = 100;
        private final @UnknownKeyFor @NonNull @Initialized Cluster cluster;
        private final @UnknownKeyFor @NonNull @Initialized Session session;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void>> mutateFutures;
        private final @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Mapper<T>, T, @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void>> mutator;
        private final @UnknownKeyFor @NonNull @Initialized String operationName;

        Mutator(@UnknownKeyFor @NonNull @Initialized Write<T> spec, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Mapper<T>, T, @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void>> mutator, @UnknownKeyFor @NonNull @Initialized String operationName) {
            this.cluster = CassandraIO.getCluster((ValueProvider<List<String>>)spec.hosts(), (ValueProvider<Integer>)spec.port(), (ValueProvider<String>)spec.username(), (ValueProvider<String>)spec.password(), (ValueProvider<String>)spec.localDc(), (ValueProvider<String>)spec.consistencyLevel(), (ValueProvider<Integer>)spec.connectTimeout(), (ValueProvider<Integer>)spec.readTimeout());
            this.session = this.cluster.connect((String)spec.keyspace().get());
            this.mapperFactoryFn = spec.mapperFactoryFn();
            this.mutateFutures = new ArrayList<Future<Void>>();
            this.mutator = mutator;
            this.operationName = operationName;
        }

        void mutate(T entity) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            Mapper mapper = (Mapper)this.mapperFactoryFn.apply((Object)this.session);
            this.mutateFutures.add(this.mutator.apply(mapper, (Mapper)entity));
            if (this.mutateFutures.size() == 100) {
                LOG.debug("Waiting for a batch of {} Cassandra {} to be executed...", (Object)100, (Object)this.operationName);
                this.waitForFuturesToFinish();
                this.mutateFutures = new ArrayList<Future<Void>>();
            }
        }

        void close() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            if (this.mutateFutures.size() > 0) {
                this.waitForFuturesToFinish();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }

        private void waitForFuturesToFinish() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            for (Future<Void> future : this.mutateFutures) {
                future.get();
            }
        }
    }

    private static class DeleteFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
        private transient @UnknownKeyFor @NonNull @Initialized Mutator<T> deleter;

        DeleteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.deleter = new Mutator<Object>(this.spec, Mapper::deleteAsync, "deletes");
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.deleter.mutate(c.element());
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.deleter.close();
            this.deleter = null;
        }
    }

    private static class WriteFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
        private transient @UnknownKeyFor @NonNull @Initialized Mutator<T> writer;

        WriteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.writer = new Mutator<Object>(this.spec, Mapper::saveAsync, "writes");
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.writer.mutate(c.element());
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.writer.close();
            this.writer = null;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> entity();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel();

        abstract @UnknownKeyFor @NonNull @Initialized MutationType mutationType();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> connectTimeout();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> readTimeout();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> builder(@UnknownKeyFor @NonNull @Initialized MutationType mutationType) {
            return new AutoValue_CassandraIO_Write.Builder().setMutationType(mutationType);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withHosts(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with null hosts"));
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with empty hosts list"));
            return this.withHosts((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hosts));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts) {
            return this.builder().setHosts(hosts).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPort(@UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withPort(port) called with invalid port number (%s)"), (int)port);
            return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port) {
            return this.builder().setPort(port).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withKeyspace(keyspace) called with null keyspace"));
            return this.withKeyspace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)keyspace));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace) {
            return this.builder().setKeyspace(keyspace).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withEntity(@UnknownKeyFor @NonNull @Initialized Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withEntity(entity) called with null entity"));
            return this.builder().setEntity(entity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withUsername(username) called with null username"));
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username) {
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withPassword(password) called with null password"));
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password) {
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withLocalDc(localDc) called with null localDc"));
            return this.withLocalDc((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)localDc));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc) {
            return this.builder().setLocalDc(localDc).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withConsistencyLevel(consistencyLevel) called with null consistencyLevel"));
            return this.withConsistencyLevel((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)consistencyLevel));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel) {
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null && timeout > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withConnectTimeout(timeout) called with invalid timeout number (%s)"), (Object)timeout);
            return this.withConnectTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setConnectTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null && timeout > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withReadTimeout(timeout) called with invalid timeout number (%s)"), (Object)timeout);
            return this.withReadTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setReadTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn) {
            Preconditions.checkArgument((mapperFactoryFn != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().mapperFactoryFn(mapperFactoryFn) called with null value"));
            return this.builder().setMapperFactoryFn(mapperFactoryFn).build();
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            Preconditions.checkState((this.hosts() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a list of hosts to be set via withHosts(hosts)"));
            Preconditions.checkState((this.port() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a valid port number to be set via withPort(port)"));
            Preconditions.checkState((this.keyspace() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a keyspace to be set via withKeyspace(keyspace)"));
            Preconditions.checkState((this.entity() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires an entity to be set via withEntity(entity)"));
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (this.mutationType() == MutationType.DELETE) {
                input.apply((PTransform)ParDo.of(new DeleteFn(this)));
            } else {
                input.apply((PTransform)ParDo.of(new WriteFn(this)));
            }
            return PDone.in((Pipeline)input.getPipeline());
        }

        private @UnknownKeyFor @NonNull @Initialized String getMutationTypeName() {
            return this.mutationType() == null ? MutationType.WRITE.name().toLowerCase() : this.mutationType().name().toLowerCase();
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setEntity(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Class<T>> entity();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMutationType(@UnknownKeyFor @NonNull @Initialized MutationType var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper>> mapperFactoryFn();

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized Write<T> build() {
                if (!this.mapperFactoryFn().isPresent() && this.entity().isPresent()) {
                    this.setMapperFactoryFn(new DefaultObjectMapperFactory<T>(this.entity().get()));
                }
                return this.autoBuild();
            }
        }
    }

    public static enum MutationType {
        WRITE,
        DELETE;

    }

    @VisibleForTesting
    static class CassandraSource<@UnknownKeyFor T>
    extends BoundedSource<T> {
        final @UnknownKeyFor @NonNull @Initialized Read<T> spec;
        final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> splitQueries;
        @UnknownKeyFor @NonNull @Initialized Long estimatedSize;
        private static final @UnknownKeyFor @NonNull @Initialized String MURMUR3PARTITIONER = "org.apache.cassandra.dht.Murmur3Partitioner";

        CassandraSource(@UnknownKeyFor @NonNull @Initialized Read<T> spec, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> splitQueries) {
            this(spec, splitQueries, null);
        }

        private CassandraSource(@UnknownKeyFor @NonNull @Initialized Read<T> spec, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> splitQueries, @UnknownKeyFor @NonNull @Initialized Long estimatedSize) {
            this.estimatedSize = estimatedSize;
            this.spec = spec;
            this.splitQueries = splitQueries;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
            return this.spec.coder();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            return new CassandraReader(this);
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            try (Cluster cluster = CassandraIO.getCluster((ValueProvider<List<String>>)this.spec.hosts(), (ValueProvider<Integer>)this.spec.port(), (ValueProvider<String>)this.spec.username(), (ValueProvider<String>)this.spec.password(), (ValueProvider<String>)this.spec.localDc(), (ValueProvider<String>)this.spec.consistencyLevel(), (ValueProvider<Integer>)this.spec.connectTimeout(), (ValueProvider<Integer>)this.spec.readTimeout());){
                if (CassandraSource.isMurmur3Partitioner(cluster)) {
                    LOG.info("Murmur3Partitioner detected, splitting");
                    List<BoundedSource<T>> list = this.splitWithTokenRanges(this.spec, desiredBundleSizeBytes, this.getEstimatedSizeBytes(pipelineOptions), cluster);
                    return list;
                }
                LOG.warn("Only Murmur3Partitioner is supported for splitting, using a unique source for the read");
                List<BoundedSource<T>> list = Collections.singletonList(new CassandraSource<T>(this.spec, Collections.singletonList(CassandraSource.buildQuery(this.spec))));
                return list;
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized String buildQuery(@UnknownKeyFor @NonNull @Initialized Read spec) {
            return spec.query() == null ? String.format("SELECT * FROM %s.%s", spec.keyspace().get(), spec.table().get()) : spec.query().get().toString();
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BoundedSource<T>> splitWithTokenRanges(@UnknownKeyFor @NonNull @Initialized Read<T> spec, @UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized long estimatedSizeBytes, @UnknownKeyFor @NonNull @Initialized Cluster cluster) {
            long numSplits = CassandraSource.getNumSplits(desiredBundleSizeBytes, estimatedSizeBytes, spec.minNumberOfSplits());
            LOG.info("Number of desired splits is {}", (Object)numSplits);
            SplitGenerator splitGenerator = new SplitGenerator(cluster.getMetadata().getPartitioner());
            List<BigInteger> tokens = cluster.getMetadata().getTokenRanges().stream().map(tokenRange -> new BigInteger(tokenRange.getEnd().getValue().toString())).collect(Collectors.toList());
            List<List<RingRange>> splits = splitGenerator.generateSplits(numSplits, tokens);
            LOG.info("{} splits were actually generated", (Object)splits.size());
            String partitionKey = cluster.getMetadata().getKeyspace((String)spec.keyspace().get()).getTable((String)spec.table().get()).getPartitionKey().stream().map(ColumnMetadata::getName).collect(Collectors.joining(","));
            List<TokenRange> tokenRanges = CassandraSource.getTokenRanges(cluster, (String)spec.keyspace().get(), (String)spec.table().get());
            long estimatedSize = CassandraSource.getEstimatedSizeBytesFromTokenRanges(tokenRanges) / (long)splits.size();
            ArrayList<BoundedSource<T>> sources = new ArrayList<BoundedSource<T>>();
            for (List<RingRange> split : splits) {
                ArrayList<String> queries = new ArrayList<String>();
                for (RingRange range : split) {
                    if (range.isWrapping()) {
                        queries.add(CassandraSource.generateRangeQuery(spec, partitionKey, range.getStart(), null));
                        queries.add(CassandraSource.generateRangeQuery(spec, partitionKey, null, range.getEnd()));
                        continue;
                    }
                    queries.add(CassandraSource.generateRangeQuery(spec, partitionKey, range.getStart(), range.getEnd()));
                }
                sources.add(new CassandraSource<T>(spec, queries, estimatedSize));
            }
            return sources;
        }

        private static @UnknownKeyFor @NonNull @Initialized String generateRangeQuery(@UnknownKeyFor @NonNull @Initialized Read spec, @UnknownKeyFor @NonNull @Initialized String partitionKey, @UnknownKeyFor @NonNull @Initialized BigInteger rangeStart, @UnknownKeyFor @NonNull @Initialized BigInteger rangeEnd) {
            String rangeFilter = Joiner.on((String)" AND ").skipNulls().join(rangeStart == null ? null : String.format("(token(%s) >= %d)", partitionKey, rangeStart), rangeEnd == null ? null : String.format("(token(%s) < %d)", partitionKey, rangeEnd), new Object[0]);
            String query = spec.query() == null ? CassandraSource.buildQuery(spec) + " WHERE " + rangeFilter : CassandraSource.buildQuery(spec) + " AND " + rangeFilter;
            LOG.debug("CassandraIO generated query : {}", (Object)query);
            return query;
        }

        private static @UnknownKeyFor @NonNull @Initialized long getNumSplits(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized long estimatedSizeBytes, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> minNumberOfSplits) {
            long numSplits;
            long l = numSplits = desiredBundleSizeBytes > 0L ? estimatedSizeBytes / desiredBundleSizeBytes : 1L;
            if (numSplits <= 0L) {
                LOG.warn("Number of splits is less than 0 ({}), fallback to 1", (Object)numSplits);
                numSplits = 1L;
            }
            return minNumberOfSplits != null ? Math.max(numSplits, (long)((Integer)minNumberOfSplits.get()).intValue()) : numSplits;
        }

        /*
         * Loose catch block
         */
        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            if (this.estimatedSize != null) {
                return this.estimatedSize;
            }
            Throwable throwable = null;
            try (Cluster cluster = CassandraIO.getCluster((ValueProvider<List<String>>)this.spec.hosts(), (ValueProvider<Integer>)this.spec.port(), (ValueProvider<String>)this.spec.username(), (ValueProvider<String>)this.spec.password(), (ValueProvider<String>)this.spec.localDc(), (ValueProvider<String>)this.spec.consistencyLevel(), (ValueProvider<Integer>)this.spec.connectTimeout(), (ValueProvider<Integer>)this.spec.readTimeout());){
                if (CassandraSource.isMurmur3Partitioner(cluster)) {
                    try {
                        List<TokenRange> tokenRanges = CassandraSource.getTokenRanges(cluster, (String)this.spec.keyspace().get(), (String)this.spec.table().get());
                        this.estimatedSize = CassandraSource.getEstimatedSizeBytesFromTokenRanges(tokenRanges);
                        long l = this.estimatedSize;
                        return l;
                    }
                    catch (Exception e) {
                        long l;
                        block12: {
                            LOG.warn("Can't estimate the size", (Throwable)e);
                            l = 0L;
                            if (cluster == null) break block12;
                            CassandraSource.$closeResource(throwable, (AutoCloseable)cluster);
                        }
                        return l;
                    }
                }
                LOG.warn("Only Murmur3 partitioner is supported, can't estimate the size");
                long l = 0L;
                return l;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytesFromTokenRanges(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TokenRange> tokenRanges) {
            long size = 0L;
            for (TokenRange tokenRange : tokenRanges) {
                size += tokenRange.meanPartitionSize * tokenRange.partitionCount;
            }
            return Math.round((double)size / CassandraSource.getRingFraction(tokenRanges));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.spec.hosts() != null) {
                builder.add(DisplayData.item((String)"hosts", (String)this.spec.hosts().toString()));
            }
            if (this.spec.port() != null) {
                builder.add(DisplayData.item((String)"port", this.spec.port()));
            }
            builder.addIfNotNull(DisplayData.item((String)"keyspace", this.spec.keyspace()));
            builder.addIfNotNull(DisplayData.item((String)"table", this.spec.table()));
            builder.addIfNotNull(DisplayData.item((String)"username", this.spec.username()));
            builder.addIfNotNull(DisplayData.item((String)"localDc", this.spec.localDc()));
            builder.addIfNotNull(DisplayData.item((String)"consistencyLevel", this.spec.consistencyLevel()));
        }

        private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TokenRange> getTokenRanges(@UnknownKeyFor @NonNull @Initialized Cluster cluster, @UnknownKeyFor @NonNull @Initialized String keyspace, @UnknownKeyFor @NonNull @Initialized String table) {
            try (Session session = cluster.newSession();){
                ResultSet resultSet = session.execute("SELECT range_start, range_end, partitions_count, mean_partition_size FROM system.size_estimates WHERE keyspace_name = ? AND table_name = ?", new Object[]{keyspace, table});
                ArrayList<TokenRange> tokenRanges = new ArrayList<TokenRange>();
                for (Row row : resultSet) {
                    TokenRange tokenRange = new TokenRange(row.getLong("partitions_count"), row.getLong("mean_partition_size"), new BigInteger(row.getString("range_start")), new BigInteger(row.getString("range_end")));
                    tokenRanges.add(tokenRange);
                }
                ArrayList<TokenRange> arrayList = tokenRanges;
                return arrayList;
            }
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized double getRingFraction(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TokenRange> tokenRanges) {
            double ringFraction = 0.0;
            for (TokenRange tokenRange : tokenRanges) {
                ringFraction += CassandraSource.distance(tokenRange.rangeStart, tokenRange.rangeEnd).doubleValue() / SplitGenerator.getRangeSize(MURMUR3PARTITIONER).doubleValue();
            }
            return ringFraction;
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized boolean isMurmur3Partitioner(@UnknownKeyFor @NonNull @Initialized Cluster cluster) {
            return MURMUR3PARTITIONER.equals(cluster.getMetadata().getPartitioner());
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized BigInteger distance(@UnknownKeyFor @NonNull @Initialized BigInteger left, @UnknownKeyFor @NonNull @Initialized BigInteger right) {
            return right.compareTo(left) > 0 ? right.subtract(left) : right.subtract(left).add(SplitGenerator.getRangeSize(MURMUR3PARTITIONER));
        }

        private class CassandraReader
        extends BoundedSource.BoundedReader<T> {
            private final @UnknownKeyFor @NonNull @Initialized CassandraSource<T> source;
            private @UnknownKeyFor @NonNull @Initialized Cluster cluster;
            private @UnknownKeyFor @NonNull @Initialized Session session;
            private @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator;
            private T current;

            CassandraReader(CassandraSource<T> source) {
                this.source = source;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean start() {
                LOG.debug("Starting Cassandra reader");
                this.cluster = CassandraIO.getCluster((ValueProvider<List<String>>)this.source.spec.hosts(), (ValueProvider<Integer>)this.source.spec.port(), (ValueProvider<String>)this.source.spec.username(), (ValueProvider<String>)this.source.spec.password(), (ValueProvider<String>)this.source.spec.localDc(), (ValueProvider<String>)this.source.spec.consistencyLevel(), (ValueProvider<Integer>)this.source.spec.connectTimeout(), (ValueProvider<Integer>)this.source.spec.readTimeout());
                this.session = this.cluster.connect((String)this.source.spec.keyspace().get());
                LOG.debug("Queries: " + this.source.splitQueries);
                ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
                for (String query : this.source.splitQueries) {
                    futures.add(this.session.executeAsync(query));
                }
                Mapper mapper = this.getMapper(this.session, this.source.spec.entity());
                for (ResultSetFuture result : futures) {
                    if (this.iterator == null) {
                        this.iterator = mapper.map(result.getUninterruptibly());
                        continue;
                    }
                    this.iterator = Iterators.concat(this.iterator, mapper.map(result.getUninterruptibly()));
                }
                return this.advance();
            }

            public @UnknownKeyFor @NonNull @Initialized boolean advance() {
                if (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    return true;
                }
                this.current = null;
                return false;
            }

            public void close() {
                LOG.debug("Closing Cassandra reader");
                if (this.session != null) {
                    this.session.close();
                }
                if (this.cluster != null) {
                    this.cluster.close();
                }
            }

            public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                return this.current;
            }

            public @UnknownKeyFor @NonNull @Initialized CassandraSource<T> getCurrentSource() {
                return this.source;
            }

            private @UnknownKeyFor @NonNull @Initialized Mapper<T> getMapper(@UnknownKeyFor @NonNull @Initialized Session session, @UnknownKeyFor @NonNull @Initialized Class<T> enitity) {
                return (Mapper)this.source.spec.mapperFactoryFn().apply((Object)session);
            }
        }

        @VisibleForTesting
        static class TokenRange {
            private final @UnknownKeyFor @NonNull @Initialized long partitionCount;
            private final @UnknownKeyFor @NonNull @Initialized long meanPartitionSize;
            private final @UnknownKeyFor @NonNull @Initialized BigInteger rangeStart;
            private final @UnknownKeyFor @NonNull @Initialized BigInteger rangeEnd;

            TokenRange(@UnknownKeyFor @NonNull @Initialized long partitionCount, @UnknownKeyFor @NonNull @Initialized long meanPartitionSize, @UnknownKeyFor @NonNull @Initialized BigInteger rangeStart, @UnknownKeyFor @NonNull @Initialized BigInteger rangeEnd) {
                this.partitionCount = partitionCount;
                this.meanPartitionSize = meanPartitionSize;
                this.rangeStart = rangeStart;
                this.rangeEnd = rangeEnd;
            }
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> entity();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> coder();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> minNumberOfSplits();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> connectTimeout();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> readTimeout();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactoryFn();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withHosts(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)"hosts can not be null");
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"hosts can not be empty");
            return this.withHosts((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hosts));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hosts) {
            return this.builder().setHosts(hosts).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPort(@UnknownKeyFor @NonNull @Initialized int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port must be > 0, but was: %s", (int)port);
            return this.withPort((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)port));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> port) {
            return this.builder().setPort(port).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)"keyspace can not be null");
            return this.withKeyspace((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)keyspace));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> keyspace) {
            return this.builder().setKeyspace(keyspace).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withTable(@UnknownKeyFor @NonNull @Initialized String table) {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table can not be null");
            return this.withTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> table) {
            return this.builder().setTable(table).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            Preconditions.checkArgument((query != null && query.length() > 0 ? 1 : 0) != 0, (Object)"query cannot be null");
            return this.withQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            return this.builder().setQuery(query).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withEntity(@UnknownKeyFor @NonNull @Initialized Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity can not be null");
            return this.builder().setEntity(entity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            return this.withUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> username) {
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return this.withPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> password) {
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)"localDc can not be null");
            return this.withLocalDc((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)localDc));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> localDc) {
            return this.builder().setLocalDc(localDc).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)"consistencyLevel can not be null");
            return this.withConsistencyLevel((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)consistencyLevel));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> consistencyLevel) {
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMinNumberOfSplits(@UnknownKeyFor @NonNull @Initialized Integer minNumberOfSplits) {
            Preconditions.checkArgument((minNumberOfSplits != null ? 1 : 0) != 0, (Object)"minNumberOfSplits can not be null");
            Preconditions.checkArgument((minNumberOfSplits > 0 ? 1 : 0) != 0, (Object)"minNumberOfSplits must be greater than 0");
            return this.withMinNumberOfSplits((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)minNumberOfSplits));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMinNumberOfSplits(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> minNumberOfSplits) {
            return this.builder().setMinNumberOfSplits(minNumberOfSplits).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null ? 1 : 0) != 0, (Object)"Connect timeout can not be null");
            Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Connect timeout must be > 0, but was: %s", (Object)timeout);
            return this.withConnectTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setConnectTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized Integer timeout) {
            Preconditions.checkArgument((timeout != null ? 1 : 0) != 0, (Object)"Read timeout can not be null");
            Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (String)"Read timeout must be > 0, but was: %s", (Object)timeout);
            return this.withReadTimeout((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)timeout));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> timeout) {
            return this.builder().setReadTimeout(timeout).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> mapperFactory) {
            Preconditions.checkArgument((mapperFactory != null ? 1 : 0) != 0, (Object)"CassandraIO.withMapperFactory(withMapperFactory) called with null value");
            return this.builder().setMapperFactoryFn(mapperFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.hosts() != null && this.port() != null ? 1 : 0) != 0, (Object)"WithHosts() and withPort() are required");
            Preconditions.checkArgument((this.keyspace() != null ? 1 : 0) != 0, (Object)"withKeyspace() is required");
            Preconditions.checkArgument((this.table() != null ? 1 : 0) != 0, (Object)"withTable() is required");
            Preconditions.checkArgument((this.entity() != null ? 1 : 0) != 0, (Object)"withEntity() is required");
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from(new CassandraSource(this, null)));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setHosts(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPort(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKeyspace(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTable(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setEntity(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Class<T>> entity();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsername(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPassword(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLocalDc(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConsistencyLevel(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMinNumberOfSplits(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMapperFactoryFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Session, @UnknownKeyFor @NonNull @Initialized Mapper>> mapperFactoryFn();

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> autoBuild();

            public @UnknownKeyFor @NonNull @Initialized Read<T> build() {
                if (!this.mapperFactoryFn().isPresent() && this.entity().isPresent()) {
                    this.setMapperFactoryFn(new DefaultObjectMapperFactory<T>(this.entity().get()));
                }
                return this.autoBuild();
            }
        }
    }
}

