/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.MappingManager;
import org.apache.beam.sdk.io.cassandra.DefaultObjectMapper;
import org.apache.beam.sdk.io.cassandra.Mapper;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DefaultObjectMapperFactory<@UnknownKeyFor T>
implements SerializableFunction<Session, Mapper> {
    private transient @UnknownKeyFor @NonNull @Initialized MappingManager mappingManager;
    @UnknownKeyFor @NonNull @Initialized Class<T> entity;

    DefaultObjectMapperFactory(@UnknownKeyFor @NonNull @Initialized Class<T> entity) {
        this.entity = entity;
    }

    public @UnknownKeyFor @NonNull @Initialized Mapper apply(@UnknownKeyFor @NonNull @Initialized Session session) {
        if (this.mappingManager == null) {
            this.mappingManager = new MappingManager(session);
        }
        return new DefaultObjectMapper(this.mappingManager.mapper(this.entity));
    }
}

