/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.Session;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.cassandra.CassandraIO;
import org.apache.beam.sdk.io.cassandra.Mapper;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;

final class AutoValue_CassandraIO_Write<T>
extends CassandraIO.Write<T> {
    private final ValueProvider<List<String>> hosts;
    private final ValueProvider<Integer> port;
    private final ValueProvider<String> keyspace;
    private final Class<T> entity;
    private final ValueProvider<String> username;
    private final ValueProvider<String> password;
    private final ValueProvider<String> localDc;
    private final ValueProvider<String> consistencyLevel;
    private final CassandraIO.MutationType mutationType;
    private final ValueProvider<Integer> connectTimeout;
    private final ValueProvider<Integer> readTimeout;
    private final SerializableFunction<Session, Mapper> mapperFactoryFn;

    private AutoValue_CassandraIO_Write(@Nullable ValueProvider<List<String>> hosts, @Nullable ValueProvider<Integer> port, @Nullable ValueProvider<String> keyspace, @Nullable Class<T> entity, @Nullable ValueProvider<String> username, @Nullable ValueProvider<String> password, @Nullable ValueProvider<String> localDc, @Nullable ValueProvider<String> consistencyLevel, CassandraIO.MutationType mutationType, @Nullable ValueProvider<Integer> connectTimeout, @Nullable ValueProvider<Integer> readTimeout, @Nullable SerializableFunction<Session, Mapper> mapperFactoryFn) {
        this.hosts = hosts;
        this.port = port;
        this.keyspace = keyspace;
        this.entity = entity;
        this.username = username;
        this.password = password;
        this.localDc = localDc;
        this.consistencyLevel = consistencyLevel;
        this.mutationType = mutationType;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.mapperFactoryFn = mapperFactoryFn;
    }

    @Override
    @Nullable
    ValueProvider<List<String>> hosts() {
        return this.hosts;
    }

    @Override
    @Nullable
    ValueProvider<Integer> port() {
        return this.port;
    }

    @Override
    @Nullable
    ValueProvider<String> keyspace() {
        return this.keyspace;
    }

    @Override
    @Nullable
    Class<T> entity() {
        return this.entity;
    }

    @Override
    @Nullable
    ValueProvider<String> username() {
        return this.username;
    }

    @Override
    @Nullable
    ValueProvider<String> password() {
        return this.password;
    }

    @Override
    @Nullable
    ValueProvider<String> localDc() {
        return this.localDc;
    }

    @Override
    @Nullable
    ValueProvider<String> consistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    CassandraIO.MutationType mutationType() {
        return this.mutationType;
    }

    @Override
    @Nullable
    ValueProvider<Integer> connectTimeout() {
        return this.connectTimeout;
    }

    @Override
    @Nullable
    ValueProvider<Integer> readTimeout() {
        return this.readTimeout;
    }

    @Override
    @Nullable
    SerializableFunction<Session, Mapper> mapperFactoryFn() {
        return this.mapperFactoryFn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CassandraIO.Write) {
            CassandraIO.Write that = (CassandraIO.Write)((Object)o);
            return (this.hosts == null ? that.hosts() == null : this.hosts.equals(that.hosts())) && (this.port == null ? that.port() == null : this.port.equals(that.port())) && (this.keyspace == null ? that.keyspace() == null : this.keyspace.equals(that.keyspace())) && (this.entity == null ? that.entity() == null : this.entity.equals(that.entity())) && (this.username == null ? that.username() == null : this.username.equals(that.username())) && (this.password == null ? that.password() == null : this.password.equals(that.password())) && (this.localDc == null ? that.localDc() == null : this.localDc.equals(that.localDc())) && (this.consistencyLevel == null ? that.consistencyLevel() == null : this.consistencyLevel.equals(that.consistencyLevel())) && this.mutationType.equals((Object)that.mutationType()) && (this.connectTimeout == null ? that.connectTimeout() == null : this.connectTimeout.equals(that.connectTimeout())) && (this.readTimeout == null ? that.readTimeout() == null : this.readTimeout.equals(that.readTimeout())) && (this.mapperFactoryFn == null ? that.mapperFactoryFn() == null : this.mapperFactoryFn.equals(that.mapperFactoryFn()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.hosts == null ? 0 : this.hosts.hashCode();
        h$ *= 1000003;
        h$ ^= this.port == null ? 0 : this.port.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyspace == null ? 0 : this.keyspace.hashCode();
        h$ *= 1000003;
        h$ ^= this.entity == null ? 0 : this.entity.hashCode();
        h$ *= 1000003;
        h$ ^= this.username == null ? 0 : this.username.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= this.localDc == null ? 0 : this.localDc.hashCode();
        h$ *= 1000003;
        h$ ^= this.consistencyLevel == null ? 0 : this.consistencyLevel.hashCode();
        h$ *= 1000003;
        h$ ^= this.mutationType.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectTimeout == null ? 0 : this.connectTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.readTimeout == null ? 0 : this.readTimeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.mapperFactoryFn == null ? 0 : this.mapperFactoryFn.hashCode();
    }

    @Override
    CassandraIO.Write.Builder<T> builder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends CassandraIO.Write.Builder<T> {
        private ValueProvider<List<String>> hosts;
        private ValueProvider<Integer> port;
        private ValueProvider<String> keyspace;
        private Class<T> entity;
        private ValueProvider<String> username;
        private ValueProvider<String> password;
        private ValueProvider<String> localDc;
        private ValueProvider<String> consistencyLevel;
        private CassandraIO.MutationType mutationType;
        private ValueProvider<Integer> connectTimeout;
        private ValueProvider<Integer> readTimeout;
        private SerializableFunction<Session, Mapper> mapperFactoryFn;

        Builder() {
        }

        private Builder(CassandraIO.Write<T> source) {
            this.hosts = source.hosts();
            this.port = source.port();
            this.keyspace = source.keyspace();
            this.entity = source.entity();
            this.username = source.username();
            this.password = source.password();
            this.localDc = source.localDc();
            this.consistencyLevel = source.consistencyLevel();
            this.mutationType = source.mutationType();
            this.connectTimeout = source.connectTimeout();
            this.readTimeout = source.readTimeout();
            this.mapperFactoryFn = source.mapperFactoryFn();
        }

        @Override
        CassandraIO.Write.Builder<T> setHosts(ValueProvider<List<String>> hosts) {
            this.hosts = hosts;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setPort(ValueProvider<Integer> port) {
            this.port = port;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setKeyspace(ValueProvider<String> keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setEntity(Class<T> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        @Nullable
        Optional<Class<T>> entity() {
            if (this.entity == null) {
                return Optional.empty();
            }
            return Optional.of(this.entity);
        }

        @Override
        CassandraIO.Write.Builder<T> setUsername(ValueProvider<String> username) {
            this.username = username;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setPassword(ValueProvider<String> password) {
            this.password = password;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setLocalDc(ValueProvider<String> localDc) {
            this.localDc = localDc;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setConsistencyLevel(ValueProvider<String> consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setMutationType(CassandraIO.MutationType mutationType) {
            if (mutationType == null) {
                throw new NullPointerException("Null mutationType");
            }
            this.mutationType = mutationType;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setConnectTimeout(ValueProvider<Integer> connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setReadTimeout(ValueProvider<Integer> readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        CassandraIO.Write.Builder<T> setMapperFactoryFn(SerializableFunction<Session, Mapper> mapperFactoryFn) {
            this.mapperFactoryFn = mapperFactoryFn;
            return this;
        }

        @Override
        @Nullable
        Optional<SerializableFunction<Session, Mapper>> mapperFactoryFn() {
            if (this.mapperFactoryFn == null) {
                return Optional.empty();
            }
            return Optional.of(this.mapperFactoryFn);
        }

        @Override
        CassandraIO.Write<T> autoBuild() {
            String missing = "";
            if (this.mutationType == null) {
                missing = missing + " mutationType";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CassandraIO_Write(this.hosts, this.port, this.keyspace, this.entity, this.username, this.password, this.localDc, this.consistencyLevel, this.mutationType, this.connectTimeout, this.readTimeout, this.mapperFactoryFn);
        }
    }
}

