/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Mutate;
import org.apache.beam.sdk.io.cassandra.AutoValue_CassandraIO_Read;
import org.apache.beam.sdk.io.cassandra.CassandraService;
import org.apache.beam.sdk.io.cassandra.CassandraServiceImpl;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CassandraIO {
    private CassandraIO() {
    }

    public static <T> Read<T> read() {
        return new AutoValue_CassandraIO_Read.Builder().setCassandraService(new CassandraServiceImpl()).build();
    }

    public static <T> Mutate<T> write() {
        return Mutate.builder(MutationType.WRITE).setCassandraService(new CassandraServiceImpl()).build();
    }

    public static <T> Mutate<T> delete() {
        return Mutate.builder(MutationType.DELETE).setCassandraService(new CassandraServiceImpl()).build();
    }

    private static class DeleteFn<T>
    extends DoFn<T, Void> {
        private final Mutate<T> spec;
        private CassandraService.Deleter<T> deleter;

        DeleteFn(Mutate<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.deleter = this.spec.cassandraService().createDeleter(this.spec);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws ExecutionException, InterruptedException {
            this.deleter.delete(c.element());
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.deleter.close();
            this.deleter = null;
        }
    }

    private static class WriteFn<T>
    extends DoFn<T, Void> {
        private final Mutate<T> spec;
        private CassandraService.Writer<T> writer;

        WriteFn(Mutate<T> spec) {
            this.spec = spec;
        }

        @DoFn.Setup
        public void setup() {
            this.writer = this.spec.cassandraService().createWriter(this.spec);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws ExecutionException, InterruptedException {
            this.writer.write(c.element());
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.writer.close();
            this.writer = null;
        }
    }

    @AutoValue
    public static abstract class Mutate<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract List<String> hosts();

        @Nullable
        abstract Integer port();

        @Nullable
        abstract String keyspace();

        @Nullable
        abstract Class<T> entity();

        @Nullable
        abstract String username();

        @Nullable
        abstract String password();

        @Nullable
        abstract String localDc();

        @Nullable
        abstract String consistencyLevel();

        @Nullable
        abstract CassandraService<T> cassandraService();

        abstract MutationType mutationType();

        abstract Builder<T> builder();

        static <T> Builder<T> builder(MutationType mutationType) {
            return new AutoValue_CassandraIO_Mutate.Builder().setMutationType(mutationType);
        }

        public Mutate<T> withHosts(List<String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with null hosts"));
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withHosts(hosts) called with empty hosts list"));
            return this.builder().setHosts(hosts).build();
        }

        public Mutate<T> withPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)("CassandraIO." + this.getMutationTypeName() + "().withPort(port) called with invalid port number (%s)"), (int)port);
            return this.builder().setPort(port).build();
        }

        public Mutate<T> withKeyspace(String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withKeyspace(keyspace) called with null keyspace"));
            return this.builder().setKeyspace(keyspace).build();
        }

        public Mutate<T> withEntity(Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withEntity(entity) called with null entity"));
            return this.builder().setEntity(entity).build();
        }

        public Mutate<T> withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withUsername(username) called with null username"));
            return this.builder().setUsername(username).build();
        }

        public Mutate<T> withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withPassword(password) called with null password"));
            return this.builder().setPassword(password).build();
        }

        public Mutate<T> withLocalDc(String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withLocalDc(localDc) called with null localDc"));
            return this.builder().setLocalDc(localDc).build();
        }

        public Mutate<T> withConsistencyLevel(String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withConsistencyLevel(consistencyLevel) called with null consistencyLevel"));
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public Mutate<T> withCassandraService(CassandraService<T> cassandraService) {
            Preconditions.checkArgument((cassandraService != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "().withCassandraService(service) called with null service"));
            return this.builder().setCassandraService(cassandraService).build();
        }

        public void validate(PipelineOptions pipelineOptions) {
            Preconditions.checkState((this.hosts() != null || this.cassandraService() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a list of hosts to be set via withHosts(hosts) or a Cassandra service to be set via withCassandraService(service)"));
            Preconditions.checkState((this.port() != null || this.cassandraService() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a valid port number to be set via withPort(port) or a Cassandra service to be set via withCassandraService(service)"));
            Preconditions.checkState((this.keyspace() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires a keyspace to be set via withKeyspace(keyspace)"));
            Preconditions.checkState((this.entity() != null ? 1 : 0) != 0, (Object)("CassandraIO." + this.getMutationTypeName() + "() requires an entity to be set via withEntity(entity)"));
        }

        public PDone expand(PCollection<T> input) {
            if (this.mutationType() == MutationType.DELETE) {
                input.apply((PTransform)ParDo.of(new DeleteFn(this)));
            } else {
                input.apply((PTransform)ParDo.of(new WriteFn(this)));
            }
            return PDone.in((Pipeline)input.getPipeline());
        }

        private String getMutationTypeName() {
            return this.mutationType() == null ? MutationType.WRITE.name().toLowerCase() : this.mutationType().name().toLowerCase();
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setHosts(List<String> var1);

            abstract Builder<T> setPort(Integer var1);

            abstract Builder<T> setKeyspace(String var1);

            abstract Builder<T> setEntity(Class<T> var1);

            abstract Builder<T> setUsername(String var1);

            abstract Builder<T> setPassword(String var1);

            abstract Builder<T> setLocalDc(String var1);

            abstract Builder<T> setConsistencyLevel(String var1);

            abstract Builder<T> setCassandraService(CassandraService<T> var1);

            abstract Builder<T> setMutationType(MutationType var1);

            abstract Mutate<T> build();
        }
    }

    public static enum MutationType {
        WRITE,
        DELETE;

    }

    @VisibleForTesting
    static class CassandraSource<T>
    extends BoundedSource<T> {
        final Read<T> spec;
        final List<String> splitQueries;

        CassandraSource(Read<T> spec, List<String> splitQueries) {
            this.spec = spec;
            this.splitQueries = splitQueries;
        }

        public Coder<T> getOutputCoder() {
            return this.spec.coder();
        }

        public BoundedSource.BoundedReader<T> createReader(PipelineOptions pipelineOptions) {
            return this.spec.cassandraService().createReader(this);
        }

        public long getEstimatedSizeBytes(PipelineOptions pipelineOptions) {
            return this.spec.cassandraService().getEstimatedSizeBytes(this.spec);
        }

        public List<BoundedSource<T>> split(long desiredBundleSizeBytes, PipelineOptions pipelineOptions) {
            return this.spec.cassandraService().split(this.spec, desiredBundleSizeBytes);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.spec.hosts() != null) {
                builder.add(DisplayData.item((String)"hosts", (String)this.spec.hosts().toString()));
            }
            if (this.spec.port() != null) {
                builder.add(DisplayData.item((String)"port", (Integer)this.spec.port()));
            }
            builder.addIfNotNull(DisplayData.item((String)"keyspace", (String)this.spec.keyspace()));
            builder.addIfNotNull(DisplayData.item((String)"table", (String)this.spec.table()));
            builder.addIfNotNull(DisplayData.item((String)"username", (String)this.spec.username()));
            builder.addIfNotNull(DisplayData.item((String)"localDc", (String)this.spec.localDc()));
            builder.addIfNotNull(DisplayData.item((String)"consistencyLevel", (String)this.spec.consistencyLevel()));
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract List<String> hosts();

        @Nullable
        abstract Integer port();

        @Nullable
        abstract String keyspace();

        @Nullable
        abstract String table();

        @Nullable
        abstract Class<T> entity();

        @Nullable
        abstract Coder<T> coder();

        @Nullable
        abstract String username();

        @Nullable
        abstract String password();

        @Nullable
        abstract String localDc();

        @Nullable
        abstract String consistencyLevel();

        @Nullable
        abstract Integer minNumberOfSplits();

        abstract CassandraService<T> cassandraService();

        abstract Builder<T> builder();

        public Read<T> withHosts(List<String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)"hosts can not be null");
            Preconditions.checkArgument((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"hosts can not be empty");
            return this.builder().setHosts(hosts).build();
        }

        public Read<T> withPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port must be > 0, but was: %s", (int)port);
            return this.builder().setPort(port).build();
        }

        public Read<T> withKeyspace(String keyspace) {
            Preconditions.checkArgument((keyspace != null ? 1 : 0) != 0, (Object)"keyspace can not be null");
            return this.builder().setKeyspace(keyspace).build();
        }

        public Read<T> withTable(String table) {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table can not be null");
            return this.builder().setTable(table).build();
        }

        public Read<T> withEntity(Class<T> entity) {
            Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity can not be null");
            return this.builder().setEntity(entity).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public Read<T> withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            return this.builder().setUsername(username).build();
        }

        public Read<T> withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return this.builder().setPassword(password).build();
        }

        public Read<T> withLocalDc(String localDc) {
            Preconditions.checkArgument((localDc != null ? 1 : 0) != 0, (Object)"localDc can not be null");
            return this.builder().setLocalDc(localDc).build();
        }

        public Read<T> withConsistencyLevel(String consistencyLevel) {
            Preconditions.checkArgument((consistencyLevel != null ? 1 : 0) != 0, (Object)"consistencyLevel can not be null");
            return this.builder().setConsistencyLevel(consistencyLevel).build();
        }

        public Read<T> withMinNumberOfSplits(Integer minNumberOfSplits) {
            Preconditions.checkArgument((minNumberOfSplits != null ? 1 : 0) != 0, (Object)"minNumberOfSplits can not be null");
            Preconditions.checkArgument((minNumberOfSplits > 0 ? 1 : 0) != 0, (Object)"minNumberOfSplits must be greater than 0");
            return this.builder().setMinNumberOfSplits(minNumberOfSplits).build();
        }

        public Read<T> withCassandraService(CassandraService<T> cassandraService) {
            Preconditions.checkArgument((cassandraService != null ? 1 : 0) != 0, (Object)"cassandraService can not be null");
            return this.builder().setCassandraService(cassandraService).build();
        }

        public PCollection<T> expand(PBegin input) {
            Preconditions.checkArgument((this.hosts() != null && this.port() != null || this.cassandraService() != null ? 1 : 0) != 0, (Object)"Either withHosts() and withPort(), or withCassandraService() is required");
            Preconditions.checkArgument((this.keyspace() != null ? 1 : 0) != 0, (Object)"withKeyspace() is required");
            Preconditions.checkArgument((this.table() != null ? 1 : 0) != 0, (Object)"withTable() is required");
            Preconditions.checkArgument((this.entity() != null ? 1 : 0) != 0, (Object)"withEntity() is required");
            Preconditions.checkArgument((this.coder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from(new CassandraSource(this, null)));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setHosts(List<String> var1);

            abstract Builder<T> setPort(Integer var1);

            abstract Builder<T> setKeyspace(String var1);

            abstract Builder<T> setTable(String var1);

            abstract Builder<T> setEntity(Class<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setUsername(String var1);

            abstract Builder<T> setPassword(String var1);

            abstract Builder<T> setLocalDc(String var1);

            abstract Builder<T> setConsistencyLevel(String var1);

            abstract Builder<T> setMinNumberOfSplits(Integer var1);

            abstract Builder<T> setCassandraService(CassandraService<T> var1);

            abstract Read<T> build();
        }
    }
}

