/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.options;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

public class AwsModule
extends SimpleModule {
    private static final String AWS_ACCESS_KEY_ID = "awsAccessKeyId";
    private static final String AWS_SECRET_KEY = "awsSecretKey";
    private static final String SESSION_TOKEN = "sessionToken";
    private static final String CREDENTIALS_FILE_PATH = "credentialsFilePath";
    public static final String CLIENT_EXECUTION_TIMEOUT = "clientExecutionTimeout";
    public static final String CONNECTION_MAX_IDLE_TIME = "connectionMaxIdleTime";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String CONNECTION_TIME_TO_LIVE = "connectionTimeToLive";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String REQUEST_TIMEOUT = "requestTimeout";
    public static final String SOCKET_TIMEOUT = "socketTimeout";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USERNAME = "proxyUsername";
    public static final String PROXY_PASSWORD = "proxyPassword";
    private static final String ROLE_ARN = "roleArn";
    private static final String ROLE_SESSION_NAME = "roleSessionName";

    public AwsModule() {
        super("AwsModule");
        this.setMixInAnnotation(AWSCredentialsProvider.class, AWSCredentialsProviderMixin.class);
        this.setMixInAnnotation(SSECustomerKey.class, SSECustomerKeyMixin.class);
        this.setMixInAnnotation(SSEAwsKeyManagementParams.class, SSEAwsKeyManagementParamsMixin.class);
        this.setMixInAnnotation(ClientConfiguration.class, AwsHttpClientConfigurationMixin.class);
    }

    private static String getNotNull(Map<String, String> map, String key, Class<?> clazz) {
        return (String)Preconditions.checkNotNull((Object)map.get(key), (String)"`%s` required in serialized %s", (Object)key, (Object)clazz.getSimpleName());
    }

    private static class AwsHttpClientConfigurationSerializer
    extends JsonSerializer<ClientConfiguration> {
        private AwsHttpClientConfigurationSerializer() {
        }

        public void serialize(ClientConfiguration clientConfiguration, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField(AwsModule.PROXY_HOST, (Object)clientConfiguration.getProxyHost());
            jsonGenerator.writeObjectField(AwsModule.PROXY_PORT, (Object)clientConfiguration.getProxyPort());
            jsonGenerator.writeObjectField(AwsModule.PROXY_USERNAME, (Object)clientConfiguration.getProxyUsername());
            jsonGenerator.writeObjectField(AwsModule.PROXY_PASSWORD, (Object)clientConfiguration.getProxyPassword());
            jsonGenerator.writeObjectField(AwsModule.CLIENT_EXECUTION_TIMEOUT, (Object)clientConfiguration.getClientExecutionTimeout());
            jsonGenerator.writeObjectField(AwsModule.CONNECTION_MAX_IDLE_TIME, (Object)clientConfiguration.getConnectionMaxIdleMillis());
            jsonGenerator.writeObjectField(AwsModule.CONNECTION_TIMEOUT, (Object)clientConfiguration.getConnectionTimeout());
            jsonGenerator.writeObjectField(AwsModule.CONNECTION_TIME_TO_LIVE, (Object)clientConfiguration.getConnectionTTL());
            jsonGenerator.writeObjectField(AwsModule.MAX_CONNECTIONS, (Object)clientConfiguration.getMaxConnections());
            jsonGenerator.writeObjectField(AwsModule.REQUEST_TIMEOUT, (Object)clientConfiguration.getRequestTimeout());
            jsonGenerator.writeObjectField(AwsModule.SOCKET_TIMEOUT, (Object)clientConfiguration.getSocketTimeout());
            jsonGenerator.writeEndObject();
        }
    }

    private static class AwsHttpClientConfigurationDeserializer
    extends JsonDeserializer<ClientConfiguration> {
        private AwsHttpClientConfigurationDeserializer() {
        }

        public ClientConfiguration deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Map map = (Map)Preconditions.checkNotNull((Object)((Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){})), (Object)"Serialized ClientConfiguration is null");
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            if (map.containsKey(AwsModule.PROXY_HOST)) {
                clientConfiguration.setProxyHost((String)map.get(AwsModule.PROXY_HOST));
            }
            if (map.containsKey(AwsModule.PROXY_PORT)) {
                clientConfiguration.setProxyPort(((Number)map.get(AwsModule.PROXY_PORT)).intValue());
            }
            if (map.containsKey(AwsModule.PROXY_USERNAME)) {
                clientConfiguration.setProxyUsername((String)map.get(AwsModule.PROXY_USERNAME));
            }
            if (map.containsKey(AwsModule.PROXY_PASSWORD)) {
                clientConfiguration.setProxyPassword((String)map.get(AwsModule.PROXY_PASSWORD));
            }
            if (map.containsKey(AwsModule.CLIENT_EXECUTION_TIMEOUT)) {
                clientConfiguration.setClientExecutionTimeout(((Number)map.get(AwsModule.CLIENT_EXECUTION_TIMEOUT)).intValue());
            }
            if (map.containsKey(AwsModule.CONNECTION_MAX_IDLE_TIME)) {
                clientConfiguration.setConnectionMaxIdleMillis(((Number)map.get(AwsModule.CONNECTION_MAX_IDLE_TIME)).longValue());
            }
            if (map.containsKey(AwsModule.CONNECTION_TIMEOUT)) {
                clientConfiguration.setConnectionTimeout(((Number)map.get(AwsModule.CONNECTION_TIMEOUT)).intValue());
            }
            if (map.containsKey(AwsModule.CONNECTION_TIME_TO_LIVE)) {
                clientConfiguration.setConnectionTTL(((Number)map.get(AwsModule.CONNECTION_TIME_TO_LIVE)).longValue());
            }
            if (map.containsKey(AwsModule.MAX_CONNECTIONS)) {
                clientConfiguration.setMaxConnections(((Number)map.get(AwsModule.MAX_CONNECTIONS)).intValue());
            }
            if (map.containsKey(AwsModule.REQUEST_TIMEOUT)) {
                clientConfiguration.setRequestTimeout(((Number)map.get(AwsModule.REQUEST_TIMEOUT)).intValue());
            }
            if (map.containsKey(AwsModule.SOCKET_TIMEOUT)) {
                clientConfiguration.setSocketTimeout(((Number)map.get(AwsModule.SOCKET_TIMEOUT)).intValue());
            }
            return clientConfiguration;
        }
    }

    @JsonSerialize(using=AwsHttpClientConfigurationSerializer.class)
    @JsonDeserialize(using=AwsHttpClientConfigurationDeserializer.class)
    private static class AwsHttpClientConfigurationMixin {
        private AwsHttpClientConfigurationMixin() {
        }
    }

    private static class SSEAwsKeyManagementParamsDeserializer
    extends JsonDeserializer<SSEAwsKeyManagementParams> {
        private SSEAwsKeyManagementParamsDeserializer() {
        }

        public SSEAwsKeyManagementParams deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Map asMap = (Map)Preconditions.checkNotNull((Object)((Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){})), (Object)"Serialized SSEAwsKeyManagementParams is null");
            return new SSEAwsKeyManagementParams(AwsModule.getNotNull(asMap, "awsKmsKeyId", SSEAwsKeyManagementParams.class));
        }
    }

    @JsonDeserialize(using=SSEAwsKeyManagementParamsDeserializer.class)
    private static class SSEAwsKeyManagementParamsMixin {
        private SSEAwsKeyManagementParamsMixin() {
        }
    }

    private static class SSECustomerKeyDeserializer
    extends JsonDeserializer<SSECustomerKey> {
        private SSECustomerKeyDeserializer() {
        }

        public SSECustomerKey deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Map asMap = (Map)Preconditions.checkNotNull((Object)((Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){})), (Object)"Serialized SSECustomerKey is null");
            SSECustomerKey sseCustomerKey = new SSECustomerKey(AwsModule.getNotNull(asMap, "key", SSECustomerKey.class));
            String algorithm = (String)asMap.get("algorithm");
            String md5 = (String)asMap.get("md5");
            if (algorithm != null) {
                sseCustomerKey.setAlgorithm(algorithm);
            }
            if (md5 != null) {
                sseCustomerKey.setMd5(md5);
            }
            return sseCustomerKey;
        }
    }

    @JsonDeserialize(using=SSECustomerKeyDeserializer.class)
    private static class SSECustomerKeyMixin {
        private SSECustomerKeyMixin() {
        }
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AWSCredentialsProvider> {
        private static final ImmutableSet<Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultAWSCredentialsProviderChain.class, EnvironmentVariableCredentialsProvider.class, SystemPropertiesCredentialsProvider.class, ProfileCredentialsProvider.class, EC2ContainerCredentialsProviderWrapper.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(AWSCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            serializers.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(AWSCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForObject((Object)credentialsProvider, jsonGenerator);
            Class<?> providerClass = credentialsProvider.getClass();
            if (providerClass.equals(AWSStaticCredentialsProvider.class)) {
                AWSCredentials credentials = credentialsProvider.getCredentials();
                if (credentials.getClass().equals(BasicSessionCredentials.class)) {
                    BasicSessionCredentials sessionCredentials = (BasicSessionCredentials)credentials;
                    jsonGenerator.writeStringField(AwsModule.AWS_ACCESS_KEY_ID, sessionCredentials.getAWSAccessKeyId());
                    jsonGenerator.writeStringField(AwsModule.AWS_SECRET_KEY, sessionCredentials.getAWSSecretKey());
                    jsonGenerator.writeStringField(AwsModule.SESSION_TOKEN, sessionCredentials.getSessionToken());
                } else {
                    jsonGenerator.writeStringField(AwsModule.AWS_ACCESS_KEY_ID, credentials.getAWSAccessKeyId());
                    jsonGenerator.writeStringField(AwsModule.AWS_SECRET_KEY, credentials.getAWSSecretKey());
                }
            } else if (providerClass.equals(PropertiesFileCredentialsProvider.class)) {
                String filePath = (String)this.readField(credentialsProvider, AwsModule.CREDENTIALS_FILE_PATH);
                jsonGenerator.writeStringField(AwsModule.CREDENTIALS_FILE_PATH, filePath);
            } else if (providerClass.equals(ClasspathPropertiesFileCredentialsProvider.class)) {
                String filePath = (String)this.readField(credentialsProvider, AwsModule.CREDENTIALS_FILE_PATH);
                jsonGenerator.writeStringField(AwsModule.CREDENTIALS_FILE_PATH, filePath);
            } else if (providerClass.equals(STSAssumeRoleSessionCredentialsProvider.class)) {
                String arn = (String)this.readField(credentialsProvider, AwsModule.ROLE_ARN);
                String sessionName = (String)this.readField(credentialsProvider, AwsModule.ROLE_SESSION_NAME);
                jsonGenerator.writeStringField(AwsModule.ROLE_ARN, arn);
                jsonGenerator.writeStringField(AwsModule.ROLE_SESSION_NAME, sessionName);
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(providerClass)) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + providerClass);
            }
            typeSerializer.writeTypeSuffixForObject((Object)credentialsProvider, jsonGenerator);
        }

        private Object readField(AWSCredentialsProvider provider, String fieldName) throws IOException {
            try {
                return FieldUtils.readField((Object)provider, (String)fieldName, (boolean)true);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IOException(String.format("Failed to access private field '%s' of AWS credential provider type '%s' with reflection", fieldName, provider.getClass().getSimpleName()), e);
            }
        }
    }

    private static class AWSCredentialsProviderDeserializer
    extends JsonDeserializer<AWSCredentialsProvider> {
        private AWSCredentialsProviderDeserializer() {
        }

        public AWSCredentialsProvider deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return (AWSCredentialsProvider)context.readValue(jsonParser, AWSCredentialsProvider.class);
        }

        public AWSCredentialsProvider deserializeWithType(JsonParser jsonParser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            String typeNameKey;
            Map asMap = (Map)Preconditions.checkNotNull((Object)((Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){})), (Object)"Serialized AWS credentials provider is null");
            String typeName = this.getNotNull(asMap, typeNameKey = typeDeserializer.getPropertyName(), "unknown");
            if (this.hasName(AWSStaticCredentialsProvider.class, typeName)) {
                boolean isSession = asMap.containsKey(AwsModule.SESSION_TOKEN);
                if (isSession) {
                    return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(this.getNotNull(asMap, AwsModule.AWS_ACCESS_KEY_ID, typeName), this.getNotNull(asMap, AwsModule.AWS_SECRET_KEY, typeName), this.getNotNull(asMap, AwsModule.SESSION_TOKEN, typeName)));
                }
                return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.getNotNull(asMap, AwsModule.AWS_ACCESS_KEY_ID, typeName), this.getNotNull(asMap, AwsModule.AWS_SECRET_KEY, typeName)));
            }
            if (this.hasName(PropertiesFileCredentialsProvider.class, typeName)) {
                return new PropertiesFileCredentialsProvider(this.getNotNull(asMap, AwsModule.CREDENTIALS_FILE_PATH, typeName));
            }
            if (this.hasName(ClasspathPropertiesFileCredentialsProvider.class, typeName)) {
                return new ClasspathPropertiesFileCredentialsProvider(this.getNotNull(asMap, AwsModule.CREDENTIALS_FILE_PATH, typeName));
            }
            if (this.hasName(DefaultAWSCredentialsProviderChain.class, typeName)) {
                return new DefaultAWSCredentialsProviderChain();
            }
            if (this.hasName(EnvironmentVariableCredentialsProvider.class, typeName)) {
                return new EnvironmentVariableCredentialsProvider();
            }
            if (this.hasName(SystemPropertiesCredentialsProvider.class, typeName)) {
                return new SystemPropertiesCredentialsProvider();
            }
            if (this.hasName(ProfileCredentialsProvider.class, typeName)) {
                return new ProfileCredentialsProvider();
            }
            if (this.hasName(EC2ContainerCredentialsProviderWrapper.class, typeName)) {
                return new EC2ContainerCredentialsProviderWrapper();
            }
            if (this.hasName(STSAssumeRoleSessionCredentialsProvider.class, typeName)) {
                return new STSAssumeRoleSessionCredentialsProvider.Builder(this.getNotNull(asMap, AwsModule.ROLE_ARN, typeName), this.getNotNull(asMap, AwsModule.ROLE_SESSION_NAME, typeName)).build();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }

        private String getNotNull(Map<String, String> map, String key, String typeName) {
            return (String)Preconditions.checkNotNull((Object)map.get(key), (String)"AWS credentials provider type '%s' is missing '%s'", (Object)typeName, (Object)key);
        }

        private boolean hasName(Class<? extends AWSCredentialsProvider> clazz, String typeName) {
            return clazz.getSimpleName().equals(typeName);
        }
    }

    @JsonDeserialize(using=AWSCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    private static class AWSCredentialsProviderMixin {
        private AWSCredentialsProviderMixin() {
        }
    }
}

