/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.SdkHarnessOptions;
import org.apache.beam.sdk.util.Weighted;
import org.apache.beam.sdk.util.WeightedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheStats;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.RemovalListener;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.RemovalNotification;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Weigher;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Caches {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Caches.class);
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int WEIGHT_RATIO = 6;
    private static final @UnknownKeyFor @NonNull @Initialized long MIN_OBJECT_SIZE = 64L;
    private static final @UnknownKeyFor @NonNull @Initialized long CACHE_SIZE_CHANGE_LIMIT_BYTES = 65536L;
    private static final @UnknownKeyFor @NonNull @Initialized MemoryMeter MEMORY_METER = MemoryMeter.builder().build();
    public static final @UnknownKeyFor @NonNull @Initialized long REFERENCE_SIZE = 8L;

    public static @UnknownKeyFor @NonNull @Initialized long weigh(@UnknownKeyFor @NonNull @Initialized Object o) {
        if (o == null) {
            return 8L;
        }
        if (o instanceof Weighted) {
            return ((Weighted)o).getWeight() + 8L + 8L;
        }
        try {
            return MEMORY_METER.measureDeep(o);
        }
        catch (RuntimeException e) {
            LOG.warn("JVM prevents jamm from accessing subgraph - cache sizes may be underestimated", (Throwable)e);
            return MEMORY_METER.measure(o);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean shouldUpdateOnSizeChange(@UnknownKeyFor @NonNull @Initialized long oldSize, @UnknownKeyFor @NonNull @Initialized long newSize) {
        return !(oldSize <= 64L && newSize <= 64L || newSize - oldSize < 65536L && Long.highestOneBit(oldSize) == Long.highestOneBit(newSize));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Cache<K, V> noop() {
        return Caches.forMaximumBytes(0L);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Cache<K, V> eternal() {
        return Caches.forMaximumBytes(Long.MAX_VALUE);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Cache<K, V> fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return Caches.forMaximumBytes((long)((SdkHarnessOptions)options.as(SdkHarnessOptions.class)).getMaxCacheMemoryUsageMb() << 20);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Cache<K, V> subCache(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache, @UnknownKeyFor @NonNull @Initialized Object keyPrefix, Object ... additionalKeyPrefix) {
        if (cache instanceof SubCache) {
            return new SubCache((org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache<CompositeKey, WeightedValue<Object>>)((SubCache)cache).cache, ((SubCache)cache).keyPrefix.subKey(keyPrefix, additionalKeyPrefix), ((SubCache)cache).maxWeightInBytes, ((SubCache)cache).weightInBytes);
        }
        throw new IllegalArgumentException(String.format("An unsupported type of cache was passed in. Received %s.", cache == null ? "null" : cache.getClass()));
    }

    @VisibleForTesting
    static <K, V> @UnknownKeyFor @NonNull @Initialized Cache<K, V> forMaximumBytes(@UnknownKeyFor @NonNull @Initialized long maximumBytes) {
        LongAdder weightInBytes = new LongAdder();
        return new SubCache(new ShrinkOnEviction((CacheBuilder<CompositeKey, WeightedValue<Object>>)CacheBuilder.newBuilder().maximumWeight(maximumBytes >> 6).weigher((Weigher)new Weigher<CompositeKey, WeightedValue<Object>>(){

            public @UnknownKeyFor @NonNull @Initialized int weigh(@UnknownKeyFor @NonNull @Initialized CompositeKey key, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object> value) {
                long weight = key.getWeight() + value.getWeight() + 120L;
                if ((weight = (weight - 1L >> 6) + 1L) > Integer.MAX_VALUE) {
                    LOG.warn("Entry with size {} MiBs inserted into the cache. This is larger than the maximum individual entry size of {} MiBs. The cache will under report its memory usage by the difference. This may lead to OutOfMemoryErrors.", (Object)((weight - 1L >> 20) + 1L), (Object)131072);
                    return Integer.MAX_VALUE;
                }
                return (int)weight;
            }
        }).concurrencyLevel(1).recordStats(), weightInBytes).getCache(), CompositeKeyPrefix.ROOT, maximumBytes, weightInBytes);
    }

    private static @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object> addWeightedValue(@UnknownKeyFor @NonNull @Initialized CompositeKey key, @UnknownKeyFor @NonNull @Initialized Object o, @UnknownKeyFor @NonNull @Initialized LongAdder weightInBytes) {
        WeightedValue rval;
        long additionalBytes = 0L;
        if (o instanceof WeightedValue) {
            rval = (WeightedValue)o;
        } else if (o instanceof Weighted) {
            rval = WeightedValue.of((Object)o, (long)((Weighted)o).getWeight());
            additionalBytes = 16L;
        } else {
            rval = WeightedValue.of((Object)o, (long)Caches.weigh(o));
            additionalBytes = 16L;
        }
        weightInBytes.add(key.getWeight() + rval.getWeight() + additionalBytes);
        return rval;
    }

    public static class ClearableCache<@UnknownKeyFor K, @UnknownKeyFor V>
    extends SubCache<K, V> {
        private final @UnknownKeyFor @NonNull @Initialized Set<K> weakHashSet = Collections.newSetFromMap(new WeakHashMap());

        public ClearableCache(@UnknownKeyFor @NonNull @Initialized Cache<K, V> cache) {
            super((org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache<CompositeKey, WeightedValue<Object>>)((SubCache)cache).cache, ((SubCache)cache).keyPrefix, ((SubCache)cache).maxWeightInBytes, ((SubCache)cache).weightInBytes);
        }

        @Override
        public V computeIfAbsent(K key, @UnknownKeyFor @NonNull @Initialized Function<K, V> loadingFunction) {
            this.weakHashSet.add(key);
            return super.computeIfAbsent(key, loadingFunction);
        }

        @Override
        public void put(K key, V value) {
            this.weakHashSet.add(key);
            super.put(key, value);
        }

        @Override
        public void remove(K key) {
            this.weakHashSet.remove(key);
            super.remove(key);
        }

        public void clear() {
            for (K key : this.weakHashSet) {
                super.remove(key);
            }
            this.weakHashSet.clear();
        }
    }

    @VisibleForTesting
    static class CompositeKey
    implements Weighted {
        private final @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] namespace;
        private final @UnknownKeyFor @NonNull @Initialized Object key;
        private final @UnknownKeyFor @NonNull @Initialized long weight;

        private CompositeKey(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] namespace, @UnknownKeyFor @NonNull @Initialized long namespaceWeight, @UnknownKeyFor @NonNull @Initialized Object key) {
            this.namespace = namespace;
            this.key = key;
            this.weight = namespaceWeight + Caches.weigh(key);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "CompositeKey{namespace=" + Arrays.toString(this.namespace) + ", key=" + this.key + "}";
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeKey)) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return Arrays.equals(this.namespace, that.namespace) && Objects.equals(this.key, that.key);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Arrays.hashCode(this.namespace);
        }

        public @UnknownKeyFor @NonNull @Initialized long getWeight() {
            return this.weight + 24L + 8L * (long)this.namespace.length;
        }
    }

    static class CompositeKeyPrefix {
        public static final @UnknownKeyFor @NonNull @Initialized CompositeKeyPrefix ROOT = new CompositeKeyPrefix(new Object[0], 0L);
        private final @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] namespace;
        private final @UnknownKeyFor @NonNull @Initialized long weight;

        private CompositeKeyPrefix(@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] namespace, @UnknownKeyFor @NonNull @Initialized long weight) {
            this.namespace = namespace;
            this.weight = weight;
        }

        @UnknownKeyFor @NonNull @Initialized CompositeKeyPrefix subKey(@UnknownKeyFor @NonNull @Initialized Object suffix, Object ... additionalSuffixes) {
            Object[] subKey = new Object[this.namespace.length + 1 + additionalSuffixes.length];
            System.arraycopy(this.namespace, 0, subKey, 0, this.namespace.length);
            subKey[this.namespace.length] = suffix;
            System.arraycopy(additionalSuffixes, 0, subKey, this.namespace.length + 1, additionalSuffixes.length);
            long subKeyWeight = this.weight + Caches.weigh(suffix);
            for (int i = 0; i < additionalSuffixes.length; ++i) {
                subKeyWeight += Caches.weigh(additionalSuffixes[i]);
            }
            return new CompositeKeyPrefix(subKey, subKeyWeight);
        }

        <K> @UnknownKeyFor @NonNull @Initialized CompositeKey valueKey(K k) {
            return new CompositeKey(this.namespace, this.weight, k);
        }

        @UnknownKeyFor @NonNull @Initialized boolean isProperPrefixOf(@UnknownKeyFor @NonNull @Initialized CompositeKey otherKey) {
            if (this.namespace.length > otherKey.namespace.length) {
                return false;
            }
            for (int i = this.namespace.length - 1; i >= 0; --i) {
                if (Objects.equals(this.namespace[i], otherKey.namespace[i])) continue;
                return false;
            }
            return true;
        }

        @UnknownKeyFor @NonNull @Initialized boolean isEquivalentNamespace(@UnknownKeyFor @NonNull @Initialized CompositeKey otherKey) {
            if (this.namespace.length != otherKey.namespace.length) {
                return false;
            }
            for (int i = this.namespace.length - 1; i >= 0; --i) {
                if (Objects.equals(this.namespace[i], otherKey.namespace[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SubCache<@UnknownKeyFor K, @UnknownKeyFor V>
    implements Cache<K, V> {
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache<@UnknownKeyFor @NonNull @Initialized CompositeKey, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object>> cache;
        private final @UnknownKeyFor @NonNull @Initialized CompositeKeyPrefix keyPrefix;
        private final @UnknownKeyFor @NonNull @Initialized long maxWeightInBytes;
        private final @UnknownKeyFor @NonNull @Initialized LongAdder weightInBytes;

        SubCache(@UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache<@UnknownKeyFor @NonNull @Initialized CompositeKey, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object>> cache, @UnknownKeyFor @NonNull @Initialized CompositeKeyPrefix keyPrefix, @UnknownKeyFor @NonNull @Initialized long maxWeightInBytes, @UnknownKeyFor @NonNull @Initialized LongAdder weightInBytes) {
            this.cache = cache;
            this.keyPrefix = keyPrefix;
            this.maxWeightInBytes = maxWeightInBytes;
            this.weightInBytes = weightInBytes;
        }

        @Override
        public V peek(K key) {
            WeightedValue value = (WeightedValue)this.cache.getIfPresent((Object)this.keyPrefix.valueKey(key));
            if (value == null) {
                return null;
            }
            return (V)value.getValue();
        }

        @Override
        public V computeIfAbsent(K key, @UnknownKeyFor @NonNull @Initialized Function<K, V> loadingFunction) {
            try {
                CompositeKey compositeKey = this.keyPrefix.valueKey(key);
                return (V)((WeightedValue)this.cache.get((Object)compositeKey, () -> Caches.addWeightedValue(compositeKey, loadingFunction.apply(key), this.weightInBytes))).getValue();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void put(K key, V value) {
            CompositeKey compositeKey = this.keyPrefix.valueKey(key);
            this.cache.put((Object)compositeKey, (Object)Caches.addWeightedValue(compositeKey, value, this.weightInBytes));
        }

        @Override
        public void remove(K key) {
            this.cache.invalidate((Object)this.keyPrefix.valueKey(key));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String describeStats() {
            CacheStats stats = this.cache.stats();
            return String.format("used/max %d/%d MB, hit %.2f%%, lookups %d, avg load time %.0f ns, loads %d, evictions %d", this.weightInBytes.longValue() >> 20, this.maxWeightInBytes >> 20, stats.hitRate() * 100.0, stats.requestCount(), stats.averageLoadPenalty(), stats.loadCount(), stats.evictionCount());
        }
    }

    @VisibleForTesting
    static class ShrinkOnEviction
    implements RemovalListener<CompositeKey, WeightedValue<Object>> {
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache<@UnknownKeyFor @NonNull @Initialized CompositeKey, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object>> cache;
        private final @UnknownKeyFor @NonNull @Initialized LongAdder weightInBytes;

        ShrinkOnEviction(@UnknownKeyFor @NonNull @Initialized CacheBuilder<@UnknownKeyFor @NonNull @Initialized CompositeKey, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object>> cacheBuilder, @UnknownKeyFor @NonNull @Initialized LongAdder weightInBytes) {
            this.cache = cacheBuilder.removalListener((RemovalListener)this).build();
            this.weightInBytes = weightInBytes;
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache<@UnknownKeyFor @NonNull @Initialized CompositeKey, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object>> getCache() {
            return this.cache;
        }

        public void onRemoval(@UnknownKeyFor @NonNull @Initialized RemovalNotification<@UnknownKeyFor @NonNull @Initialized CompositeKey, @UnknownKeyFor @NonNull @Initialized WeightedValue<@UnknownKeyFor @NonNull @Initialized Object>> removalNotification) {
            this.weightInBytes.add(-(((CompositeKey)removalNotification.getKey()).getWeight() + ((WeightedValue)removalNotification.getValue()).getWeight()));
            if (removalNotification.wasEvicted()) {
                if (!(((WeightedValue)removalNotification.getValue()).getValue() instanceof Cache.Shrinkable)) {
                    return;
                }
                Object updatedEntry = ((Cache.Shrinkable)((WeightedValue)removalNotification.getValue()).getValue()).shrink();
                if (updatedEntry != null) {
                    this.cache.put((Object)((CompositeKey)removalNotification.getKey()), (Object)Caches.addWeightedValue((CompositeKey)removalNotification.getKey(), updatedEntry, this.weightInBytes));
                }
            }
        }
    }
}

